/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.bounding.BoundingBox;
import com.jme.image.Texture;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.turborilla.TransformationProvider;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.components.LineComponent;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.states.GameObjectState;
import com.turborilla.sound.SFX;
import com.turborilla.utils.controllers.SpatialFadeController;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Properties;
import java.util.logging.Logger;

public class CountdownGameObject
extends GameObject {
    private float startLineWidth = 2.5f;
    private float startz = 0.0f;
    private Node node;
    private LineComponent lineComponent;
    private Quad pole;
    private StartLight[] startLight;
    private boolean countingDown = false;
    private float[] countDownTimes = new float[]{1.0f, 0.6f, 0.6f, 0.6f};
    private float currentTime;
    private float replayAITimeAdder = 0.0f;
    private SFX beep;
    private SFX boop;
    private static ColorRGBA fullAlpha = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private static ColorRGBA noAlpha = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f);

    public CountdownGameObject() {
        super("CountdownGameObject");
        this.node = new Node(this.getName() + ":node");
        this.node.setLightCombineMode(0);
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setEnabled(false);
        this.node.setRenderState(zBufferState);
        this.setReplayAITimeAdder(this.countDownTimes[0] + this.countDownTimes[1] + this.countDownTimes[2] + this.countDownTimes[3] - 1.8999999f);
    }

    public void setParentGameState(GameObjectState gameObjectState) {
        super.setParentGameState(gameObjectState);
        if (this.getParentGameState() != null) {
            try {
                this.beep = (SFX)ResourceManager.getInstance().load("sfx", "beep", null);
                this.boop = (SFX)ResourceManager.getInstance().load("sfx", "boop", null);
                this.beep.setVolumeCategory("GameSFXVolume");
                this.boop.setVolumeCategory("GameSFXVolume");
            }
            catch (IOException iOException) {
                Logger.getLogger(CountdownGameObject.class.getCanonicalName()).severe("Could not load beep or boop");
            }
        }
    }

    public void init(float f) {
        Object object;
        Object object2;
        this.node.detachAllChildren();
        this.lineComponent = new LineComponent("Startline", this.startLineWidth, f, "finishline", 6.0f);
        this.addComponent(this.lineComponent);
        this.lineComponent.setListener(new LineComponent.IGameObjectPassedLineListener(){

            public void gameObjectPassedLine(GameObject gameObject, LineComponent lineComponent) {
                CountdownGameObject.this.aGameObjectPassedStartLine(gameObject);
            }
        });
        this.node.attachChild(this.lineComponent.getSpatial());
        float f2 = 20.0f;
        this.pole = new Quad("Pole:Quad", this.startLineWidth, f2);
        this.pole.setLocalTranslation(f, f2 * 0.45f, this.startz);
        this.node.attachChild(this.pole);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        this.pole.setRenderState(alphaState);
        this.pole.setModelBound(new BoundingBox());
        this.pole.updateModelBound();
        Properties properties = new Properties();
        properties.setProperty("textureMinFilter", "MM_LINEAR_NEAREST");
        properties.setProperty("textureMagFilter", "FM_LINEAR");
        properties.setProperty("textureFlip", "false");
        try {
            object2 = (Texture)ResourceManager.getInstance().load("texture", "startpole", properties);
            object = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            ((TextureState)object).setTexture((Texture)object2);
            this.pole.setRenderState((RenderState)object);
        }
        catch (IOException iOException) {
            Logger.getLogger(CountdownGameObject.class.getCanonicalName()).severe("" + iOException);
        }
        object2 = this.pole.getTextureBuffer(0, 0);
        ((FloatBuffer)object2).clear();
        ((FloatBuffer)object2).put(0.0f).put(0.9140625f);
        ((FloatBuffer)object2).put(1.0f).put(0.9140625f);
        ((FloatBuffer)object2).put(1.0f).put(0.546875f);
        ((FloatBuffer)object2).put(0.0f).put(0.546875f);
        ((FloatBuffer)object2).flip();
        object = new float[]{f2 * 0.95f - f2 * 0.13f, f2 * 0.95f - f2 * 0.23f, f2 * 0.95f - f2 * 0.33f, f2 * 0.95f - f2 * 0.43f, f2 * 0.95f - f2 * 0.6f};
        this.startLight = new StartLight[((Object)object).length];
        for (int i = 0; i < ((Object)object).length; ++i) {
            this.startLight[i] = new StartLight();
            String string = "yellow";
            if (i == 3) {
                string = "green";
            }
            if (i == 4) {
                string = "red";
            }
            this.startLight[i].init(string, f2 * 0.17f, f2 * 0.17f);
            this.node.attachChild(this.startLight[i]);
            this.startLight[i].setLocalTranslation(f, (float)object[i], this.startz + 0.02f);
        }
        this.node.updateRenderState();
        this.node.updateGeometricState(0.0f, true);
    }

    public void startCountdown() {
        this.reset();
        this.countingDown = true;
    }

    public void update(float f) {
        super.update(f);
        boolean bl = false;
        if (this.countingDown) {
            float f2 = 0.0f;
            for (int i = 0; i < this.countDownTimes.length; ++i) {
                if (!(this.currentTime < (f2 += this.countDownTimes[i])) || !(this.currentTime + f >= f2)) continue;
                this.startLight[i].setLit(true);
                if (i > 0) {
                    this.startLight[i - 1].setLit(false);
                }
                if (i >= this.countDownTimes.length - 1) {
                    bl = true;
                    this.playBoop();
                } else {
                    this.playBeep();
                }
                i = this.countDownTimes.length;
            }
            this.currentTime += f;
            if (bl) {
                this.countingDown = false;
                this.done();
            }
        }
    }

    public void soundEarlyStart() {
        if (this.countingDown && this.boop != null) {
            this.boop.play(0.5f);
        }
    }

    private void playBeep() {
        if (this.beep != null) {
            this.beep.play();
        }
    }

    private void playBoop() {
        if (this.boop != null) {
            this.boop.play();
        }
    }

    private void done() {
        this.getEventManager().fireEvent("FinishedCountdown");
    }

    private void reset() {
        this.countingDown = false;
        this.currentTime = 0.0f;
        for (int i = 0; i < this.startLight.length; ++i) {
            this.startLight[i].reset();
        }
        this.lineComponent.reset();
    }

    private void aGameObjectPassedStartLine(GameObject gameObject) {
        this.getEventManager().fireEvent("PassedStartline", new String[][]{{"gameObject"}, {gameObject.getName()}});
        if (this.countingDown) {
            this.soundEarlyStart();
            this.reset();
            this.startLight[this.startLight.length - 1].setLit(true);
        }
    }

    public void addObjectToCheckAgainstLine(GameObject gameObject, TransformationProvider[] transformationProviderArray, float[] fArray) {
        this.lineComponent.addObjectToCheckAgainstLine(gameObject, transformationProviderArray, fArray);
    }

    public Node getNode() {
        return this.node;
    }

    public void onDetach() {
        super.onDetach();
    }

    public void setReplayAITimeAdder(float f) {
        this.replayAITimeAdder = f;
    }

    public float getReplayAITimeAdder() {
        return this.replayAITimeAdder;
    }

    private class StartLight
    extends Node {
        Quad unlit;
        Quad lit;
        SpatialFadeController fader;
        float fadeInTime;
        float fadeOutTime;

        public StartLight() {
            super("StartLight");
            this.fadeInTime = 0.1f;
            this.fadeOutTime = 0.1f;
        }

        public void init(String string, float f, float f2) {
            TextureState textureState;
            Object object;
            this.detachAllChildren();
            this.unlit = new Quad("StartLight_" + string + "_unlit:Quad", f, f);
            this.attachChild(this.unlit);
            this.lit = new Quad("StartLight_" + string + "_lit:Quad", f2, f2);
            this.attachChild(this.lit);
            this.lit.setLocalTranslation(0.0f, 0.0f, 0.02f);
            this.unlit.setRenderQueueMode(3);
            this.lit.setRenderQueueMode(3);
            Properties properties = new Properties();
            properties.setProperty("textureMinFilter", "FM_LINEAR");
            properties.setProperty("textureMagFilter", "FM_LINEAR");
            properties.setProperty("textureFlip", "false");
            try {
                object = (Texture)ResourceManager.getInstance().load("texture", "startpole", properties);
                textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                textureState.setTexture((Texture)object);
                this.unlit.setRenderState(textureState);
                AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                alphaState.setBlendEnabled(true);
                alphaState.setSrcFunction(4);
                alphaState.setDstFunction(5);
                this.unlit.setRenderState(alphaState);
            }
            catch (IOException iOException) {
                Logger.getLogger(StartLight.class.getCanonicalName()).severe("" + iOException);
            }
            try {
                object = (Texture)ResourceManager.getInstance().load("texture", "startpole", properties);
                textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                textureState.setTexture((Texture)object);
                this.lit.setRenderState(textureState);
            }
            catch (IOException iOException) {
                Logger.getLogger(StartLight.class.getCanonicalName()).severe("" + iOException);
            }
            object = this.unlit.getTextureBuffer(0, 0);
            ((FloatBuffer)object).clear();
            if (string.equals("yellow")) {
                ((FloatBuffer)object).put(0.546875f).put(0.0f);
                ((FloatBuffer)object).put(0.546875f).put(0.53125f);
                ((FloatBuffer)object).put(0.68359375f).put(0.53125f);
                ((FloatBuffer)object).put(0.68359375f).put(0.0f);
            } else if (string.equals("green")) {
                ((FloatBuffer)object).put(0.0f).put(0.0f);
                ((FloatBuffer)object).put(0.0f).put(0.53125f);
                ((FloatBuffer)object).put(0.13671875f).put(0.53125f);
                ((FloatBuffer)object).put(0.13671875f).put(0.0f);
            } else if (string.equals("red")) {
                ((FloatBuffer)object).put(0.2734375f).put(0.0f);
                ((FloatBuffer)object).put(0.2734375f).put(0.53125f);
                ((FloatBuffer)object).put(0.41015625f).put(0.53125f);
                ((FloatBuffer)object).put(0.41015625f).put(0.0f);
            }
            ((FloatBuffer)object).flip();
            object = this.lit.getTextureBuffer(0, 0);
            ((FloatBuffer)object).clear();
            if (string.equals("yellow")) {
                ((FloatBuffer)object).put(0.68359375f).put(0.0f);
                ((FloatBuffer)object).put(0.68359375f).put(0.53125f);
                ((FloatBuffer)object).put(0.8203125f).put(0.53125f);
                ((FloatBuffer)object).put(0.8203125f).put(0.0f);
            } else if (string.equals("green")) {
                ((FloatBuffer)object).put(0.13671875f).put(0.0f);
                ((FloatBuffer)object).put(0.13671875f).put(0.53125f);
                ((FloatBuffer)object).put(0.2734375f).put(0.53125f);
                ((FloatBuffer)object).put(0.2734375f).put(0.0f);
            } else if (string.equals("red")) {
                ((FloatBuffer)object).put(0.41015625f).put(0.0f);
                ((FloatBuffer)object).put(0.41015625f).put(0.53125f);
                ((FloatBuffer)object).put(0.546875f).put(0.53125f);
                ((FloatBuffer)object).put(0.546875f).put(0.0f);
            }
            ((FloatBuffer)object).flip();
            this.fader = new SpatialFadeController(this.lit);
            this.fader.initRenderStates();
            this.unlit.setModelBound(new BoundingBox());
            this.lit.setModelBound(new BoundingBox());
            this.updateModelBound();
            this.updateRenderState();
            this.reset();
        }

        public void setLit(boolean bl) {
            if (bl) {
                this.fader.fadeTo(fullAlpha, this.fadeInTime);
            } else {
                this.fader.fadeTo(noAlpha, this.fadeOutTime);
            }
        }

        public void reset() {
            this.fader.setColor(noAlpha);
        }
    }
}

