/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.physics.objects.Bike;

public class TurningComponent
extends AbstractComponent {
    protected Bike bike;
    protected float turning = 0.0f;
    protected float turningSpeed = 1.0f;
    protected boolean turned = false;
    protected float turnedAmount = 0.0f;
    protected double minZ = -100.0;
    protected double maxZ = 100.0;

    public TurningComponent(String string, Bike bike) {
        super(string);
        this.bike = bike;
    }

    protected void handleMessages(float f) {
    }

    protected void componentUpdate(float f) {
        if (this.turned) {
            this.turning += this.turningSpeed * this.turnedAmount * f * 35.0f;
            this.turned = false;
        } else if (this.turning < 0.0f) {
            this.turning += this.turningSpeed * f * 15.0f;
            if (this.turning > 0.0f) {
                this.turning = 0.0f;
            }
        } else {
            this.turning -= this.turningSpeed * f * 15.0f;
            if (this.turning < 0.0f) {
                this.turning = 0.0f;
            }
        }
        double d = this.bike.getFrontWheel().getWheelCenter().position.subtract(this.bike.getFrontWheel().getWheelCenter().oldPosition).lengthSquared() * 1000.0;
        double d2 = this.bike.getLockedZvalue() - (double)this.turning * d;
        if (d2 > this.maxZ) {
            d2 = this.maxZ;
        }
        if (d2 < this.minZ) {
            d2 = this.minZ;
        }
        this.bike.setLockedZvalue(d2);
    }

    public void turn(float f) {
        if (this.isPaused()) {
            return;
        }
        this.turnedAmount = f;
        this.turned = true;
    }

    public float getTurningSpeed() {
        return this.turningSpeed;
    }

    public void setTurningSpeed(float f) {
        this.turningSpeed = f;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(double d) {
        this.maxZ = d;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public void setMinZ(double d) {
        this.minZ = d;
    }
}

