/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.msm.components.EngineSoundComponent;
import com.turborilla.msm.components.ThrottleComponent;
import com.turborilla.msm.physics.objects.BikeWheel;
import com.turborilla.sound.SFX;

public class TurboEngineSoundComponent
extends EngineSoundComponent {
    private SFX turboSound;
    private boolean playingTurbo = false;

    public TurboEngineSoundComponent(String string, BikeWheel bikeWheel, ThrottleComponent throttleComponent, SFX sFX, SFX sFX2) {
        super(string, bikeWheel, throttleComponent, sFX);
        this.turboSound = sFX2;
        this.setMinPitch(0.5);
        this.setMaxPitch(2.0);
        this.setMinAngVel(0.0);
        this.setMaxAngVel(120.0);
        if (sFX2 != null) {
            sFX2.setLooping(true);
        }
    }

    protected void setSoundPitch(float f) {
        super.setSoundPitch(f);
        if (this.turboSound == null) {
            return;
        }
        if (f > 1.0f) {
            if (!this.playingTurbo) {
                this.turboSound.play();
                this.playingTurbo = true;
            }
            this.turboSound.setPitch(f);
        } else if (this.playingTurbo) {
            this.turboSound.stop();
            this.playingTurbo = false;
        }
    }

    protected void pauseSound() {
        super.pauseSound();
        if (this.turboSound != null && this.playingTurbo) {
            this.turboSound.pause();
        }
    }

    protected void playSound() {
        super.playSound();
        if (this.turboSound != null && this.playingTurbo) {
            this.turboSound.play();
        }
    }

    protected void stopSound() {
        super.stopSound();
        if (this.turboSound != null && this.playingTurbo) {
            this.turboSound.stop();
            this.playingTurbo = false;
        }
    }
}

