/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.turborilla.TransformationProvider;
import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.utils.math.Quaternion;
import com.turborilla.utils.math.Vector3d;
import java.util.logging.Logger;

public class SpatialComponent
extends AbstractComponent
implements TransformationProvider {
    private Spatial spatial;
    private Node node;
    private TransformationProvider transformationProvider;
    Vector3d localTranslation = new Vector3d();
    Quaternion localRotation = new Quaternion();
    Vector3d localScale = new Vector3d();

    public SpatialComponent(String string) {
        this(string, null, null);
    }

    public SpatialComponent(String string, Spatial spatial) {
        this(string, spatial, null);
    }

    public SpatialComponent(String string, Spatial spatial, TransformationProvider transformationProvider) {
        super(string);
        this.spatial = spatial;
        this.createNode();
        this.transformationProvider = transformationProvider;
        this.setPriority(10000);
    }

    private void createNode() {
        if (this.spatial != null) {
            if (this.node != null) {
                this.node.detachAllChildren();
            }
            this.node = new Node();
            this.node.attachChild(this.spatial);
        }
    }

    public boolean attachThisToNode(Node node) {
        if (this.node == null) {
            Logger.getLogger(SpatialComponent.class.getName()).warning("Tried to add this SpatialComponent's node to another node, but this SpatialComponent has no node yet");
            return false;
        }
        node.attachChild(this.node);
        return true;
    }

    protected void componentUpdate(float f) {
        if (this.transformationProvider != null && this.node != null) {
            this.node.setLocalTranslation(this.transformationProvider.getLocalTranslation().toVector3f(this.node.getLocalTranslation()));
            this.node.setLocalRotation(this.transformationProvider.getLocalRotation().toFloatQuaternion(this.node.getLocalRotation()));
            this.node.setLocalScale(this.transformationProvider.getLocalScale().toVector3f(this.node.getLocalScale()));
        }
    }

    protected void handleMessages(float f) {
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
        this.createNode();
    }

    public TransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(TransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
    }

    public Vector3d getLocalTranslation() {
        return this.localTranslation.set(this.node.getLocalTranslation());
    }

    public Quaternion getLocalRotation() {
        return this.localRotation.set(this.node.getLocalRotation());
    }

    public Vector3d getLocalScale() {
        return this.localScale.set(this.node.getLocalScale());
    }

    public Vector3d getWorldTranslation() {
        return this.localTranslation.set(this.node.getWorldTranslation());
    }

    public Quaternion getWorldRotation() {
        return this.localRotation.set(this.node.getWorldRotation());
    }

    public Vector3d getWorldScale() {
        return this.localScale.set(this.node.getWorldScale());
    }

    public Node getNode() {
        return this.node;
    }
}

