/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.util.Timer;
import com.jmex.audio.event.TrackStateListener;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.components.SpecialAbilityComponent;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.sound.SFX;
import java.io.IOException;
import java.util.logging.Logger;

public class SlowMotionComponent
extends SpecialAbilityComponent {
    private boolean inSlowmotion = false;
    private int initialSlowMotionsLeft;
    private int slowmotionsLeft = this.initialSlowMotionsLeft = 1;
    private float duration = 0.0f;
    private float factor = 1.0f;
    private float fadeTime = 0.5f;
    private float volumeFadeTime = 1.0f;
    private float timeElapsed = 0.0f;
    private float stateOldTpfFactor = 1.0f;
    private boolean enabled = true;
    private SFX tictoc;
    private TrackStateListener tictocFadeListener;
    private float startedAtTime = 0.0f;
    private static final String EVENT_PITCH = "ChangePitch";
    private String[][] pitchArguments = new String[][]{{"factor", "time"}, {"1.0", String.valueOf(this.fadeTime)}};
    private boolean shouldResetPitch = true;
    private static final String EVENT_TEMP_FADEOUT = "TemporaryFadeOut";
    private static final String EVENT_TEMP_FADEIN = "FadeBackIn";
    private String[] fadeCategories = new String[]{"GamePlayerEngineVolume", "GameOpponentEngineVolume"};
    private String[][] fadeArguments = new String[][]{{"category", "time"}, {"", String.valueOf(this.fadeTime)}};
    private boolean shouldResetFade = true;

    public SlowMotionComponent(String string, float f, float f2) {
        super(string);
        this.duration = f2;
        this.factor = f;
        try {
            this.tictoc = (SFX)ResourceManager.getInstance().load("sfx", "tic_toc_final", null);
            this.tictoc.setLooping(true);
        }
        catch (IOException iOException) {
            Logger.getLogger(SlowMotionComponent.class.getName()).severe("Could not load tic toc sound. Exception: " + iOException);
            this.tictoc = null;
        }
    }

    public void triggerSpecialAbility() {
        this.doSlowMotion();
        if (this.getTriggerListener() != null) {
            this.getTriggerListener().triggered(this);
        }
    }

    public void init() {
    }

    public void doSlowMotion() {
        if (this.isPaused() || !this.isEnabled()) {
            return;
        }
        if (!this.inSlowmotion) {
            this.startSlowMotion();
        }
    }

    private boolean startSlowMotion() {
        EventManager eventManager;
        if (this.slowmotionsLeft <= 0 || this.inSlowmotion) {
            return false;
        }
        --this.slowmotionsLeft;
        this.inSlowmotion = true;
        this.timeElapsed = 0.0f;
        this.stateOldTpfFactor = this.getGameObject().getParentGameState().getTpfFactor();
        this.startedAtTime = Timer.getTimer().getTimeInSeconds();
        if (this.tictoc != null) {
            this.tictoc.play();
        }
        if ((eventManager = this.getGameObject().getParentGameState().getGlobalEventManager()) != null) {
            this.pitchArguments[1][0] = Float.toString(this.factor);
            eventManager.fireEvent(EVENT_PITCH, this.pitchArguments);
            for (int i = 0; i < this.fadeCategories.length; ++i) {
                this.fadeArguments[1][0] = this.fadeCategories[i];
                this.fadeArguments[1][1] = String.valueOf(this.volumeFadeTime);
                eventManager.fireEvent(EVENT_TEMP_FADEOUT, this.fadeArguments);
            }
        }
        this.shouldResetPitch = true;
        this.shouldResetFade = true;
        return true;
    }

    private void stopSlowMotion() {
        if (this.shouldResetPitch) {
            this.pitchBack();
        }
        if (this.shouldResetFade) {
            this.fadeBack();
        }
        this.shouldResetPitch = false;
        this.shouldResetFade = false;
        this.endSlowMotion();
    }

    private void endSlowMotion() {
        this.inSlowmotion = false;
        this.getGameObject().getParentGameState().setTpfFactor(this.stateOldTpfFactor);
        if (this.tictoc.isPlaying()) {
            this.tictoc.stop();
        }
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
    }

    protected void componentUpdate(float f) {
        if (this.inSlowmotion) {
            this.timeElapsed += f;
            if (this.timeElapsed > this.duration) {
                this.endSlowMotion();
                return;
            }
            float f2 = 1.0f;
            float f3 = this.duration - this.timeElapsed;
            if (this.timeElapsed < this.fadeTime) {
                f2 = this.factor + (this.fadeTime - this.timeElapsed) / this.fadeTime * (this.stateOldTpfFactor - this.factor);
            } else if (f3 < this.fadeTime) {
                f2 = this.factor + (this.fadeTime - f3) / this.fadeTime * (this.stateOldTpfFactor - this.factor);
                if (this.shouldResetPitch) {
                    this.pitchBack();
                    this.shouldResetPitch = false;
                }
            } else {
                f2 = this.factor;
            }
            if (f3 < this.volumeFadeTime && this.shouldResetFade) {
                this.fadeBack();
                this.shouldResetFade = false;
            }
            this.getGameObject().getParentGameState().setTpfFactor(f2);
        }
    }

    private void fadeBack() {
        EventManager eventManager = this.getGameObject().getParentGameState().getGlobalEventManager();
        if (eventManager != null) {
            for (int i = 0; i < this.fadeCategories.length; ++i) {
                this.fadeArguments[1][0] = this.fadeCategories[i];
                this.fadeArguments[1][1] = String.valueOf(this.volumeFadeTime);
                eventManager.fireEvent(EVENT_TEMP_FADEIN, this.fadeArguments);
            }
        }
    }

    private void pitchBack() {
        EventManager eventManager = this.getGameObject().getParentGameState().getGlobalEventManager();
        if (eventManager != null) {
            this.pitchArguments[1][0] = Float.toString(1.0f);
            eventManager.fireEvent(EVENT_PITCH, this.pitchArguments);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void reset() {
        this.stopSlowMotion();
        this.slowmotionsLeft = this.initialSlowMotionsLeft;
    }
}

