/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.physics.collision.ConstraintCollisionObject;
import com.turborilla.msm.physics.objects.BikeRider;
import com.turborilla.sound.CompositeSFX;
import com.turborilla.utils.math.Vector3d;

public class RiderSoundComponent
extends AbstractComponent {
    private CompositeSFX sfx;
    private ConstraintCollisionObject collider;
    private BikeRider rider;
    private double collisionThreshold = 1.0E-6;
    private double pitchRandomizerAmount = 0.25;
    private double volumeRandomizerAmount = 0.4f;
    private boolean prevInContact = false;
    private float timeNotInContact = 0.0f;
    private Vector3d tempVec = new Vector3d();

    public RiderSoundComponent(String string, ConstraintCollisionObject constraintCollisionObject, BikeRider bikeRider, CompositeSFX compositeSFX) {
        super(string);
        this.sfx = compositeSFX;
        this.collider = constraintCollisionObject;
        this.rider = bikeRider;
    }

    protected void componentUpdate(float f) {
        boolean bl = this.collider.isInContact();
        if (bl) {
            if (!this.prevInContact && this.timeNotInContact > 0.1f) {
                this.timeNotInContact = 0.0f;
                if (!this.sfx.isPlaying()) {
                    this.tempVec.set(this.rider.getShoulder().getOldPosition()).subtractLocal(this.rider.getShoulder().getPosition());
                    double d = this.tempVec.lengthSquared();
                    this.tempVec.set(this.rider.getAss().getOldPosition()).subtractLocal(this.rider.getAss().getPosition());
                    double d2 = this.tempVec.lengthSquared();
                    double d3 = Math.max(d, d2);
                    if (d3 > this.collisionThreshold) {
                        float f2 = (float)(1.0 + Math.random() * this.pitchRandomizerAmount - this.pitchRandomizerAmount * 0.5);
                        this.sfx.play(f2);
                    }
                }
                this.prevInContact = true;
            }
        } else {
            this.prevInContact = false;
            this.timeNotInContact += f;
        }
    }
}

