/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.replay.nioreplay.BaseReplayData;
import com.turborilla.replay.nioreplay.NioReplay;
import com.turborilla.utils.folders.SystemFolder;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class ReplayComponent
extends AbstractComponent {
    private static ByteBuffer[] buffers;
    private static int freeBufferIndex;
    private NioReplay replay = null;

    public ReplayComponent(String string) {
        this(string, null);
    }

    public ReplayComponent(String string, Runnable runnable) {
        super(string);
        if (freeBufferIndex < 0) {
            buffers = new ByteBuffer[6];
            freeBufferIndex = 0;
            for (int i = 0; i < buffers.length; ++i) {
                ReplayComponent.buffers[i] = ByteBuffer.allocate(0x500000);
            }
        }
        this.setPriority(100000);
        ByteBuffer byteBuffer = buffers[freeBufferIndex];
        if (++freeBufferIndex >= buffers.length) {
            freeBufferIndex = 0;
        }
        byteBuffer.clear();
        this.replay = new NioReplay(byteBuffer, 4);
        this.replay.setReplayDoneListener(runnable);
    }

    public void init() {
    }

    protected void componentUpdate(float f) {
        this.replay.update(f);
    }

    public NioReplay getReplay() {
        return this.replay;
    }

    public void setReplay(NioReplay nioReplay) {
        Runnable runnable = null;
        if (this.replay != null) {
            Iterator<BaseReplayData> iterator = this.replay.getReplayElementsIterator();
            while (iterator.hasNext()) {
                nioReplay.addReplayElement(iterator.next());
            }
            this.replay.stopRecording();
            this.replay.stopReplaying();
            runnable = this.replay.getReplayDoneListener();
        }
        this.replay = nioReplay;
        if (this.replay != null) {
            this.replay.setReplayDoneListener(runnable);
        }
    }

    public NioReplay setReplay(String string) throws IOException {
        File file = new File(SystemFolder.getReplayFolder(null));
        File file2 = new File(file, string);
        this.setReplay((NioReplay)BinaryImporter.getInstance().load(file2));
        return this.getReplay();
    }

    public void startRecording() {
        if (this.replay == null) {
            return;
        }
        this.replay.startRecording();
    }

    public void stopRecording() {
        if (this.replay == null) {
            return;
        }
        this.replay.stopRecording();
    }

    public void startReplaying() {
        if (this.replay == null) {
            return;
        }
        this.replay.startReplaying();
    }

    public void stopReplaying() {
        if (this.replay == null) {
            return;
        }
        this.replay.stopReplaying();
    }

    public void saveReplay(String string) throws IOException {
        if (this.replay == null) {
            return;
        }
        File file = new File(SystemFolder.getReplayFolder(null));
        File file2 = new File(file, string);
        BinaryExporter.getInstance().save((Savable)this.replay, file2);
    }

    public void reset() {
        this.stopReplaying();
        this.stopRecording();
    }

    static {
        freeBufferIndex = -1;
    }
}

