/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.bounding.BoundingBox;
import com.jme.image.Texture;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.TransformationProvider;
import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineComponent
extends AbstractComponent {
    private float lineWidth;
    private float xPos;
    private float ypos = 0.01f;
    private float startz = -0.5f;
    private float endz = 120.0f;
    private Quad line;
    private ArrayList<ObjectMapping> objects;
    private ArrayList<GameObject> passedInOrder;
    private boolean everyObjectPassed = false;
    private String texture;
    private IGameObjectPassedLineListener listener;
    private Texture tex;

    public LineComponent(String string, float f, float f2, String string2, float f3) {
        this(string, f, f2, string2);
        this.startz = f3;
    }

    public LineComponent(String string, float f, float f2, String string2) {
        super(string);
        this.lineWidth = f;
        this.xPos = f2;
        this.texture = string2;
        this.objects = new ArrayList();
        this.passedInOrder = new ArrayList();
    }

    @Override
    public void init() {
        this.tex = null;
        if (this.texture != null) {
            try {
                this.tex = (Texture)ResourceManager.getInstance().load("texture", this.texture, null);
                this.tex.setFilter(0);
            }
            catch (IOException iOException) {
                Logger.getLogger(LineComponent.class.getCanonicalName()).severe("" + iOException);
            }
        }
        this.line = new Quad(this.getName() + "Quad", this.lineWidth, this.endz - this.startz);
        this.line.getLocalRotation().fromAngles(-1.5707964f, 0.0f, 0.0f);
        this.line.setLocalTranslation(this.xPos, this.ypos, this.startz + (this.endz - this.startz) / 2.0f);
        this.line.setModelBound(new BoundingBox());
        this.line.updateModelBound();
        if (this.tex != null) {
            TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            textureState.setTexture(this.tex);
            AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
            alphaState.setBlendEnabled(true);
            alphaState.setSrcFunction(4);
            alphaState.setDstFunction(5);
            this.line.setRenderState(alphaState);
            this.line.setRenderState(textureState);
            this.line.setRenderQueueMode(3);
        } else {
            this.line.setCullMode(2);
        }
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.objects.size(); ++i) {
            this.objects.get(i).reset();
        }
        this.passedInOrder.clear();
        this.everyObjectPassed = false;
    }

    public Spatial getSpatial() {
        return this.line;
    }

    @Override
    protected void componentUpdate(float f) {
        if (!this.everyObjectPassed) {
            this.everyObjectPassed = true;
            block0: for (int i = 0; i < this.objects.size(); ++i) {
                ObjectMapping objectMapping = this.objects.get(i);
                if (objectMapping.passed) continue;
                this.everyObjectPassed = false;
                for (int j = 0; j < objectMapping.transformationProviders.length; ++j) {
                    if (!this.checkIfPassedLine(objectMapping.transformationProviders[j].getWorldTranslation(), objectMapping.radii[j])) continue;
                    objectMapping.passed = true;
                    this.passedInOrder.add(objectMapping.gameObject);
                    if (this.listener == null) continue block0;
                    this.listener.gameObjectPassedLine(objectMapping.gameObject, this);
                    continue block0;
                }
            }
        }
    }

    public void addObjectToCheckAgainstLine(GameObject gameObject, TransformationProvider[] transformationProviderArray, float[] fArray) {
        this.objects.add(new ObjectMapping(gameObject, transformationProviderArray, fArray));
    }

    public void clearObjectsToCheckAgainstLine() {
        this.objects.clear();
        this.reset();
    }

    public ArrayList<GameObject> getPassedLineOrder() {
        return this.passedInOrder;
    }

    public void setListener(IGameObjectPassedLineListener iGameObjectPassedLineListener) {
        this.listener = iGameObjectPassedLineListener;
    }

    public boolean checkIfPassedLine(Vector3d vector3d, float f) {
        return vector3d.x + (double)f + (double)(this.lineWidth * this.line.getWorldScale().x * 0.5f) >= (double)this.line.getWorldTranslation().x;
    }

    private class ObjectMapping {
        public GameObject gameObject;
        public boolean passed;
        public TransformationProvider[] transformationProviders;
        public float[] radii;

        public ObjectMapping(GameObject gameObject, TransformationProvider[] transformationProviderArray, float[] fArray) {
            this.gameObject = gameObject;
            this.transformationProviders = transformationProviderArray;
            this.radii = fArray;
            this.reset();
        }

        public void reset() {
            this.passed = false;
        }
    }

    public static interface IGameObjectPassedLineListener {
        public void gameObjectPassedLine(GameObject var1, LineComponent var2);
    }
}

