/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.scene.Node;
import com.turborilla.msm.components.BoostComponentWithFX;
import com.turborilla.msm.gameobjects.FXGameObject;
import com.turborilla.msm.gameobjects.ParticleFXGameObject;
import com.turborilla.msm.physics.objects.Bike;
import java.io.IOException;
import org.softmed.jops.fileloading.DataFormatException;

public class JumpComponent
extends BoostComponentWithFX {
    private float reloadTime;
    private float timeSinceLastReload;

    public JumpComponent(String string, float f, float f2, Bike bike) {
        super(string, f, f2, bike);
        this.timeSinceLastReload = this.reloadTime = 1.5f;
        this.setInitialExplosion(false);
    }

    public FXGameObject getFX() {
        if (this.particleFXGameObject != null) {
            return this.particleFXGameObject;
        }
        this.particleFXGameObject = new ParticleFXGameObject("jumpFX");
        try {
            this.particleFXGameObject.load("jump");
        }
        catch (IOException iOException) {
            this.particleFXGameObject = null;
        }
        catch (DataFormatException dataFormatException) {
            this.particleFXGameObject = null;
        }
        if (this.particleFXGameObject != null) {
            this.particleFXGameObject.setParticlesWorldOriented(false);
            this.particleFXGameObject.setRepeat(false);
            this.particleFXGameObject.getParticleSystem().setLimited(false);
            this.particleFXGameObject.getNode().setLocalScale(3.5f);
        }
        return this.particleFXGameObject;
    }

    public void triggerSpecialAbility() {
        if (this.timeSinceLastReload < this.reloadTime) {
            return;
        }
        this.amountLeft = this.initialAmount;
        super.triggerSpecialAbility();
        this.timeSinceLastReload = 0.0f;
    }

    protected void componentUpdate(float f) {
        this.timeSinceLastReload += f;
        super.componentUpdate(f);
    }

    protected void setMagnitude(float f) {
        this.bike.setJumpMagnitude(f);
    }

    protected void alignNodeWithBike() {
        if (this.bike != null && this.particleFXGameObject != null) {
            Node node = this.particleFXGameObject.getNode();
            this.bike.getFrame().getFootrest().getPosition().toVector3f(this.tempVec);
            this.bike.getFrame().getLocalRotation().toFloatQuaternion(this.floatQuat);
            this.floatQuat.multLocal(this.angle);
            node.getLocalRotation().set(this.floatQuat);
            node.getLocalTranslation().set(this.tempVec);
        }
    }
}

