/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.components.ThrottleComponent;
import com.turborilla.msm.physics.objects.BikeWheel;
import com.turborilla.sound.SFX;

public class EngineSoundComponent
extends AbstractComponent {
    private BikeWheel wheel;
    private double minPitch;
    private double maxPitch;
    private double minAngVel;
    private double maxAngVel;
    private double randomPitchThreshold = 0.06;
    private double randomPitchAmount = 0.25;
    private double pitchFadeDownRate = 2.0;
    private double pitchFadeUpRate = 8.0;
    private SFX sound;
    private ThrottleComponent throttle;
    private boolean replaying = false;
    private boolean engineStarted = false;
    float replayNoPlayTime = 1.0f;
    private float pitchFromReplay = 1.0f;
    private double pitchRange;
    private double angVelRange;
    private double dPitch;
    private double curPitch;

    public EngineSoundComponent(String string, BikeWheel bikeWheel, ThrottleComponent throttleComponent, SFX sFX) {
        super(string);
        this.wheel = bikeWheel;
        this.throttle = throttleComponent;
        this.setMinPitch(0.2);
        this.setMaxPitch(2.0);
        this.setMinAngVel(0.0);
        this.setMaxAngVel(80.0);
        this.sound = sFX;
        sFX.setLooping(true);
        this.setSoundPitch((float)this.getMinPitch());
        this.pitchFromReplay = (float)this.getMinPitch();
    }

    protected void componentUpdate(float f) {
        if (this.sound == null) {
            return;
        }
        if (!this.replaying) {
            double d;
            this.curPitch = this.sound.getPitch();
            if (this.throttle.isThrottling()) {
                double d2;
                if (!this.sound.isPlaying()) {
                    this.startEngine();
                }
                if ((d2 = this.wheel.getAngularVelocity(f)) < this.minAngVel) {
                    d2 = this.minAngVel;
                }
                if (d2 > this.maxAngVel) {
                    d2 = this.maxAngVel;
                }
                d = this.minPitch + d2 * this.dPitch;
            } else {
                d = this.minPitch;
            }
            if (this.engineStarted) {
                if (this.curPitch < d) {
                    this.curPitch += this.pitchFadeUpRate * (double)f * this.curPitch;
                    if (this.curPitch > this.maxPitch) {
                        this.curPitch = this.maxPitch;
                    }
                } else {
                    this.curPitch -= this.pitchFadeDownRate * (double)f * this.curPitch;
                    if (this.curPitch < this.minPitch + this.randomPitchThreshold) {
                        this.curPitch += (double)((float)(Math.random() * this.randomPitchAmount));
                        if (this.curPitch < this.minPitch) {
                            this.curPitch = this.minPitch;
                        }
                    }
                }
                this.setSoundPitch((float)this.curPitch);
            }
        } else {
            if (!this.sound.isPlaying()) {
                this.replayNoPlayTime -= f;
                if (this.replayNoPlayTime < 0.0f) {
                    this.replayNoPlayTime = 1.0f;
                    this.engineStarted = true;
                    this.playSound();
                }
            }
            this.setSoundPitch(this.pitchFromReplay);
        }
    }

    protected void playSound() {
        this.sound.play();
    }

    protected void pauseSound() {
        this.sound.pause();
    }

    protected void stopSound() {
        this.sound.stop();
    }

    protected void setSoundPitch(float f) {
        this.sound.setPitch(f);
    }

    public void init() {
        super.init();
        this.stopEngine();
    }

    public void onDetach() {
        super.onDetach();
        this.stopEngine();
    }

    public void stopEngine() {
        this.engineStarted = false;
        this.stopSound();
    }

    public void startEngine() {
        this.engineStarted = true;
        this.playSound();
    }

    public void setPaused(boolean bl) {
        super.setPaused(bl);
        if (bl) {
            if (this.sound.isPlaying() && this.engineStarted) {
                this.pauseSound();
            } else if (!this.sound.isPlaying() && this.engineStarted) {
                this.playSound();
            }
        }
    }

    private void updateRanges() {
        this.pitchRange = this.getMaxPitch() - this.getMinPitch();
        this.angVelRange = this.getMaxAngVel() - this.getMinAngVel();
        this.dPitch = this.pitchRange / this.angVelRange;
        this.pitchFromReplay = (float)this.getMinPitch();
    }

    public double getMaxAngVel() {
        return this.maxAngVel;
    }

    public void setMaxAngVel(double d) {
        this.maxAngVel = d;
        this.updateRanges();
    }

    public double getMaxPitch() {
        return this.maxPitch;
    }

    public void setMaxPitch(double d) {
        this.maxPitch = d;
        this.updateRanges();
    }

    public double getMinAngVel() {
        return this.minAngVel;
    }

    public void setMinAngVel(double d) {
        this.minAngVel = d;
        this.updateRanges();
    }

    public double getMinPitch() {
        return this.minPitch;
    }

    public void setMinPitch(double d) {
        this.minPitch = d;
        this.updateRanges();
    }

    public void setPitchFromReplay(double d) {
        this.pitchFromReplay = (float)d;
    }

    public boolean isReplaying() {
        return this.replaying;
    }

    public void setReplaying(boolean bl) {
        this.replaying = bl;
    }

    public double getCurrentPitch() {
        return this.curPitch;
    }
}

