/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.turborilla.msm.components.BoostComponent;
import com.turborilla.msm.gameobjects.FXGameObject;
import com.turborilla.msm.gameobjects.ParticleFXGameObject;
import com.turborilla.msm.physics.objects.Bike;
import java.io.IOException;
import org.softmed.jops.fileloading.DataFormatException;

public class BoostComponentWithFX
extends BoostComponent {
    protected ParticleFXGameObject particleFXGameObject;
    protected Vector3f tempVec = new Vector3f();
    protected Quaternion floatQuat = new Quaternion();
    protected Quaternion angle = new Quaternion(new float[]{(float)Math.PI, 0.0f, 1.5f});

    public BoostComponentWithFX(String string, float f, float f2, Bike bike) {
        super(string, f, f2, bike);
    }

    public FXGameObject getFX() {
        if (this.particleFXGameObject != null) {
            return this.particleFXGameObject;
        }
        this.particleFXGameObject = new ParticleFXGameObject("boostFX");
        try {
            this.particleFXGameObject.load("nitro");
        }
        catch (IOException iOException) {
            this.particleFXGameObject = null;
        }
        catch (DataFormatException dataFormatException) {
            this.particleFXGameObject = null;
        }
        if (this.particleFXGameObject != null) {
            this.particleFXGameObject.setParticlesWorldOriented(false);
            this.particleFXGameObject.setRepeat(false);
            this.particleFXGameObject.getParticleSystem().setLimited(false);
            this.particleFXGameObject.getNode().setLocalScale(3.5f);
        }
        return this.particleFXGameObject;
    }

    public void boost() {
        super.boost();
        if (this.getAmountLeft() > 0.0f && this.particleFXGameObject != null) {
            this.particleFXGameObject.start();
        }
    }

    public void boostAll() {
        if (this.boostAll) {
            return;
        }
        super.boostAll();
        if (this.boostAll && this.particleFXGameObject != null) {
            this.particleFXGameObject.start();
        }
    }

    public void boostAll(float f) {
        super.boostAll(f);
        if (this.boostAll && this.particleFXGameObject != null) {
            this.particleFXGameObject.start();
        }
    }

    protected void componentUpdate(float f) {
        super.componentUpdate(f);
        this.alignNodeWithBike();
    }

    protected void alignNodeWithBike() {
        if (this.bike != null && this.particleFXGameObject != null) {
            Node node = this.particleFXGameObject.getNode();
            this.bike.getFrame().getRearDamperAnchor().getPosition().toVector3f(this.tempVec);
            this.bike.getFrame().getLocalRotation().toFloatQuaternion(this.floatQuat);
            this.floatQuat.multLocal(this.angle);
            node.getLocalRotation().set(this.floatQuat);
            node.getLocalTranslation().set(this.tempVec);
        }
    }

    public void reset() {
        super.reset();
        if (this.particleFXGameObject != null) {
            this.particleFXGameObject.stop();
        }
    }

    protected void boostStopped() {
        super.boostStopped();
    }
}

