/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.system.GameSettings;
import com.turborilla.msm.components.BoostComponent;
import com.turborilla.msm.physics.collision.CollisionGrid;
import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.msm.physics.objects.BikeWheel;
import com.turborilla.msm.track.Track1D;
import com.turborilla.physics.collision.IntersectionResult;
import com.turborilla.physics.particle.Particle;
import com.turborilla.sound.SFX;
import com.turborilla.utils.math.Vector3d;
import java.util.ArrayList;

public class BoostArrowComponent
extends BoostComponent {
    protected float duration = 0.0f;
    protected Track1D track;
    protected final float minRpm = 0.5f;
    protected float rpm = 0.5f;
    protected final float maxRpm = 5.0f;
    private final float invRpmRange = 0.22222222f;
    private GameSettings settings;
    private boolean playing = false;
    private IntersectionResult result = new IntersectionResult();
    private float volume;
    private Vector3d tempVec = new Vector3d();

    public BoostArrowComponent(float f, float f2, Bike bike, Track1D track1D, GameSettings gameSettings) {
        super("BoostArrowComponent", f, f2, bike);
        this.track = track1D;
        this.duration = f;
        this.settings = gameSettings;
        this.setEnabled(true);
    }

    public void setSfx(SFX sFX) {
        super.setSfx(sFX);
        sFX.setLooping(true);
        sFX.setPitch(0.5f);
    }

    protected void componentUpdate(float f) {
        if (this.anyWheelTouching(this.bike)) {
            this.boostAll(this.duration);
            this.rpm += this.rpm * f;
            if (this.rpm > 5.0f) {
                this.rpm = 5.0f;
            }
            float f2 = 0.5f + 1.5f * ((this.rpm - 0.5f) * 0.22222222f);
            if (this.sfx != null && !this.playing) {
                this.playing = true;
                this.sfx.fadeIn(0.1f);
            }
            if (this.sfx != null) {
                this.sfx.setPitch(f2);
            }
        } else {
            this.rpm -= this.rpm * f * 0.2f;
            if (this.rpm < 0.5f) {
                this.rpm = 0.5f;
            }
            if (this.sfx != null && this.playing) {
                this.playing = false;
                this.sfx.fadeOut(0.75f);
            }
        }
        super.componentUpdate(f);
    }

    public void reset() {
        super.reset();
        if (this.sfx != null) {
            this.sfx.stop();
        }
    }

    public void onDetach() {
        super.onDetach();
        if (this.sfx != null) {
            this.sfx.stop();
        }
    }

    public void setPaused(boolean bl) {
        super.setPaused(bl);
        if (this.sfx != null && this.sfx.isPlaying() && bl) {
            this.sfx.pause();
        } else if (this.sfx != null && !bl && this.playing) {
            this.sfx.play();
        }
    }

    private boolean anyWheelTouching(Bike bike) {
        return this.wheelTouching(bike.getFrontWheel()) || this.wheelTouching(bike.getRearWheel());
    }

    private boolean wheelTouching(BikeWheel bikeWheel) {
        boolean bl = false;
        Particle particle = bikeWheel.getWheelCenter();
        CollisionGrid[] collisionGridArray = this.track.getBoostArrowCollisionGrids();
        if (bikeWheel != null) {
            ArrayList<Particle> arrayList = bikeWheel.getParticles();
            for (int i = 0; i < collisionGridArray.length; ++i) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    Particle particle2 = arrayList.get(j);
                    if (particle2 == particle || !(particle2.position.y < particle.position.y)) continue;
                    this.tempVec.set(particle2.position).subtractLocal(particle.position);
                    this.tempVec.multLocal(0.2f);
                    this.tempVec.addLocal(particle2.position);
                    if (!collisionGridArray[i].intersectSegment(particle.position, this.tempVec, this.result)) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
        }
        return bl;
    }
}

