/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.math.Vector2f;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.gameobject.IComponent;
import com.turborilla.msm.components.BailComponent;
import com.turborilla.msm.components.BrakeComponent;
import com.turborilla.msm.components.GyroComponent;
import com.turborilla.msm.components.LeaningComponent;
import com.turborilla.msm.components.SpecialAbilityComponent;
import com.turborilla.msm.components.ThrottleComponent;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.msm.profile.Difficulty;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

public abstract class BikeControlComponent
extends AbstractComponent {
    private static final Logger logger = Logger.getLogger(BikeControlComponent.class.getName());
    protected Queue<IComponent> components;
    protected BikeGameObject bike;
    protected Bike bikeParticleSystem;
    protected ThrottleComponent throttleComponent;
    protected BrakeComponent frontBrakeComponent;
    protected BrakeComponent rearBrakeComponent;
    protected LeaningComponent leaningComponent;
    protected SpecialAbilityComponent specialAbilityComponent;
    protected GyroComponent gyroComponent;
    protected BailComponent bailComponent;
    protected Difficulty difficulty;
    protected boolean ongoingRace = false;
    protected boolean crashing = false;
    private static final String crashed = "Crashed";

    public BikeControlComponent(String string, BikeGameObject bikeGameObject) {
        this(string, bikeGameObject, Difficulty.Arcade);
    }

    public BikeControlComponent(String string, BikeGameObject bikeGameObject, Difficulty difficulty) {
        super(string);
        this.bike = bikeGameObject;
        this.bikeParticleSystem = bikeGameObject.getBikeParticleSystem();
        this.components = new LinkedList<IComponent>();
        this.difficulty = difficulty;
    }

    public BikeControlComponent(String string, BikeGameObject bikeGameObject, Difficulty difficulty, SpecialAbilityComponent specialAbilityComponent) {
        this(string, bikeGameObject, difficulty);
        this.specialAbilityComponent = specialAbilityComponent;
    }

    public void init() {
        this.eventManager.registerListener(crashed, this);
        this.attachComponents();
        this.setBikeControlsEnabled(false);
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.getName().equals(crashed) && receivedEvent.getArgumentValue("gameObject") != null && this.getGameObject() != null && receivedEvent.getArgumentValue("gameObject").equals(this.getGameObject().getName()) && !this.isPaused()) {
            this.setBikeControlsEnabled(false);
        }
    }

    public void setBikeControlsEnabled(boolean bl) {
        this.throttleComponent.setPaused(!bl);
        this.rearBrakeComponent.setPaused(!bl);
        this.frontBrakeComponent.setPaused(!bl);
        if (this.gyroComponent != null) {
            this.gyroComponent.setPaused(!bl);
        }
        if (this.specialAbilityComponent != null) {
            this.specialAbilityComponent.setEnabled(bl);
        }
    }

    public void setBrakeAlways(boolean bl) {
        if (bl) {
            this.rearBrakeComponent.setBrakeAlways(1.0f);
            this.frontBrakeComponent.setBrakeAlways(0.02f);
            this.rearBrakeComponent.setPaused(false);
            this.frontBrakeComponent.setPaused(false);
        } else {
            this.rearBrakeComponent.setBrakeAlways(0.0f);
            this.frontBrakeComponent.setBrakeAlways(0.0f);
        }
    }

    protected GameObject addComponent(IComponent iComponent) {
        if (this.gameObject == null) {
            logger.severe("gameObject is null. Will not work.");
            return null;
        }
        this.components.add(iComponent);
        iComponent.setGameObject(this.gameObject);
        return this.gameObject;
    }

    protected void removeComponent(IComponent iComponent) {
        if (iComponent == null) {
            return;
        }
        iComponent.onDetach();
        this.components.remove(iComponent);
    }

    protected void attachComponents() {
        this.leaningComponent = new LeaningComponent(this.getName() + ":leaningComp", this.bikeParticleSystem.getRider());
        this.leaningComponent.setSpeed(new Vector2f(0.35f, 0.25f));
        this.addComponent(this.leaningComponent);
        this.throttleComponent = new ThrottleComponent(this.getName() + ":throttleComp", this.bikeParticleSystem.getRearWheel(), this.bike.getTorqueFunction());
        this.addComponent(this.throttleComponent);
        this.rearBrakeComponent = new BrakeComponent(this.getName() + ":breakRearWheelComp", this.bikeParticleSystem.getRearWheel(), this.throttleComponent);
        this.rearBrakeComponent.setBrakeStrength(2.0f);
        this.rearBrakeComponent.setMaxBrakeValue(30.0f);
        this.addComponent(this.rearBrakeComponent);
        this.frontBrakeComponent = new BrakeComponent(this.getName() + ":breakFrontWheelComp", this.bikeParticleSystem.getFrontWheel());
        this.frontBrakeComponent.setBrakeStrength(0.25f);
        this.frontBrakeComponent.setMaxBrakeValue(3.0f);
        this.addComponent(this.frontBrakeComponent);
        this.bailComponent = new BailComponent(this.getName() + ":bailComponent", this.bikeParticleSystem);
        this.addComponent(this.bailComponent);
        if (this.specialAbilityComponent != null) {
            this.addComponent(this.specialAbilityComponent);
        }
        if (this.difficulty == Difficulty.Arcade) {
            this.gyroComponent = new GyroComponent(this.bikeParticleSystem, this.leaningComponent);
            this.addComponent(this.gyroComponent);
        }
    }

    protected void componentUpdate(float f) {
        Object[] objectArray = this.components.toArray();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            ((IComponent)object).update(f);
        }
    }

    public void onDetach() {
        super.onDetach();
        IComponent iComponent = null;
        iComponent = this.components.poll();
        while (iComponent != null) {
            iComponent.onDetach();
            iComponent = this.components.poll();
        }
    }

    public ThrottleComponent getThrottleComponent() {
        return this.throttleComponent;
    }

    public BrakeComponent getFrontBrakeComponent() {
        return this.frontBrakeComponent;
    }

    public LeaningComponent getLeaningComponent() {
        return this.leaningComponent;
    }

    public BailComponent getBailComponent() {
        return this.bailComponent;
    }

    public BrakeComponent getRearBrakeComponent() {
        return this.rearBrakeComponent;
    }

    public void setThrottleComponent(ThrottleComponent throttleComponent) {
        this.throttleComponent = throttleComponent;
    }

    public SpecialAbilityComponent getSpecialAbilityComponent() {
        return this.specialAbilityComponent;
    }

    public GyroComponent getGyroComponent() {
        return this.gyroComponent;
    }

    public void changeSpecialAbility(SpecialAbilityComponent specialAbilityComponent) {
        if (this.getSpecialAbilityComponent() != null) {
            this.removeComponent(this.getSpecialAbilityComponent());
        }
        if (specialAbilityComponent != null) {
            this.addComponent(specialAbilityComponent);
        }
        this.specialAbilityComponent = specialAbilityComponent;
    }
}

