/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.math.Vector2f;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.components.BikeControlComponent;
import com.turborilla.msm.gameobjects.BikeGameObject;

public class AIBikeControlComponent
extends BikeControlComponent {
    protected boolean raceStarted = false;
    protected boolean passedFinishline = false;
    private Vector2f leanAddVector = new Vector2f();
    private Vector2f speedVector = new Vector2f();
    protected String raceStartedEvent = "RaceStarted";
    protected String finishedEvent = "PassedFinishline";

    public AIBikeControlComponent(String string, BikeGameObject bikeGameObject) {
        super(string, bikeGameObject);
    }

    protected void processAI() {
        if (this.raceStarted) {
            if (!this.passedFinishline && !this.bikeParticleSystem.isCrashing()) {
                this.throttleComponent.throttling(1.0f);
                if (this.bikeParticleSystem.isAirborne()) {
                    this.leanAddVector.set(0.01f, -0.01f);
                    this.leaningComponent.addLean(this.leanAddVector);
                } else {
                    if (this.bikeParticleSystem.getFrontWheel().getWheelCenter().position.x - this.bikeParticleSystem.getFrontWheel().getWheelCenter().oldPosition.x > 0.03) {
                        this.leanAddVector.set(-0.01f, 0.01f);
                    }
                    this.leaningComponent.addLean(this.leanAddVector);
                }
            }
        } else {
            this.leanAddVector.set(0.1f, -0.1f);
            this.leaningComponent.addLean(this.leanAddVector);
        }
    }

    protected void attachComponents() {
        super.attachComponents();
        this.eventManager.registerListener(this.raceStartedEvent, this);
        this.eventManager.registerListener(this.finishedEvent, this);
    }

    protected void componentUpdate(float f) {
        this.processAI();
        super.componentUpdate(f);
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (this.raceStartedEvent.equals(receivedEvent.getName())) {
            this.raceStarted = true;
        } else if (this.finishedEvent.equals(receivedEvent.getName()) && this.gameObject.getName().equals(receivedEvent.getArgumentValue("gameObject"))) {
            this.passedFinishline = true;
        }
        super.handleEvent(receivedEvent);
    }
}

