/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm;

import com.jme.system.GameSettings;
import com.jme.system.JmeException;
import com.turborilla.game.ExceptionDialog;
import com.turborilla.game.ExceptionHandler;
import com.turborilla.game.TurboJMEGame;
import com.turborilla.msm.DisplayExceptionDialog;
import com.turborilla.utils.Utils;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

class DisplayExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = Logger.getLogger(DisplayExceptionHandler.class.getName());
    private TurboJMEGame game;
    private String errorHost;
    private String errorFile;
    private GameSettings settings;

    public DisplayExceptionHandler(TurboJMEGame turboJMEGame, String string, String string2, GameSettings gameSettings) {
        this.game = turboJMEGame;
        this.errorHost = string;
        this.errorFile = string2;
        this.settings = gameSettings;
    }

    public void uncaughtException(Thread thread, final Throwable throwable) {
        boolean bl = true;
        if (throwable.getMessage().indexOf("openal") != -1) {
            logger.severe("Failed to create openAL, bad sound drivers");
            return;
        }
        this.game.getSettings().setWidth(800);
        this.game.getSettings().setHeight(600);
        this.game.getSettings().setDepth(32);
        this.game.getSettings().setFrequency(60);
        this.game.getSettings().setFullscreen(false);
        this.game.getSettings().setDepthBits(8);
        logger.severe("Failed to create wanted display, next startup will try " + (this.game.getSettings().isFullscreen() ? "fullscreen" : "windowed") + " display: " + this.game.getSettings().getWidth() + "x" + this.game.getSettings().getHeight() + "x" + this.game.getSettings().getDepth() + " @" + this.game.getSettings().getFrequency() + "Hz");
        if (bl) {
            logger.severe("Uncaught Exception: " + throwable + "\nStacktrace: " + Utils.getStackTrace(throwable));
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                            // empty catch block
                        }
                        JDialog jDialog = throwable instanceof JmeException ? new DisplayExceptionDialog("Mad Skills Motocross", throwable, DisplayExceptionHandler.this.errorHost, DisplayExceptionHandler.this.errorFile, DisplayExceptionHandler.this.settings) : new ExceptionDialog("Mad Skills Motocross", throwable, DisplayExceptionHandler.this.errorHost, DisplayExceptionHandler.this.errorFile, DisplayExceptionHandler.this.settings);
                        ExceptionHandler.center(jDialog);
                        jDialog.setVisible(true);
                        jDialog.dispose();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.game.shutdown();
        }
    }
}

