/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm;

import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.turborilla.Updatable;
import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.game.TurboJMEGame;
import java.util.logging.Logger;

public class ChangeDisplayModeEventListener
implements IEventListener,
Updatable {
    protected TurboJMEGame game;
    protected EventManager eventManager;
    protected int oldWidth = 0;
    protected int oldHeight = 0;
    protected int oldBpp = 0;
    protected int oldFrequency = 0;
    protected boolean oldFullscreen = false;
    protected boolean waitingForChangeToApply = false;
    protected String eventToFire = "";
    private String name = "ChangeDisplayModeEventListener";
    private boolean paused = false;

    ChangeDisplayModeEventListener(EventManager eventManager, TurboJMEGame turboJMEGame) {
        this.eventManager = eventManager;
        this.game = turboJMEGame;
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        GameSettings gameSettings = this.game.getSettings();
        if ("ChangeDisplayMode".equals(receivedEvent.getName())) {
            if (this.game != null) {
                this.oldWidth = DisplaySystem.getDisplaySystem().getWidth();
                this.oldHeight = DisplaySystem.getDisplaySystem().getHeight();
                this.oldBpp = DisplaySystem.getDisplaySystem().getBitDepth();
                this.oldFrequency = DisplaySystem.getDisplaySystem().getFrequency();
                this.oldFullscreen = DisplaySystem.getDisplaySystem().isFullScreen();
                gameSettings.setInt("SafeGameWidth", this.oldWidth);
                gameSettings.setInt("SafeGameHeight", this.oldHeight);
                gameSettings.setInt("SafeGameDepth", this.oldBpp);
                gameSettings.setInt("SafeGameFrequency", this.oldFrequency);
                gameSettings.setBoolean("SafeGameFullscreen", this.oldFullscreen);
                gameSettings.setBoolean("ChangingDisplayMode", true);
                Logger.getLogger(ChangeDisplayModeEventListener.class.getCanonicalName()).info("Changing to " + (gameSettings.isFullscreen() ? "fullscreen" : "windowed") + " display: " + gameSettings.getWidth() + "x" + gameSettings.getHeight() + "x" + gameSettings.getDepth() + " @" + gameSettings.getFrequency() + "Hz");
                try {
                    this.game.reinitVideo();
                    if (this.eventManager != null) {
                        this.eventManager.fireEvent(new Event("DisplayModeChanged"));
                    }
                    gameSettings.setBoolean("ChangingDisplayMode", false);
                }
                catch (Exception exception) {
                    Logger.getLogger(ChangeDisplayModeEventListener.class.getCanonicalName()).severe("Could not change to " + (gameSettings.isFullscreen() ? "fullscreen" : "windowed") + " display: " + gameSettings.getWidth() + "x" + gameSettings.getHeight() + "x" + gameSettings.getDepth() + " @" + gameSettings.getFrequency() + "Hz\n" + "Due to Exception: " + exception);
                    gameSettings.setWidth(this.oldWidth);
                    gameSettings.setHeight(this.oldHeight);
                    gameSettings.setDepth(this.oldBpp);
                    gameSettings.setFrequency(this.oldFrequency);
                    gameSettings.setFullscreen(this.oldFullscreen);
                    Logger.getLogger(ChangeDisplayModeEventListener.class.getCanonicalName()).severe("Reverting to " + (gameSettings.isFullscreen() ? "fullscreen" : "windowed") + " display: " + gameSettings.getWidth() + "x" + gameSettings.getHeight() + "x" + gameSettings.getDepth() + " @" + gameSettings.getFrequency() + "Hz");
                    this.game.reinitVideo();
                    gameSettings.setBoolean("ChangingDisplayMode", false);
                    if (this.eventManager != null) {
                        this.eventManager.fireEvent(new Event("DisplayChangeFailed"));
                    }
                    if (this.eventManager != null) {
                        this.eventManager.fireEvent(new Event("DisplayChangeReverted"));
                    }
                }
            }
        } else if ("RevertDisplayChange".equals(receivedEvent.getName()) && this.game != null && this.oldWidth != 0) {
            gameSettings.setWidth(this.oldWidth);
            gameSettings.setHeight(this.oldHeight);
            gameSettings.setDepth(this.oldBpp);
            gameSettings.setFrequency(this.oldFrequency);
            gameSettings.setFullscreen(this.oldFullscreen);
            gameSettings.setBoolean("ChangingDisplayMode", false);
            this.oldWidth = 0;
            this.oldHeight = 0;
            this.oldBpp = 0;
            this.oldFrequency = 0;
            this.oldFullscreen = false;
            Logger.getLogger(ChangeDisplayModeEventListener.class.getCanonicalName()).info("Reverting to " + (gameSettings.isFullscreen() ? "fullscreen" : "windowed") + " display: " + gameSettings.getWidth() + "x" + gameSettings.getHeight() + "x" + gameSettings.getDepth() + " @" + gameSettings.getFrequency() + "Hz");
            try {
                this.game.reinitVideo();
                if (this.eventManager != null) {
                    this.eventManager.fireEvent(new Event("DisplayChangeReverted"));
                }
            }
            catch (Exception exception) {
                Logger.getLogger(ChangeDisplayModeEventListener.class.getCanonicalName()).severe("Could not revert to " + (gameSettings.isFullscreen() ? "fullscreen" : "windowed") + " display: " + gameSettings.getWidth() + "x" + gameSettings.getHeight() + "x" + gameSettings.getDepth() + " @" + gameSettings.getFrequency() + "Hz\n" + "Due to Exception: " + exception);
                exception.printStackTrace();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void update(float f) {
        if (this.paused) {
            return;
        }
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isRemoveMeFromEventmanager() {
        return false;
    }
}

