/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.jops.jme;

import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import com.jme.util.resource.ResourceLocatorTool;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.openmali.FastMath;
import org.softmed.jops.Generator;
import org.softmed.jops.GeneratorBehaviour;
import org.softmed.jops.Particle;

public class ParticleGeneratorMesh
extends TriMesh {
    private Generator generator;
    private TriangleBatch triangleBatch;
    private FloatBuffer vb;
    private FloatBuffer tb;
    private FloatBuffer cb;
    private IntBuffer ib;
    private Camera camera;
    private Quaternion worldRotation = new Quaternion();
    private Vector3f position = new Vector3f();
    private Vector3f cUp = new Vector3f();
    private Vector3f cRight = new Vector3f();
    private Vector3f up = new Vector3f();
    private Vector3f right = new Vector3f();
    private Vector3f mUp = new Vector3f();
    private Vector3f mRight = new Vector3f();
    private Vector3f topLeft = new Vector3f();
    private Vector3f bottomLeft = new Vector3f();
    private Vector3f bottomRight = new Vector3f();
    private Vector2f bl = new Vector2f();
    private Vector2f br = new Vector2f();
    private Vector2f tl = new Vector2f();
    private ColorRGBA color = new ColorRGBA();

    public ParticleGeneratorMesh(Generator generator) {
        this.generator = generator;
        this.init();
    }

    public ParticleGeneratorMesh(String string, Generator generator) {
        super(string);
        this.generator = generator;
        this.init();
    }

    private void init() {
        int n;
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setEnabled(true);
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(this.getBlendFactor(this.generator.getRender().getSourceFactor()));
        alphaState.setDstFunction(this.getBlendFactor(this.generator.getRender().getDestinationFactor()));
        alphaState.setTestEnabled(true);
        alphaState.setReference(0.01f);
        alphaState.setTestFunction(4);
        this.setRenderState(alphaState);
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture(ResourceLocatorTool.locateResource("texture", this.generator.getRender().getTextureName()), 1, 1);
        texture.setWrap(5);
        textureState.setTexture(texture);
        this.setRenderState(textureState);
        this.setRenderQueueMode(0);
        this.setLightCombineMode(0);
        this.setTextureCombineMode(5);
        this.clearBatches();
        this.triangleBatch = new TriangleBatch();
        this.addBatch(this.triangleBatch);
        GeneratorBehaviour generatorBehaviour = this.generator.getGb();
        int n2 = generatorBehaviour.getNumber();
        int n3 = 3 * n2;
        this.vb = BufferUtils.createVector3Buffer(n3);
        this.tb = BufferUtils.createVector2Buffer(n3);
        this.cb = BufferUtils.createColorBuffer(n3);
        this.ib = BufferUtils.createIntBuffer(n2 * 3);
        this.triangleBatch.setVertexBuffer(this.vb);
        this.triangleBatch.setTextureBuffer(this.tb, 0);
        this.triangleBatch.setColorBuffer(this.cb);
        this.triangleBatch.setIndexBuffer(this.ib);
        for (n = 0; n < n2; ++n) {
            this.ib.put(n * 3 + 2);
            this.ib.put(n * 3 + 1);
            this.ib.put(n * 3 + 0);
        }
        this.ib.flip();
        for (n = 0; n < n3; ++n) {
            this.vb.put(0.0f).put(0.0f).put(0.0f);
            this.tb.put(0.0f).put(0.0f);
            this.cb.put(1.0f).put(1.0f).put(1.0f).put(1.0f);
        }
        this.vb.flip();
        this.tb.flip();
        this.cb.flip();
        this.updateRenderState();
    }

    private void update(float f) {
        if (this.triangleBatch != null) {
            this.buildTriangles();
        }
    }

    private void buildTriangles() {
        List<Particle> list = this.generator.getParticles();
        Particle particle = null;
        int n = 0;
        if (!this.generator.isAbsoluteParticleAngle()) {
            this.setCameraVectors();
        }
        for (int i = 0; i < list.size(); ++i) {
            particle = list.get(i);
            if (particle.life < 0.0f && this.generator.isKillParticles()) continue;
            int n2 = n * 3;
            this.buildTriangle(this.vb, n2, particle);
            this.setColor(this.cb, n2, particle);
            this.setTextureCoords(this.tb, n2, particle);
            ++n;
        }
        this.ib.limit(n * 3);
        this.triangleBatch.setTriangleQuantity(n);
        this.triangleBatch.setIndexBuffer(this.ib);
        if (n <= 0) {
            this.triangleBatch.setEnabled(false);
        } else {
            this.triangleBatch.setEnabled(true);
        }
    }

    private void setCameraVectors() {
        if (this.camera != null) {
            this.cUp.set(this.camera.getUp());
            this.cRight.set(this.camera.getLeft());
            this.cUp.normalizeLocal().multLocal(0.5f);
            this.cRight.normalizeLocal().multLocal(-0.5f);
        } else {
            this.cUp.set(0.0f, 0.5f, 0.0f);
            this.cRight.set(0.5f, 0.0f, 0.0f);
        }
        this.worldRotation.set(this.getWorldRotation());
        this.worldRotation.inverseLocal();
        this.worldRotation.multLocal(this.cUp);
        this.worldRotation.multLocal(this.cRight);
    }

    private void buildTriangle(FloatBuffer floatBuffer, int n, Particle particle) {
        if (this.generator.isAbsoluteParticleAngle()) {
            this.buildOrientedTriangle(floatBuffer, n, particle);
        } else {
            this.buildBillboardTriangle(floatBuffer, n, particle);
        }
    }

    private void buildOrientedTriangle(FloatBuffer floatBuffer, int n, Particle particle) {
        float f = particle.size;
        float f2 = particle.width * 0.5f;
        float f3 = particle.height * 0.5f;
        float f4 = particle.angleV - 1.5707964f;
        this.position.set(particle.position.getX(), particle.position.getY(), particle.position.getZ());
        float f5 = FastMath.sin(f4);
        float f6 = FastMath.sin(particle.angleH);
        float f7 = FastMath.sin(particle.angleV);
        float f8 = FastMath.cos(particle.angleH);
        this.up.setX(f8 * f5);
        this.up.setZ(f6 * f5);
        this.up.setY(FastMath.cos(f4));
        this.right.setX(f8 * f7);
        this.right.setZ(f6 * f7);
        this.right.setY(FastMath.cos(particle.angleV));
        this.right.crossLocal(this.up);
        this.constructTriangle(floatBuffer, n, f, f2, f3);
    }

    private void buildBillboardTriangle(FloatBuffer floatBuffer, int n, Particle particle) {
        float f = particle.size;
        float f2 = particle.width * 0.5f;
        float f3 = particle.height * 0.5f;
        this.position.set(particle.position.getX(), particle.position.getY(), particle.position.getZ());
        this.up.set(this.cUp);
        this.right.set(this.cRight);
        this.constructTriangle(floatBuffer, n, f, f2, f3);
    }

    private void constructTriangle(FloatBuffer floatBuffer, int n, float f, float f2, float f3) {
        this.up.multLocal(f3);
        this.right.multLocal(f2);
        this.mUp.set(this.up);
        this.mUp.multLocal(-0.5f);
        this.mRight.set(this.right);
        this.mRight.multLocal(-0.5f);
        this.mUp.addLocal(this.mRight);
        this.topLeft.set(this.up).subtractLocal(this.right).subtractLocal(this.mUp);
        this.up.multLocal(-1.0f);
        this.bottomLeft.set(this.up).subtractLocal(this.right).subtractLocal(this.mUp);
        this.bottomRight.set(this.up).addLocal(this.right).subtractLocal(this.mUp);
        this.topLeft.multLocal(f).addLocal(this.position);
        this.bottomLeft.multLocal(f).addLocal(this.position);
        this.bottomRight.multLocal(f).addLocal(this.position);
        BufferUtils.setInBuffer(this.bottomLeft, floatBuffer, n);
        BufferUtils.setInBuffer(this.bottomRight, floatBuffer, n + 1);
        BufferUtils.setInBuffer(this.topLeft, floatBuffer, n + 2);
    }

    private void setColor(FloatBuffer floatBuffer, int n, Particle particle) {
        this.color.set(particle.color.getRed(), particle.color.getGreen(), particle.color.getBlue(), particle.alpha);
        BufferUtils.setInBuffer(this.color, floatBuffer, n);
        BufferUtils.setInBuffer(this.color, floatBuffer, n + 1);
        BufferUtils.setInBuffer(this.color, floatBuffer, n + 2);
    }

    private void setTextureCoords(FloatBuffer floatBuffer, int n, Particle particle) {
        float f = 1.0f / particle.texWidth;
        float f2 = 1.0f / particle.texHeight;
        this.bl.set(-0.5f, -0.5f);
        this.br.set(1.5f, -0.5f);
        this.tl.set(-0.5f, 1.5f);
        this.rotate2f(this.bl, this.br, this.tl, particle.angle);
        this.bl.set(this.bl.x * f + 0.5f, this.bl.y * f2 + 0.5f);
        this.br.set(this.br.x * f + 0.5f, this.br.y * f2 + 0.5f);
        this.tl.set(this.tl.x * f + 0.5f, this.tl.y * f2 + 0.5f);
        BufferUtils.setInBuffer(this.bl, floatBuffer, n);
        BufferUtils.setInBuffer(this.br, floatBuffer, n + 1);
        BufferUtils.setInBuffer(this.tl, floatBuffer, n + 2);
    }

    private void rotate2f(Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3, float f) {
        float f2 = FastMath.cos(f);
        float f3 = FastMath.sin(f);
        vector2f.set(vector2f.x * f2 - vector2f.y * f3, vector2f.y * f2 + vector2f.x * f3);
        vector2f2.set(vector2f2.x * f2 - vector2f2.y * f3, vector2f2.y * f2 + vector2f2.x * f3);
        vector2f3.set(vector2f3.x * f2 - vector2f3.y * f3, vector2f3.y * f2 + vector2f3.x * f3);
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void updateGeometricState(float f, boolean bl) {
        super.updateGeometricState(f, bl);
        this.update(f);
    }

    protected int getBlendFactor(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 772: {
                return 6;
            }
            case 774: {
                return 2;
            }
            case 770: {
                return 4;
            }
            case 768: {
                return 2;
            }
            case 773: {
                return 7;
            }
            case 775: {
                return 3;
            }
            case 771: {
                return 5;
            }
            case 776: {
                return 8;
            }
            case 769: {
                return 3;
            }
        }
        throw new RuntimeException("GL source blend mode not recognized : " + n);
    }
}

