/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gui.widget.utils;

import com.jme.math.Vector2f;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.IResizableWidget;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseLayout
implements ILayout {
    protected Vector2f position;
    protected float width;
    protected float height;
    protected float margin;
    protected float xPadding = 0.0f;
    protected float yPadding = 0.0f;
    protected ArrayList<IResizableWidget> widgets;
    protected static Vector2f tempVec = new Vector2f();

    @Override
    public void set(Vector2f vector2f, float f, float f2, float f3) {
        this.position = vector2f;
        this.width = f;
        this.height = f2;
        this.margin = f3;
    }

    public BaseLayout() {
        this(1.0f, 1.0f);
    }

    public BaseLayout(float f, float f2) {
        this(new Vector2f(), f, f2, 0.0f);
    }

    public BaseLayout(Vector2f vector2f, float f, float f2, float f3) {
        this.set(vector2f, f, f2, f3);
        this.widgets = new ArrayList();
    }

    @Override
    public boolean add(IResizableWidget iResizableWidget) {
        boolean bl = this.widgets.add(iResizableWidget);
        return bl;
    }

    @Override
    public void add(int n, IResizableWidget iResizableWidget) {
        this.widgets.add(n, iResizableWidget);
    }

    @Override
    public void clear() {
        this.widgets.clear();
    }

    @Override
    public int indexOf(IResizableWidget iResizableWidget) {
        return this.widgets.indexOf(iResizableWidget);
    }

    public Iterator<IResizableWidget> getWidgetIterator() {
        return this.widgets.iterator();
    }

    @Override
    public IResizableWidget remove(int n) {
        if (n < 0 || n >= this.widgets.size()) {
            return null;
        }
        IResizableWidget iResizableWidget = this.widgets.remove(n);
        return iResizableWidget;
    }

    @Override
    public boolean remove(IResizableWidget iResizableWidget) {
        boolean bl = this.widgets.remove(iResizableWidget);
        return bl;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(float f) {
        this.width = f;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(float f) {
        this.height = f;
    }

    @Override
    public void setSize(float f, float f2) {
        boolean bl = f != this.width || f2 != this.height;
        this.width = f;
        this.height = f2;
        this.doLayout();
    }

    @Override
    public Vector2f getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector2f vector2f) {
        this.position.set(vector2f);
    }

    @Override
    public float getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(float f) {
        this.margin = f;
    }

    @Override
    public float getXPadding() {
        return this.xPadding;
    }

    @Override
    public float getYPadding() {
        return this.yPadding;
    }

    @Override
    public void setPadding(float f, float f2) {
        this.xPadding = f;
        this.yPadding = f2;
    }

    @Override
    public void doLayout() {
        tempVec.set(this.position);
        for (int i = 0; i < this.widgets.size(); ++i) {
            IResizableWidget iResizableWidget = this.widgets.get(i);
            if (iResizableWidget == null) continue;
            iResizableWidget.setPosition(tempVec);
            iResizableWidget.setSize(this.width - this.width * this.xPadding, this.height - this.height * this.yPadding);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            if (this.widgets.get(i) == null) continue;
            this.widgets.get(i).setVisible(bl);
        }
    }
}

