/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gui.widget;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.TriggerAction;
import com.turborilla.gui.VerticalAlignment;
import com.turborilla.gui.widget.IWidgetLayer;
import com.turborilla.utils.controllers.SpatialFadeController;
import com.turborilla.utils.controllers.SpatialScaleController;
import com.turborilla.utils.controllers.SpatialTranslationController;
import java.util.logging.Logger;

public abstract class BaseWidgetLayer
extends Node
implements IWidgetLayer {
    protected SpatialFadeController fader;
    protected SpatialTranslationController mover;
    protected SpatialScaleController scaler;
    protected HorisontalAlignment horisontalAlignment = HorisontalAlignment.CENTERED;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.MIDDLE;
    protected float verticalPosition = 0.0f;
    protected float horisontalPosition = 0.0f;
    protected boolean mouseOver = false;
    protected boolean leftMouseDown = false;
    protected static final ColorRGBA defaultColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f);
    protected static final ColorRGBA mouseOverColor = new ColorRGBA(0.8f, 0.0f, 0.0f, 0.7f);
    protected static final ColorRGBA mouseDownColor = new ColorRGBA(0.5f, 0.0f, 0.0f, 0.8f);
    protected static final Vector3f defaultScale = new Vector3f(1.0f, 1.0f, 1.0f);
    protected static final Vector3f mouseOverScale = new Vector3f(1.2f, 1.2f, 1.0f);
    protected static final Vector3f mouseDownScale = new Vector3f(1.15f, 1.15f, 1.0f);
    protected static final float scaleTime = 4.8f;
    protected static final float scaleDamp = 0.1f;
    protected static final float fadeTime = 0.2f;
    protected static final float moveTime = 4.8f;
    protected static final float moveDamp = 0.1f;
    private static Ray ray = new Ray();
    private static Vector3f rayOrigin = new Vector3f();
    private static Vector3f rayDirection = new Vector3f(0.0f, 0.0f, -1.0f);

    public BaseWidgetLayer(String string) {
        super(string);
        this.fader = new SpatialFadeController(this);
        this.fader.initRenderStates();
        this.addController(this.fader);
        this.mover = new SpatialTranslationController(this);
        this.addController(this.mover);
        this.scaler = new SpatialScaleController(this);
        this.addController(this.scaler);
        this.setModelBound(new BoundingBox());
        this.updateModelBound();
        this.fader.setColor(defaultColor);
        this.scaler.setScale(defaultScale);
        this.scaler.setDamping(0.1f);
    }

    public boolean isInside(Vector3f vector3f) {
        this.getSpatial().updateWorldBound();
        BoundingVolume boundingVolume = this.getSpatial().getWorldBound();
        if (boundingVolume == null && (boundingVolume = this.getBoundingBox()) == null) {
            Logger.getLogger(BaseWidgetLayer.class.getName()).severe("BaseWidgetLayer \"" + this.getName() + "\" has no bounding volume. Cannot check for isInsideWidget()");
            return false;
        }
        rayOrigin.set(vector3f.x, vector3f.y, Float.MAX_VALUE);
        ray.setOrigin(rayOrigin);
        ray.setDirection(rayDirection);
        return boundingVolume.intersects(ray);
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public void setMouseOver(boolean bl) {
        this.mouseOver = bl;
    }

    public int attachChild(Spatial spatial) {
        if (spatial.getWorldBound() == null) {
            spatial.setModelBound(new BoundingBox());
            spatial.updateModelBound();
            spatial.updateWorldBound();
        }
        return super.attachChild(spatial);
    }

    public BoundingBox getBoundingBox() {
        this.updateModelBound();
        BoundingVolume boundingVolume = this.getWorldBound();
        if (!(boundingVolume instanceof BoundingBox)) {
            boundingVolume = new BoundingBox();
            this.setModelBound(boundingVolume);
            this.updateModelBound();
        }
        BoundingBox boundingBox = (BoundingBox)this.getWorldBound();
        return boundingBox;
    }

    public SpatialFadeController getFader() {
        return this.fader;
    }

    public SpatialTranslationController getMover() {
        return this.mover;
    }

    public SpatialScaleController getScaler() {
        return this.scaler;
    }

    public Spatial getSpatial() {
        return this;
    }

    public void setHorisontalAlignment(HorisontalAlignment horisontalAlignment) {
        this.horisontalAlignment = horisontalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public HorisontalAlignment getHorisontalAlignment() {
        return this.horisontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public float getHorisontalPosition() {
        return this.horisontalPosition;
    }

    public void setHorisontalPosition(float f) {
        this.horisontalPosition = f;
    }

    public float getVerticalPosition() {
        return this.verticalPosition;
    }

    public void setVerticalPosition(float f) {
        this.verticalPosition = f;
    }

    public void onMiddleMouse(TriggerAction triggerAction) {
    }

    protected void onLeftMouseDown() {
        this.fader.fadeTo(mouseDownColor, 0.2f);
        this.scaler.scaleTo(mouseDownScale, 4.8f, 4.8f);
    }

    protected void onLeftMouseUp() {
        this.fader.fadeTo(mouseOverColor, 0.2f);
        this.scaler.scaleTo(mouseOverScale, 4.8f, 4.8f);
    }

    public void onLeftMouse(TriggerAction triggerAction) {
        if (triggerAction.action == TriggerAction.Action.DOWN) {
            this.setLeftMouseDown(true);
            this.onLeftMouseDown();
        } else if (triggerAction.action == TriggerAction.Action.UP) {
            this.setLeftMouseDown(false);
            this.onLeftMouseUp();
        }
    }

    public void onMouseOut() {
        this.fader.fadeTo(defaultColor, 0.2f);
        this.scaler.scaleTo(defaultScale, 4.8f, 4.8f);
    }

    public void onMouseOver() {
        this.fader.fadeTo(mouseOverColor, 0.2f);
        this.scaler.scaleTo(mouseOverScale, 4.8f, 4.8f);
    }

    public void onMouseMove(Vector3f vector3f) {
    }

    public void onRightMouse(TriggerAction triggerAction) {
    }

    public boolean isLeftMouseDown() {
        return this.leftMouseDown;
    }

    public void setLeftMouseDown(boolean bl) {
        this.leftMouseDown = bl;
    }
}

