/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gui;

import com.jme.bounding.BoundingBox;
import com.jme.input.InputHandler;
import com.jme.input.MouseInput;
import com.jme.math.FastMath;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.util.GameTaskQueueManager;
import com.turborilla.Updatable;
import com.turborilla.gui.GuiAbsoluteMouse;
import com.turborilla.gui.GuiKeyboard;
import com.turborilla.gui.IGuiListener;
import com.turborilla.gui.TriggerAction;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.IWidget;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiHandler
implements Updatable {
    private GuiAbsoluteMouse cursor;
    private GuiKeyboard keyboard;
    private Node node;
    private InputHandler input;
    private Vector2f mouseLimit;
    private ArrayList<IWidget> widgets;
    private boolean snapToGrid = false;
    private int gridSpacingX = 30;
    private int gridSpacingY = 30;
    private IGuiListener listener = null;
    private float minMouseActivation = 3.0f;
    public TriggerAction[] mouseButtonStatus = new TriggerAction[3];
    public TriggerAction[] keyStatus = new TriggerAction[256];
    private char[] keyTyped = new char[256];
    private double doubleClickTime = 0.3;
    private long[] timeOfLatestClick = new long[3];
    private IWidget focusedWidget = null;
    private IWidget activeWidget = null;
    private IWidget modalWidget = null;
    private int leftMouseButtonIndex = 0;
    private Vector3f previousMousePosition = new Vector3f();
    private Vector3f tempVec = new Vector3f();
    private boolean handleSpecialKeys = true;
    private boolean paused = false;
    private static Cursor customCursor;
    private static int mouseX;
    private static int mouseY;

    public GuiHandler(Vector2f vector2f, InputHandler inputHandler, URL uRL, Vector3f vector3f) {
        this.input = inputHandler;
        this.mouseLimit = vector2f;
        this.widgets = new ArrayList();
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        this.cursor = new GuiAbsoluteMouse("cursor", (int)FastMath.floor(vector2f.x), (int)FastMath.floor(vector2f.y), this, uRL, (int)vector3f.x, (int)vector3f.y);
        this.cursor.registerWithInputHandler(inputHandler);
        customCursor = Mouse.getNativeCursor();
        this.node = new Node();
        this.keyboard = new GuiKeyboard(this);
        this.keyboard.registerWithInputHandler(inputHandler);
        this.node.setRenderQueueMode(4);
        this.node.setCullMode(3);
        this.node.updateRenderState();
        this.node.setModelBound(new BoundingBox());
        this.node.updateWorldBound();
        this.resetStatus();
    }

    void onMouseUp(int n, Vector3f vector3f) {
        IWidget iWidget = null;
        iWidget = n == this.leftMouseButtonIndex && this.activeWidget != null ? this.activeWidget : this.getWidgetForPosition(vector3f, true, false);
        switch (n) {
            case 0: {
                if (iWidget != null) {
                    iWidget.onLeftMouseUp(vector3f);
                }
                if (this.getListener() == null) break;
                this.getListener().onLeftMouseUp(vector3f, iWidget != null);
                break;
            }
            case 2: {
                if (iWidget != null) {
                    iWidget.onMiddleMouseUp(vector3f);
                }
                if (this.getListener() == null) break;
                this.getListener().onMiddleMouseUp(vector3f, iWidget != null);
                break;
            }
            case 1: {
                if (iWidget != null) {
                    iWidget.onRightMouseUp(vector3f);
                }
                if (this.getListener() == null) break;
                this.getListener().onMiddleMouseUp(vector3f, iWidget != null);
            }
        }
        if (n == this.leftMouseButtonIndex) {
            this.activateWidget(null);
        }
    }

    void onMouseDown(int n, Vector3f vector3f) {
        IWidget iWidget = this.getWidgetForPosition(vector3f, true, false);
        switch (n) {
            case 0: {
                if (iWidget != null) {
                    iWidget.onLeftMouseDown(vector3f);
                }
                if (this.getListener() == null) break;
                this.getListener().onLeftMouseDown(vector3f, iWidget != null);
                break;
            }
            case 2: {
                if (iWidget != null) {
                    iWidget.onMiddleMouseDown(vector3f);
                }
                if (this.getListener() == null) break;
                this.getListener().onMiddleMouseDown(vector3f, iWidget != null);
                break;
            }
            case 1: {
                if (iWidget != null) {
                    iWidget.onRightMouseDown(vector3f);
                }
                if (this.getListener() == null) break;
                this.getListener().onRightMouseDown(vector3f, iWidget != null);
            }
        }
        if (n == this.leftMouseButtonIndex) {
            if (iWidget != null && iWidget.isFocusable()) {
                this.focusWidget(iWidget);
            } else {
                this.focusWidget(this.getWidgetForPosition(vector3f, false, true));
            }
            if (iWidget != null && iWidget.isActivatable()) {
                this.activateWidget(iWidget);
            } else {
                this.activateWidget(this.getWidgetForPosition(vector3f, true, false));
            }
        }
    }

    void onMouseClicked(int n, Vector3f vector3f) {
        IWidget iWidget = this.getWidgetForPosition(vector3f, true, false);
        if (iWidget != null && (n != this.leftMouseButtonIndex || iWidget == this.activeWidget)) {
            switch (n) {
                case 0: {
                    iWidget.onLeftMouseClicked(vector3f);
                    if (this.getListener() == null) break;
                    this.getListener().onLeftMouseClicked(vector3f, true);
                    break;
                }
                case 2: {
                    iWidget.onMiddleMouseClicked(vector3f);
                    if (this.getListener() == null) break;
                    this.getListener().onMiddleMouseClicked(vector3f, true);
                    break;
                }
                case 1: {
                    iWidget.onRightMouseClicked(vector3f);
                    if (this.getListener() == null) break;
                    this.getListener().onRightMouseClicked(vector3f, true);
                }
            }
        } else {
            switch (n) {
                case 0: {
                    if (this.getListener() == null) break;
                    this.getListener().onLeftMouseClicked(vector3f, false);
                    break;
                }
                case 2: {
                    if (this.getListener() == null) break;
                    this.getListener().onMiddleMouseClicked(vector3f, false);
                    break;
                }
                case 1: {
                    if (this.getListener() == null) break;
                    this.getListener().onRightMouseClicked(vector3f, false);
                }
            }
        }
    }

    void onMouseDoubleClicked(int n, Vector3f vector3f) {
        IWidget iWidget = this.getWidgetForPosition(vector3f, true, false);
        if (iWidget != null && (n != this.leftMouseButtonIndex || iWidget == this.activeWidget)) {
            switch (n) {
                case 0: {
                    iWidget.onLeftMouseDoubleClicked(vector3f);
                    if (this.getListener() == null) break;
                    this.getListener().onLeftMouseClicked(vector3f, true);
                    break;
                }
                case 2: {
                    iWidget.onMiddleMouseDoubleClicked(vector3f);
                    if (this.getListener() == null) break;
                    this.getListener().onMiddleMouseClicked(vector3f, true);
                    break;
                }
                case 1: {
                    iWidget.onRightMouseDoubleClicked(vector3f);
                    if (this.getListener() == null) break;
                    this.getListener().onRightMouseClicked(vector3f, true);
                }
            }
        } else {
            switch (n) {
                case 0: {
                    if (this.getListener() == null) break;
                    this.getListener().onLeftMouseDoubleClicked(vector3f, false);
                    break;
                }
                case 2: {
                    if (this.getListener() == null) break;
                    this.getListener().onMiddleMouseDoubleClicked(vector3f, false);
                    break;
                }
                case 1: {
                    if (this.getListener() == null) break;
                    this.getListener().onRightMouseDoubleClicked(vector3f, false);
                }
            }
        }
    }

    private void insideOutsideWidget(IWidget iWidget, Vector3f vector3f, boolean bl, IWidget iWidget2) {
        boolean bl2;
        if (iWidget == null) {
            return;
        }
        if (this.isBlockedByModal(iWidget)) {
            return;
        }
        boolean bl3 = bl2 = iWidget2 == null || iWidget2 == iWidget;
        if (iWidget.isInside(vector3f)) {
            iWidget.onMouseMove(vector3f, bl2);
            if (!iWidget.isMouseOver()) {
                iWidget.setMouseOver(true);
                iWidget.onMouseOver(bl2);
            }
        } else {
            if (bl) {
                iWidget.onMouseMove(vector3f, bl2);
            }
            if (iWidget.isMouseOver()) {
                iWidget.setMouseOver(false);
                iWidget.onMouseOut();
            }
        }
        if (iWidget.isEnabled()) {
            this.insideOutsideWidgetList(iWidget.getLayers(), vector3f, iWidget2);
        }
    }

    private void insideOutsideWidgetList(ArrayList<IWidget> arrayList, Vector3f vector3f, IWidget iWidget) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IWidget iWidget2 = arrayList.get(i);
            this.insideOutsideWidget(iWidget2, vector3f, false, iWidget);
        }
    }

    void onMouseMove(Vector3f vector3f) {
        if (this.activeWidget == null) {
            this.insideOutsideWidgetList(this.widgets, vector3f, this.getWidgetForPosition(vector3f, false, true));
            if (this.getListener() != null) {
                this.getListener().onMouseMove(vector3f, false);
            }
        } else {
            IWidget iWidget = this.activeWidget;
            this.insideOutsideWidget(iWidget, vector3f, true, this.getWidgetForPosition(vector3f, false, true));
            if (this.getListener() != null) {
                this.getListener().onMouseMove(vector3f, true);
            }
        }
    }

    boolean onKeyDown(int n, char c) {
        boolean bl = false;
        if (this.focusedWidget != null) {
            bl = this.focusedWidget.onKeyDown(n, c);
        }
        if (this.getListener() != null) {
            bl = this.getListener().onKeyDown(n, c, bl) || bl;
        }
        return bl;
    }

    boolean onKeyUp(int n, char c) {
        boolean bl = false;
        if (this.focusedWidget != null) {
            bl = this.focusedWidget.onKeyUp(n, c);
        }
        if (this.getListener() != null) {
            bl = this.getListener().onKeyUp(n, c, bl) || bl;
        }
        return bl;
    }

    boolean onKeyTyped(int n, char c) {
        boolean bl = false;
        if (this.focusedWidget != null) {
            bl = this.focusedWidget.onKeyTyped(n, c);
        }
        if (this.getListener() != null) {
            bl = this.getListener().onKeyTyped(n, c, bl) || bl;
        }
        return bl;
    }

    void updatedMousePosition(Vector3f vector3f) {
        if (!vector3f.equals(this.previousMousePosition)) {
            if (this.tempVec.set(vector3f).subtractLocal(this.previousMousePosition).lengthSquared() > this.minMouseActivation * this.minMouseActivation) {
                this.previousMousePosition.set(vector3f);
                this.onMouseMove(vector3f);
            } else {
                for (int i = 0; i < this.widgets.size(); ++i) {
                    this.onMouseMoveIfWidgetIsMoving(this.widgets.get(i), vector3f);
                }
            }
        }
    }

    void onMouseMoveIfWidgetIsMoving(IWidget iWidget, Vector3f vector3f) {
        if (!iWidget.isEnabled()) {
            return;
        }
        if (iWidget.isMoving()) {
            IWidget iWidget2 = this.getWidgetForPosition(vector3f, false, true);
            this.insideOutsideWidget(iWidget, vector3f, false, iWidget2);
            this.insideOutsideWidgetList(iWidget.getLayers(), vector3f, iWidget2);
        } else {
            ArrayList<IWidget> arrayList = iWidget.getLayers();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.onMouseMoveIfWidgetIsMoving(arrayList.get(i), vector3f);
            }
        }
    }

    void updatedMouseButton(int n, TriggerAction triggerAction) {
        if (triggerAction.worldMousePos != null) {
            this.mouseButtonStatus[n].worldMousePos.set(triggerAction.worldMousePos);
        }
        if (triggerAction.action == TriggerAction.Action.DOWN && this.mouseButtonStatus[n].action == TriggerAction.Action.UP) {
            this.onMouseDown(n, triggerAction.worldMousePos);
        }
        if (triggerAction.action == TriggerAction.Action.UP) {
            if (this.mouseButtonStatus[n].action == TriggerAction.Action.DOWN) {
                long l = System.nanoTime();
                if (this.timeOfLatestClick[n] > 0L && l - this.timeOfLatestClick[n] < (long)(this.doubleClickTime * 1.0E9)) {
                    this.onMouseDoubleClicked(n, triggerAction.worldMousePos);
                } else {
                    this.onMouseClicked(n, triggerAction.worldMousePos);
                }
                this.timeOfLatestClick[n] = l;
            }
            this.onMouseUp(n, triggerAction.worldMousePos);
        }
        this.mouseButtonStatus[n].action = triggerAction.action;
    }

    void updatedKey(int n, char c, TriggerAction triggerAction) {
        boolean bl = false;
        if (triggerAction.action == TriggerAction.Action.DOWN && this.keyStatus[n].action == TriggerAction.Action.UP) {
            bl = bl || this.onKeyDown(n, c);
            this.keyTyped[n] = c;
        }
        if (triggerAction.action == TriggerAction.Action.UP) {
            if (this.keyStatus[n].action == TriggerAction.Action.DOWN) {
                c = this.keyTyped[n];
                bl = bl || this.onKeyTyped(n, c);
            }
            bl = bl || this.onKeyUp(n, c);
        }
        this.keyStatus[n].action = triggerAction.action;
        if (this.handleSpecialKeys) {
            if (!bl && triggerAction.action == TriggerAction.Action.DOWN) {
                switch (n) {
                    case 15: 
                    case 205: 
                    case 208: {
                        this.focusWidget(this.getNextTraversableWidget(this.getFocusedWidget()));
                        break;
                    }
                    case 200: 
                    case 203: {
                        this.focusWidget(this.getPreviousTraversableWidget(this.getFocusedWidget()));
                        break;
                    }
                    case 28: 
                    case 57: 
                    case 156: {
                        if (this.focusedWidget == null) break;
                        this.activateWidget(this.focusedWidget);
                    }
                }
            } else if (!bl && triggerAction.action == TriggerAction.Action.UP) {
                switch (n) {
                    case 28: 
                    case 57: 
                    case 156: {
                        if (this.focusedWidget == null) break;
                        this.focusedWidget.onLeftMouseClicked(this.focusedWidget.getSpatial().getLocalTranslation());
                        this.activateWidget(null);
                    }
                }
            }
        }
    }

    public IWidget getFocusedWidget() {
        return this.focusedWidget;
    }

    public void focusWidget(IWidget iWidget) {
        if (!(iWidget == null || iWidget.isFocusable() && iWidget.isEnabled())) {
            return;
        }
        if (this.isBlockedByModal(iWidget)) {
            return;
        }
        if (this.focusedWidget != iWidget) {
            if (this.focusedWidget != null) {
                this.focusedWidget.setFocused(false);
                this.focusedWidget.onBlur();
                if (this.getListener() != null) {
                    this.getListener().onBlur(this.focusedWidget);
                }
            }
            this.focusedWidget = iWidget;
            if (iWidget != null) {
                iWidget.setFocused(true);
                iWidget.onFocus();
                if (this.getListener() != null) {
                    this.getListener().onFocus(iWidget);
                }
            }
        }
    }

    public void activateWidget(IWidget iWidget) {
        if (!(iWidget == null || iWidget.isFocusable() && iWidget.isEnabled())) {
            return;
        }
        if (this.isBlockedByModal(iWidget)) {
            return;
        }
        boolean bl = true;
        if (this.activeWidget != iWidget) {
            if (this.activeWidget != null && (bl = this.activeWidget.setActive(false))) {
                this.activeWidget.onDeactivate();
                if (this.getListener() != null) {
                    this.getListener().onDeactivate(this.activeWidget);
                }
            }
            if (bl) {
                this.activeWidget = iWidget;
                if (iWidget != null) {
                    iWidget.setActive(true);
                    iWidget.onActivate();
                    if (this.getListener() != null) {
                        this.getListener().onActivate(iWidget);
                    }
                }
            }
        }
    }

    private IWidget getNextTraversableWidget(IWidget iWidget) {
        if (this.modalWidget != null) {
            return this.modalWidget;
        }
        if (this.widgets.size() <= 0) {
            return null;
        }
        if (iWidget == null) {
            return this.findFirstFocusableWidget(this.widgets);
        }
        if (iWidget.getNextWidget() != null) {
            return iWidget.getNextWidget();
        }
        if (this.widgets.contains(iWidget)) {
            return this.getNextTraversableWidget(this.widgets, iWidget);
        }
        IWidget iWidget2 = this.findWidgetThatContainsWidget(this.widgets, iWidget);
        if (iWidget2 == null) {
            return this.widgets.get(0);
        }
        return this.getNextTraversableWidget(iWidget2.getLayers(), iWidget);
    }

    private IWidget findFirstFocusableWidget(ArrayList<IWidget> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IWidget iWidget = arrayList.get(i);
            if (iWidget.isFocusable()) {
                return iWidget;
            }
            IWidget iWidget2 = this.findFirstFocusableWidget(iWidget.getLayers());
            if (iWidget2 == null) continue;
            return iWidget2;
        }
        return null;
    }

    private IWidget findLastFocusableWidget(ArrayList<IWidget> arrayList) {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            IWidget iWidget = arrayList.get(i);
            if (iWidget.isFocusable()) {
                return iWidget;
            }
            IWidget iWidget2 = this.findLastFocusableWidget(iWidget.getLayers());
            if (iWidget2 == null) continue;
            return iWidget2;
        }
        return null;
    }

    private IWidget getNextTraversableWidget(ArrayList<IWidget> arrayList, IWidget iWidget) {
        IWidget iWidget2;
        int n;
        if (arrayList.isEmpty()) {
            return null;
        }
        int n2 = arrayList.indexOf(iWidget);
        for (n = n2 + 1; n < arrayList.size(); ++n) {
            iWidget2 = arrayList.get(n);
            if (!iWidget2.isFocusable() || !iWidget2.isEnabled()) continue;
            return iWidget2;
        }
        if (n2 == -1) {
            n2 = 0;
        }
        for (n = 0; n <= n2; ++n) {
            iWidget2 = arrayList.get(n);
            if (!iWidget2.isFocusable() || !iWidget2.isEnabled()) continue;
            return iWidget2;
        }
        return arrayList.get(n2);
    }

    private IWidget findWidgetThatContainsWidget(ArrayList<IWidget> arrayList, IWidget iWidget) {
        if (arrayList.size() <= 0) {
            return null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            IWidget iWidget2 = arrayList.get(i);
            if (iWidget2.getLayers().size() <= 0) continue;
            if (iWidget2.getLayers().contains(iWidget)) {
                return iWidget2;
            }
            IWidget iWidget3 = this.findWidgetThatContainsWidget(iWidget2.getLayers(), iWidget);
            if (iWidget3 == null) continue;
            return iWidget3;
        }
        return null;
    }

    private IWidget getPreviousTraversableWidget(IWidget iWidget) {
        if (this.modalWidget != null) {
            return this.modalWidget;
        }
        if (this.widgets.size() <= 0) {
            return null;
        }
        if (iWidget == null) {
            return this.findLastFocusableWidget(this.widgets);
        }
        if (iWidget.getPreviousWidget() != null) {
            return iWidget.getPreviousWidget();
        }
        if (this.widgets.contains(iWidget)) {
            return this.getPreviousTraversableWidget(this.widgets, iWidget);
        }
        IWidget iWidget2 = this.findWidgetThatContainsWidget(this.widgets, iWidget);
        if (iWidget2 == null) {
            return this.widgets.get(0);
        }
        return this.getPreviousTraversableWidget(iWidget2.getLayers(), iWidget);
    }

    private IWidget getPreviousTraversableWidget(ArrayList<IWidget> arrayList, IWidget iWidget) {
        IWidget iWidget2;
        int n;
        if (arrayList.isEmpty()) {
            return null;
        }
        int n2 = arrayList.indexOf(iWidget);
        for (n = n2 - 1; n >= 0; --n) {
            iWidget2 = arrayList.get(n);
            if (!iWidget2.isFocusable() || !iWidget2.isEnabled()) continue;
            return iWidget2;
        }
        if (n2 == -1) {
            n2 = 0;
        }
        for (n = arrayList.size() - 1; n >= n2; --n) {
            iWidget2 = arrayList.get(n);
            if (!iWidget2.isFocusable() || !iWidget2.isEnabled()) continue;
            return iWidget2;
        }
        return arrayList.get(n2);
    }

    private IWidget getWidgetForPosition(Vector3f vector3f, boolean bl, boolean bl2) {
        return this.getWidgetForPosition(this.widgets, vector3f, bl, bl2, Integer.MAX_VALUE);
    }

    private IWidget getWidgetForPosition(ArrayList<IWidget> arrayList, Vector3f vector3f, boolean bl, boolean bl2, int n) {
        IWidget iWidget = null;
        for (int i = arrayList.size(); i > 0; --i) {
            IWidget iWidget2 = arrayList.get(i - 1);
            if (this.isBlockedByModal(iWidget2) || !iWidget2.isEnabled() || !iWidget2.isInside(vector3f)) continue;
            ArrayList<IWidget> arrayList2 = iWidget2.getLayers();
            IWidget iWidget3 = this.getWidgetForPosition(arrayList2, vector3f, bl, bl2, n);
            if (iWidget3 != null) {
                iWidget = iWidget3;
                n = iWidget3.getOrder();
            }
            if (bl && !iWidget2.isActivatable() || bl2 && !iWidget2.isFocusable() || iWidget2.getOrder() >= n) continue;
            iWidget = iWidget2;
            n = iWidget2.getOrder();
        }
        return iWidget;
    }

    public void addWidget(BaseWidget baseWidget, Vector2f vector2f, boolean bl, boolean bl2) {
        float f = bl ? vector2f.x * this.mouseLimit.x : vector2f.x;
        float f2 = bl2 ? vector2f.y * this.mouseLimit.y : vector2f.y;
        this.node.attachChild(baseWidget.getSpatial());
        baseWidget.getMover().setPosition(new Vector3f(f, f2, baseWidget.getSpatial().getLocalTranslation().z));
        this.widgets.add(baseWidget);
        baseWidget.setGuiHandler(this);
        baseWidget.getSpatial().updateRenderState();
    }

    public void addWidgetToHandlerButNotToNode(BaseWidget baseWidget) {
        this.widgets.add(baseWidget);
        baseWidget.setGuiHandler(this);
    }

    public IWidget getWidget(String string) {
        return this.getWidget(this.widgets, string);
    }

    private IWidget getWidget(ArrayList<IWidget> arrayList, String string) {
        IWidget iWidget = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            iWidget = string.equals(arrayList.get(i).getName()) ? arrayList.get(i) : this.getWidget(arrayList.get(i).getLayers(), string);
            if (iWidget == null) continue;
            return iWidget;
        }
        return null;
    }

    public boolean removeWidget(BaseWidget baseWidget) {
        this.node.detachChild(baseWidget.getSpatial());
        return this.widgets.remove(baseWidget);
    }

    public void clearWidgets() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.node.detachChild(this.widgets.get(i).getSpatial());
        }
        this.widgets.clear();
    }

    @Override
    public void update(float f) {
        if (this.paused) {
            return;
        }
        this.cursor.update(f);
        this.keyboard.update(f);
    }

    @Override
    public void setPaused(boolean bl) {
        this.paused = bl;
        if (bl) {
            this.cursor.registerWithInputHandler(null);
            this.keyboard.registerWithInputHandler(null);
            this.node.detachChild(this.cursor);
            GameTaskQueueManager.getManager().update(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    mouseX = MouseInput.get().getXAbsolute();
                    mouseY = MouseInput.get().getYAbsolute();
                    MouseInput.get().setCursorVisible(false);
                    return null;
                }
            });
        } else {
            this.cursor.registerWithInputHandler(this.input);
            this.keyboard.registerWithInputHandler(this.input);
            this.node.attachChild(this.cursor);
            GameTaskQueueManager.getManager().update(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    MouseInput.get().setCursorVisible(true);
                    if (customCursor != null) {
                        Mouse.setNativeCursor(customCursor);
                    }
                    if (mouseX >= 0) {
                        MouseInput.get().setCursorPosition(mouseX, mouseY);
                    }
                    return null;
                }
            });
        }
    }

    public com.jme.input.Mouse getCursor() {
        return this.cursor;
    }

    public void setCursor(GuiAbsoluteMouse guiAbsoluteMouse) {
        this.cursor = guiAbsoluteMouse;
    }

    public Node getNode() {
        return this.node;
    }

    public int getGridSpacingX() {
        return this.gridSpacingX;
    }

    public void setGridSpacingX(int n) {
        this.gridSpacingX = n;
    }

    public int getGridSpacingY() {
        return this.gridSpacingY;
    }

    public void setGridSpacingY(int n) {
        this.gridSpacingY = n;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean bl) {
        this.snapToGrid = bl;
    }

    public void resetStatus() {
        int n;
        for (n = 0; n < this.mouseButtonStatus.length; ++n) {
            this.mouseButtonStatus[n] = new TriggerAction();
            this.timeOfLatestClick[n] = -1L;
        }
        for (n = 0; n < this.keyStatus.length; ++n) {
            this.keyStatus[n] = new TriggerAction();
        }
    }

    public IWidget getModalWidget() {
        return this.modalWidget;
    }

    public void setModalWidget(IWidget iWidget) {
        this.modalWidget = iWidget;
        if (iWidget != null) {
            this.activateWidget(null);
            this.focusWidget(iWidget);
        }
    }

    public boolean isBlockedByModal(IWidget iWidget) {
        boolean bl = false;
        if (this.modalWidget != null && iWidget != null) {
            return !this.isInWidgetTree(this.modalWidget, iWidget);
        }
        return bl;
    }

    public boolean isInWidgetTree(IWidget iWidget, IWidget iWidget2) {
        boolean bl = false;
        if (iWidget == iWidget2) {
            bl = true;
        } else {
            for (int i = 0; i < iWidget.getLayers().size() && !(bl = this.isInWidgetTree(iWidget.getLayers().get(i), iWidget2)); ++i) {
            }
        }
        return bl;
    }

    public IGuiListener getListener() {
        return this.listener;
    }

    public void setListener(IGuiListener iGuiListener) {
        this.listener = iGuiListener;
    }

    public boolean isKeyDown(int n) {
        if (n >= this.keyStatus.length) {
            return false;
        }
        return this.keyStatus[n].action == TriggerAction.Action.DOWN;
    }

    public Vector2f getMouseLimit() {
        return this.mouseLimit;
    }

    public void setMouseLimit(Vector2f vector2f) {
        this.mouseLimit.set(vector2f);
        this.cursor.setLimit((int)vector2f.x, (int)vector2f.y);
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public GuiKeyboard getKeyboard() {
        return this.keyboard;
    }

    public boolean isJoystickEnabled() {
        return this.getKeyboard().isJoystickEnabled();
    }

    public void setJoystickEnabled(boolean bl) {
        this.getKeyboard().setJoystickEnabled(bl);
    }

    public boolean isHandleSpecialKeys() {
        return this.handleSpecialKeys;
    }

    public void setHandleSpecialKeys(boolean bl) {
        this.handleSpecialKeys = bl;
    }

    static {
        mouseX = -1;
        mouseY = -1;
    }
}

