/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gameobject;

import com.turborilla.gameobject.GameObject;
import com.turborilla.gameobject.IComponent;
import com.turborilla.gameobject.IComponentHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

public class ComponentHandler
implements IComponentHandler {
    private static final Logger logger = Logger.getLogger(ComponentHandler.class.getName());
    private Queue<IComponent> components = new LinkedList<IComponent>();
    private GameObject parentGameObject;
    private ArrayList<IComponent> pausedComponents = new ArrayList();
    protected boolean paused = false;

    public void setParentGameObject(GameObject gameObject) {
        this.parentGameObject = gameObject;
        if (gameObject == null) {
            logger.severe("parentGameObject is null. Will not work.");
        }
    }

    public GameObject addComponent(IComponent iComponent) {
        if (this.parentGameObject == null) {
            logger.severe("parentGameObject is null. Will not work.");
            return null;
        }
        this.components.add(iComponent);
        iComponent.setGameObject(this.parentGameObject);
        if (this.isPaused()) {
            this.pausedComponents.add(iComponent);
            iComponent.setPaused(true);
        }
        return this.parentGameObject;
    }

    public boolean removeComponent(IComponent iComponent) {
        this.pausedComponents.remove(iComponent);
        if (this.components.remove(iComponent)) {
            logger.info("Detached component \"" + iComponent.getName() + "\" from GameObject \"" + this.parentGameObject.getName() + "\"");
            iComponent.onDetach();
            return true;
        }
        return false;
    }

    public IComponent hasComponent(String string) {
        IComponent iComponent = null;
        for (IComponent iComponent2 : this.components) {
            if (!iComponent2.getName().equals(string)) continue;
            iComponent = iComponent2;
            break;
        }
        return iComponent;
    }

    public boolean removeComponent(String string) {
        IComponent iComponent = this.hasComponent(string);
        if (iComponent == null) {
            return false;
        }
        return this.removeComponent(iComponent);
    }

    public void update(float f) {
        if (!this.paused) {
            Object[] objectArray = this.components.toArray();
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                ((IComponent)object).update(f);
            }
        }
    }

    public void setPaused(boolean bl) {
        if (!this.isPaused() && bl) {
            for (IComponent iComponent : this.components) {
                if (iComponent == null || iComponent.isPaused()) continue;
                this.pausedComponents.add(iComponent);
                iComponent.setPaused(true);
            }
        } else if (this.isPaused() && !bl) {
            for (int i = 0; i < this.pausedComponents.size(); ++i) {
                IComponent iComponent = this.pausedComponents.get(i);
                if (iComponent == null || !iComponent.isPaused()) continue;
                iComponent.setPaused(false);
            }
            this.pausedComponents.clear();
        }
        this.paused = bl;
    }

    public void clearComponents() {
        IComponent iComponent = this.components.poll();
        while (iComponent != null) {
            iComponent.onDetach();
            logger.info("Detached component \"" + iComponent.getName() + "\" from GameObject \"" + this.parentGameObject.getName() + "\"");
            iComponent = this.components.poll();
        }
        this.pausedComponents.clear();
    }

    public boolean isPaused() {
        return this.paused;
    }
}

