/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gameobject;

import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.gameobject.IComponent;
import java.util.logging.Logger;

public abstract class AbstractComponent
implements IComponent,
IEventListener {
    private String name;
    protected GameObject gameObject = null;
    private int priority = 10000;
    protected EventManager eventManager;
    private boolean paused = false;

    private AbstractComponent() {
    }

    public AbstractComponent(String string) {
        this();
        this.name = string;
    }

    public void init() {
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
    }

    public String getName() {
        if (this.gameObject != null) {
            return this.gameObject.getName() + "." + this.name;
        }
        return this.name;
    }

    public void setGameObject(GameObject gameObject) {
        this.gameObject = gameObject;
        this.eventManager = gameObject.getEventManager();
        if (gameObject != null && this.eventManager != null) {
            this.init();
        } else {
            Logger.getLogger(AbstractComponent.class.getName()).warning("Eventmanager is null for Component \"" + this.getName() + "\". Its GameObject is " + gameObject);
        }
    }

    public int compareTo(IComponent iComponent) {
        return this.priority - iComponent.getPriority();
    }

    public void update(float f) {
        if (this.eventManager != null) {
            this.eventManager.handleEvents(this);
        }
        if (this.paused) {
            return;
        }
        this.handleMessages(f);
        this.componentUpdate(f);
    }

    public void onDetach() {
        this.gameObject = null;
        if (this.eventManager != null) {
            this.eventManager.unregisterListener(this);
        }
        this.paused = true;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    protected void handleMessages(float f) {
    }

    protected abstract void componentUpdate(float var1);

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public GameObject getGameObject() {
        return this.gameObject;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.getName();
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public boolean isRemoveMeFromEventmanager() {
        return false;
    }
}

