/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.game;

import com.jme.app.AbstractGame;
import com.jme.image.Image;
import com.jme.input.InputSystem;
import com.jme.input.KeyBindingManager;
import com.jme.input.MouseInput;
import com.jme.input.joystick.JoystickInput;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.jme.system.PreferencesGameSettings;
import com.jme.system.dummy.DummyDisplaySystem;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.NanoTimer;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.jmex.game.state.GameState;
import com.jmex.game.state.GameStateManager;
import com.turborilla.game.ExceptionHandler;
import com.turborilla.game.FrameRateManager;
import com.turborilla.game.TurboInfoState;
import com.turborilla.sound.TurboSoundSystem;
import com.turborilla.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Formatter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.lwjgl.Sys;
import paulscode.sound.Library;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryJavaSound;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TurboJMEGame
extends AbstractGame
implements Runnable {
    private static final Logger logger = Logger.getLogger(TurboJMEGame.class.getName());
    public static final int DISPLAY_WINDOW = 1;
    public static final int DISPLAY_CANVAS = 2;
    public static boolean THREAD_FRIENDLY = true;
    public static int DISPLAY_MODE = 1;
    private Thread gameThread;
    private Thread startupThread;
    private String gameName;
    GameType type;
    private GameSettings settings;
    private boolean started;
    private Image[] icons;
    private FrameRateManager frameRateManager;
    Timer timer;
    private Camera camera;
    private ColorRGBA backgroundColor;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private TurboInfoState statGameState;
    private Canvas canvas;
    private Lock updateLock;
    private GameState startupState;
    private String errorHost;
    private String errorFile;
    private String openURLOnShutDown = null;
    private Exception interruptCause = null;
    StringBuilder strBuilder = new StringBuilder();
    Formatter formatter = new Formatter(this.strBuilder);
    private TurboSoundSystem soundSystem;

    public TurboJMEGame(String string) {
        this(string, GameType.GRAPHICAL, null);
    }

    public TurboJMEGame(String string, GameType gameType) {
        this(string, gameType, null);
    }

    public TurboJMEGame(String string, GameType gameType, GameSettings gameSettings) {
        this(string, gameType, gameSettings, null);
    }

    public TurboJMEGame(String string, GameType gameType, GameSettings gameSettings, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this(string, gameType, gameSettings, uncaughtExceptionHandler, null, null, null);
    }

    public TurboJMEGame(String string, GameType gameType, GameSettings gameSettings, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, GameState gameState, String string2, String string3) {
        this.setGameName(string);
        this.type = gameType;
        this.settings = gameSettings;
        this.exceptionHandler = uncaughtExceptionHandler;
        this.startupState = gameState;
        this.errorHost = string2;
        this.errorFile = string3;
        this.backgroundColor = ColorRGBA.black.clone();
        if (this.settings == null) {
            this.settings = new PreferencesGameSettings(Preferences.userRoot().node(string));
        }
        this.updateLock = new ReentrantLock(true);
        this.frameRateManager = new FrameRateManager();
    }

    public void setDisplayStatistics(boolean bl) {
        if (bl) {
            this.statGameState = new TurboInfoState();
            this.statGameState.setActive(false);
        } else {
            this.statGameState = null;
        }
    }

    public GameType getGameType() {
        return this.type;
    }

    @Override
    public void start() {
        this.gameThread = new Thread(this);
        this.startupThread = Thread.currentThread();
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new ExceptionHandler(this, this.getGameName(), this.errorHost, this.errorFile, this.settings);
        }
        this.gameThread.setUncaughtExceptionHandler(this.exceptionHandler);
        this.gameThread.setName("OpenGL");
        this.gameThread.start();
        try {
            while (!this.isStarted()) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "start()", "Exception", interruptedException);
            if (this.interruptCause != null) {
                this.exceptionHandler.uncaughtException(Thread.currentThread(), this.interruptCause);
            }
        }
        catch (Exception exception) {
            this.exceptionHandler.uncaughtException(Thread.currentThread(), exception);
        }
    }

    @Override
    public void run() {
        this.lock();
        try {
            this.initSystem();
            if (this.type != GameType.HEADLESS) {
                this.assertDisplayCreated();
                if (this.startupState != null) {
                    // empty if block
                }
                MouseInput.get().setCursorVisible(false);
            }
            this.initGame();
            if (this.type == GameType.GRAPHICAL) {
                this.timer = Timer.getTimer();
            } else if (this.type == GameType.HEADLESS) {
                this.timer = new NanoTimer();
            }
            long l = this.settings.getFramerate();
            this.frameRateManager.init(l, this);
        }
        catch (RuntimeException runtimeException) {
            this.startupThread.interrupt();
            throw runtimeException;
        }
        this.started = true;
        while (!this.finished && !this.display.isClosing()) {
            if (this.frameRateManager.updateAndRender()) continue;
            if (this.type == GameType.GRAPHICAL) {
                InputSystem.update();
            }
            this.timer.update();
            float f = this.timer.getTimePerFrame();
            this.update(f);
            this.render(f);
            this.display.getRenderer().displayBackBuffer();
            if (!THREAD_FRIENDLY) continue;
            Thread.yield();
        }
        this.started = false;
        this.cleanup();
        this.quit();
    }

    @Override
    protected void initSystem() {
        if (this.type == GameType.GRAPHICAL) {
            logger.info("LWJGL version: " + Sys.getVersion());
            if (JoystickInput.getProvider() == null) {
                JoystickInput.setProvider("LWJGL");
            }
            this.display = DisplaySystem.getDisplaySystem(this.settings.getRenderer());
            this.displayMins();
            this.display.setTitle(this.getGameName());
            if (this.icons != null) {
                this.display.setIcon(this.icons);
            }
            if (DISPLAY_MODE == 1) {
                this.display.createWindow(this.settings.getWidth(), this.settings.getHeight(), this.settings.getDepth(), this.settings.getFrequency(), this.settings.isFullscreen());
            } else if (DISPLAY_MODE == 2) {
                this.canvas = this.display.createCanvas(this.settings.getWidth(), this.settings.getHeight());
            }
            this.camera = this.display.getRenderer().createCamera(this.display.getWidth(), this.display.getHeight());
            this.display.getRenderer().setBackgroundColor(this.backgroundColor);
            this.display.setVSyncEnabled(this.settings.isVerticalSync());
            this.cameraPerspective();
            this.cameraFrame();
            this.camera.update();
            this.display.getRenderer().setCamera(this.camera);
            if (this.settings.isMusic() || this.settings.isSFX()) {
                this.initSound();
            }
            this.soundSystem = new TurboSoundSystem();
        } else {
            this.display = new DummyDisplaySystem();
        }
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    protected void initSound() {
        boolean bl = Boolean.parseBoolean(this.settings.get("useOpenAL", "true"));
        boolean bl2 = Boolean.parseBoolean(this.settings.get("noSound", "false"));
        if (!bl2) {
            if (bl) {
                try {
                    SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
                }
                catch (SoundSystemException soundSystemException) {
                    logger.severe("Problem adding library for OpenAL due to " + soundSystemException);
                }
            }
            try {
                SoundSystemConfig.addLibrary(LibraryJavaSound.class);
            }
            catch (SoundSystemException soundSystemException) {
                logger.severe("Problem adding library for JavaSound due to " + soundSystemException);
            }
        } else {
            try {
                SoundSystemConfig.addLibrary(Library.class);
            }
            catch (SoundSystemException soundSystemException) {
                logger.severe("Problem adding dummy sound due to " + soundSystemException);
            }
        }
        try {
            SoundSystemConfig.setCodec("wav", CodecWav.class);
        }
        catch (SoundSystemException soundSystemException) {
            logger.severe("Problem adding  codec for .wav files due to " + soundSystemException);
        }
        try {
            SoundSystemConfig.setCodec("ogg", CodecJOrbis.class);
        }
        catch (SoundSystemException soundSystemException) {
            logger.severe("Problem adding  codec for .ogg files due to " + soundSystemException);
        }
    }

    private void displayMins() {
        this.display.setMinDepthBits(this.settings.getDepthBits());
        this.display.setMinStencilBits(this.settings.getStencilBits());
        this.display.setMinAlphaBits(this.settings.getAlphaBits());
        this.display.setMinSamples(this.settings.getSamples());
    }

    private void cameraPerspective() {
        this.camera.setFrustumPerspective(45.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, 1000.0f);
        this.camera.setParallelProjection(false);
        this.camera.update();
    }

    private void cameraFrame() {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 25.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.camera.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
    }

    public void resetCamera() {
        this.cameraFrame();
    }

    @Override
    protected void initGame() {
        GameStateManager.create();
        KeyBindingManager.getKeyBindingManager().set("toggle_info", 68);
        KeyBindingManager.getKeyBindingManager().set("double_framerate", 78);
        KeyBindingManager.getKeyBindingManager().set("halve_framerate", 74);
    }

    @Override
    protected void update(float f) {
        this.unlock();
        this.lock();
        GameTaskQueueManager.getManager().getQueue("update").execute();
        GameStateManager.getInstance().update(f);
        if (this.statGameState != null && this.statGameState.isActive()) {
            this.statGameState.update(f);
        }
        if (this.statGameState != null) {
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_info", false)) {
                this.statGameState.setActive(!this.statGameState.isActive());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("double_framerate", false)) {
                this.frameRateManager.doubleFrameRateTemporarily();
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("halve_framerate", false)) {
                this.frameRateManager.halveFrameRateTemporarily();
            }
        }
        if (this.type == GameType.GRAPHICAL && (this.settings.isMusic() || this.settings.isSFX()) && this.soundSystem != null) {
            this.soundSystem.update(f);
        }
    }

    @Override
    protected void render(float f) {
        this.display.getRenderer().clearStatistics();
        this.display.getRenderer().clearBuffers();
        GameTaskQueueManager.getManager().getQueue("render").execute();
        GameStateManager.getInstance().render(f);
    }

    @Override
    public void reinit() {
        this.reinitAudio();
        this.reinitVideo();
    }

    public void reinitAudio() {
    }

    public void reinitVideo() {
        this.startupState.render(0.016f);
        this.display.getRenderer().displayBackBuffer();
        this.displayMins();
        this.display.recreateWindow(this.settings.getWidth(), this.settings.getHeight(), this.settings.getDepth(), this.settings.getFrequency(), this.settings.isFullscreen());
        this.camera = this.display.getRenderer().createCamera(this.display.getWidth(), this.display.getHeight());
        this.display.getRenderer().setBackgroundColor(this.backgroundColor);
        if (this.settings.isMusic() || this.settings.isSFX()) {
            this.initSound();
        }
    }

    public void recreateGraphicalContext() {
        GameTaskQueueManager.getManager().update(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TurboJMEGame.this.reinit();
                return null;
            }
        });
    }

    @Override
    protected void cleanup() {
        GameStateManager.getInstance().cleanup();
        DisplaySystem.getDisplaySystem().getRenderer().cleanup();
        TextureManager.doTextureCleanup();
        TextureManager.clearCache();
        JoystickInput.destroyIfInitalized();
        if (this.soundSystem != null) {
            this.soundSystem.cleanup();
        }
    }

    @Override
    protected void quit() {
        if (this.display != null) {
            this.display.reset();
            this.display.close();
        }
        if (this.openURLOnShutDown != null && this.openURLOnShutDown.length() >= 0) {
            Sys.openURL(this.openURLOnShutDown);
        }
    }

    public DisplaySystem getDisplay() {
        return this.display;
    }

    public TurboSoundSystem getSoundSystem() {
        return this.soundSystem;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public GameSettings getSettings() {
        return this.settings;
    }

    public void setBackgroundColor(ColorRGBA colorRGBA) {
        this.backgroundColor = colorRGBA;
    }

    public void shutdown() {
        this.finish();
    }

    public void shutdownAndOpenURL(String string) {
        if (string != null && string.length() >= 0) {
            this.openURLOnShutDown = string;
        }
        this.finish();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.exceptionHandler = uncaughtExceptionHandler;
        if (this.gameThread != null) {
            this.gameThread.setUncaughtExceptionHandler(this.exceptionHandler);
        }
    }

    public void delayForUpdate() throws InterruptedException, ExecutionException {
        Future<Object> future = GameTaskQueueManager.getManager().update(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return null;
            }
        });
        future.get();
    }

    public boolean inGLThread() {
        return Thread.currentThread() == this.gameThread;
    }

    public <T> T executeInGL(Callable<T> callable) throws Exception {
        if (this.inGLThread()) {
            return callable.call();
        }
        Future<T> future = GameTaskQueueManager.getManager().update(callable);
        return future.get();
    }

    public void lock() {
        this.updateLock.lock();
    }

    public void unlock() {
        this.updateLock.unlock();
    }

    public void setIcons(Image[] imageArray) {
        this.icons = imageArray;
    }

    public void setStatGameState(TurboInfoState turboInfoState) {
        this.statGameState = turboInfoState;
    }

    public TurboInfoState getStatGameState() {
        return this.statGameState;
    }

    public FrameRateManager getFrameRateManager() {
        return this.frameRateManager;
    }

    public void showExceptionDialog(Throwable throwable, Thread thread) {
        String string;
        final JFrame jFrame = new JFrame(){

            public Dimension getPreferredSize() {
                return new Dimension(200, 100);
            }
        };
        jFrame.setTitle("Debugging frame");
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setAlwaysOnTop(true);
        jFrame.setVisible(false);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(new JLabel(throwable.getClass().getName()));
        String string2 = throwable.getMessage();
        final String string3 = string = Utils.getStackTrace(throwable);
        JTextField jTextField = new JTextField(string, 15);
        jTextField.setEditable(false);
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        JButton jButton = new JButton("details");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea(string3);
                jTextArea.setEditable(false);
                jTextArea.setCaretPosition(0);
                JDialog jDialog = new JDialog((Frame)jFrame, "Mad Skills Motocross debug");
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.setPreferredSize(new Dimension(600, 300));
                jPanel.add(new JScrollPane(jTextArea));
                jDialog.getContentPane().add(jPanel);
                jDialog.pack();
                jDialog.setVisible(true);
            }
        });
        jPanel.add(jButton);
        JOptionPane.showMessageDialog(jFrame, jPanel, "Error encountered", 0);
    }

    public void setGameName(String string) {
        this.gameName = string;
    }

    public String getGameName() {
        return this.gameName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameType {
        GRAPHICAL,
        HEADLESS;

    }
}

