/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.game;

import com.jme.input.InputSystem;
import com.turborilla.game.TurboInfoState;
import com.turborilla.game.TurboJMEGame;
import java.awt.GraphicsDevice;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Formatter;
import java.util.logging.Logger;

public class FrameRateManager {
    private static boolean doRecord = false;
    TurboJMEGame game;
    long wantedFrameTimeNano = -1L;
    long actuallyWantedFrameTimeNano = -1L;
    long frameTimeMultiplier = 1L;
    long maxFrameTimeMultiplier = 4L;
    long minFramesBetweenSkips = 60L;
    long numberOfMinSkips = 0L;
    long numberOfMinSkipsBeforeChange = 240L;
    long numberOfFramesNoSkip = 0L;
    long numberOfFramesWithExcessTime = 0L;
    long numberOfFramesWithExcessTimeBeforeIncrease = 90L;
    long latestSkipAtFrame = -1L;
    float wantedFrameTimeSeconds = -1.0f;
    long frame = 0L;
    long accumulator = 0L;
    long maxFrameDiff = 2L;
    long framesSkipped = 0L;
    long maxFrameSkipBeforeForceRender = 120L;
    long maxFrameSkipBeforeNotStable = 5L;
    long start = -1L;
    long stableForFrames = 0L;
    long stabilizedWhenStableForFrames = 40L;
    int framesSkippedThisRender = 0;
    boolean stable = true;
    long renderTime;
    long updateTime;
    long waitTime;
    long flipTime;
    StringBuilder strBuilder = new StringBuilder();
    Formatter formatter = new Formatter(this.strBuilder);
    private long tempFramesSkippedThisRender;
    private File recordFile;
    private FileWriter writer;
    private boolean recording = false;
    private int statLength = 5000;
    private long[][] stats = new long[4][this.statLength];
    private int statIndex = 0;
    private Object lock = new Object();
    private GraphicsDevice device;

    FrameRateManager() {
    }

    void init(long l, TurboJMEGame turboJMEGame) {
        this.game = turboJMEGame;
        this.actuallyWantedFrameTimeNano = -1L;
        if (l > 0L) {
            this.actuallyWantedFrameTimeNano = Math.round(1.0E9 / (double)l);
        }
        this.reset(false);
    }

    public void reset(boolean bl) {
        this.start = System.nanoTime();
        this.frame = 0L;
        this.accumulator = 0L;
        this.framesSkipped = 0L;
        this.resetVariableFrameRate(bl);
    }

    public void resetVariableFrameRate(boolean bl) {
        this.wantedFrameTimeNano = this.actuallyWantedFrameTimeNano;
        this.wantedFrameTimeSeconds = (float)((double)this.actuallyWantedFrameTimeNano / 1.0E9);
        this.frameTimeMultiplier = 1L;
        this.numberOfMinSkips = 0L;
        this.numberOfFramesNoSkip = 0L;
        this.numberOfFramesWithExcessTime = 0L;
        this.latestSkipAtFrame = -1L;
        this.framesSkippedThisRender = 0;
        this.stable = true;
        this.stableForFrames = bl ? this.stabilizedWhenStableForFrames : 0L;
    }

    boolean updateAndRender() {
        long l;
        boolean bl;
        if (this.wantedFrameTimeNano < 0L) {
            return false;
        }
        this.tempFramesSkippedThisRender = Math.max((long)this.framesSkippedThisRender, this.tempFramesSkippedThisRender);
        this.stable = true;
        this.renderTime = 0L;
        this.updateTime = 0L;
        this.waitTime = 0L;
        this.flipTime = 0L;
        this.updateTime = System.nanoTime();
        if (this.game.type == TurboJMEGame.GameType.GRAPHICAL) {
            InputSystem.update();
        }
        int n = 0;
        while ((long)n < this.frameTimeMultiplier) {
            this.game.update(this.wantedFrameTimeSeconds);
            ++n;
        }
        this.updateTime = System.nanoTime() - this.updateTime;
        ++this.frame;
        this.accumulator += this.wantedFrameTimeNano;
        long l2 = this.accumulator - (System.nanoTime() - this.start);
        boolean bl2 = bl = this.maxFrameSkipBeforeForceRender > 0L && (long)this.framesSkippedThisRender > this.maxFrameSkipBeforeForceRender;
        if (bl) {
            l = -l2 / this.wantedFrameTimeNano;
            this.frame += ++l;
            this.accumulator += this.wantedFrameTimeNano * l;
        }
        if (l2 < -this.maxFrameDiff * this.wantedFrameTimeNano) {
            ++this.framesSkipped;
            if (this.frame - this.latestSkipAtFrame < this.minFramesBetweenSkips && this.frame > 100L) {
                this.numberOfMinSkips += Math.min(this.frame - this.latestSkipAtFrame, this.minFramesBetweenSkips);
                if (this.numberOfMinSkips >= this.numberOfMinSkipsBeforeChange) {
                    this.frameTimeMultiplier *= 2L;
                    if (this.frameTimeMultiplier <= this.maxFrameTimeMultiplier) {
                        this.wantedFrameTimeNano = this.actuallyWantedFrameTimeNano * this.frameTimeMultiplier;
                    } else {
                        this.frameTimeMultiplier /= 2L;
                    }
                    this.numberOfMinSkips = 0L;
                    this.numberOfFramesWithExcessTime = 0L;
                }
            }
            this.latestSkipAtFrame = this.frame;
            ++this.framesSkippedThisRender;
            this.tempFramesSkippedThisRender = Math.max((long)this.framesSkippedThisRender, this.tempFramesSkippedThisRender);
            this.numberOfFramesNoSkip = 0L;
            this.stable = (long)this.framesSkippedThisRender <= this.maxFrameSkipBeforeNotStable;
        } else {
            if (!bl) {
                ++this.numberOfFramesNoSkip;
                if (this.numberOfMinSkips > 0L && this.numberOfFramesNoSkip > this.minFramesBetweenSkips * 2L) {
                    this.numberOfMinSkips -= this.minFramesBetweenSkips;
                    this.numberOfFramesNoSkip = 0L;
                }
            }
            this.renderTime = System.nanoTime();
            this.game.render(this.wantedFrameTimeSeconds * (float)(this.framesSkippedThisRender + 1) * (float)this.frameTimeMultiplier);
            if (this.game.getStatGameState() != null && this.game.getStatGameState().isActive()) {
                this.game.getStatGameState().render(this.wantedFrameTimeSeconds);
            }
            this.renderTime = System.nanoTime() - this.renderTime;
            this.game.timer.update();
            l = System.nanoTime() - this.start;
            this.waitTime = System.nanoTime();
            while (l < this.accumulator) {
                Thread.yield();
                l = System.nanoTime() - this.start;
            }
            this.waitTime = System.nanoTime() - this.waitTime;
            if (this.frameTimeMultiplier > 1L && this.framesSkippedThisRender == 0 && !bl) {
                if ((float)this.waitTime * 0.85f > (float)(this.actuallyWantedFrameTimeNano * (this.frameTimeMultiplier / 2L))) {
                    ++this.numberOfFramesWithExcessTime;
                    if (this.numberOfFramesWithExcessTime * this.frameTimeMultiplier >= this.numberOfFramesWithExcessTimeBeforeIncrease) {
                        this.frameTimeMultiplier /= 2L;
                        this.wantedFrameTimeNano = this.actuallyWantedFrameTimeNano * this.frameTimeMultiplier;
                        this.numberOfFramesWithExcessTime = 0L;
                        this.numberOfMinSkips = 0L;
                    }
                } else {
                    this.numberOfFramesWithExcessTime = 0L;
                }
            } else {
                this.numberOfFramesWithExcessTime = 0L;
            }
            this.flipTime = System.nanoTime();
            this.game.getDisplay().getRenderer().displayBackBuffer();
            this.flipTime = System.nanoTime() - this.flipTime;
            this.framesSkippedThisRender = 0;
        }
        this.stableForFrames = this.stable ? ++this.stableForFrames : 0L;
        TurboInfoState turboInfoState = this.game.getStatGameState();
        if (turboInfoState != null && turboInfoState.isActive() && this.frame % 1L == 0L) {
            turboInfoState.setText("fps         ", this.getString("%.1f", Float.valueOf(this.game.timer.getFrameRate())));
            turboInfoState.setText("targetfps   ", this.getString("%.1f", 1.0E9 / (double)this.wantedFrameTimeNano));
            turboInfoState.setText("stable", Boolean.toString(this.isStable()));
            turboInfoState.setText("frame ", this.getString("%6d", this.frame));
            turboInfoState.setText("frames skipped", this.getString("%6d", this.framesSkipped));
            turboInfoState.setText("frames skipped this render", this.getString("%6d", this.tempFramesSkippedThisRender));
            turboInfoState.setText("skipframes", this.getString("%6d", this.numberOfMinSkips));
            turboInfoState.setText("frames excess time", this.getString("%6d", this.numberOfFramesWithExcessTime));
            turboInfoState.setText("render time ms", this.getString("%4d", this.renderTime / 1000000L));
            turboInfoState.setText("update time ms", this.getString("%4d", this.updateTime / 1000000L));
            turboInfoState.setText("wait time ms  ", this.getString("%4d", this.waitTime / 1000000L));
            turboInfoState.setText("flip time ms  ", this.getString("%4d", this.flipTime / 1000000L));
            this.tempFramesSkippedThisRender = 0L;
        }
        if (this.recording) {
            this.doRecordFrame();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecordingStats() throws IOException {
        if (!doRecord) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.recording) {
                this.stopRecordingStats();
            }
            this.recording = true;
            String string = "timing_stats_" + System.currentTimeMillis();
            this.recordFile = new File(string);
            this.recordFile.createNewFile();
            this.writer = new FileWriter(this.recordFile);
            this.statIndex = 0;
        }
    }

    private void doRecordFrame() {
        this.stats[0][this.statIndex] = this.wantedFrameTimeNano;
        this.stats[1][this.statIndex] = this.updateTime;
        this.stats[2][this.statIndex] = this.renderTime;
        this.stats[3][this.statIndex] = this.waitTime;
        ++this.statIndex;
        if (this.statIndex >= this.statLength) {
            try {
                this.flushToFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushToFile() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.statIndex; ++i) {
                String string = "tfps: " + this.getString("%.1f", 1.0E9 / (double)this.stats[0][i]) + "  update: " + this.getString("%4d", this.stats[1][i] / 1000000L) + "  render: " + this.getString("%4d", this.stats[2][i] / 1000000L) + "  wait: " + this.getString("%4d", this.stats[3][i] / 1000000L) + "\n";
                this.writer.write(string);
                Thread.yield();
            }
            this.statIndex = 0;
            this.writer.flush();
            this.writer.close();
        }
    }

    public void stopRecordingStats() throws IOException {
        if (!this.recording) {
            return;
        }
        this.recording = false;
        this.flushToFile();
    }

    public void stopRecordingStatsAsynch() {
        if (!this.recording) {
            return;
        }
        this.recording = false;
        new Thread(new Runnable(){

            public void run() {
                try {
                    FrameRateManager.this.flushToFile();
                }
                catch (IOException iOException) {
                    Logger.getLogger(FrameRateManager.class.getName()).severe("Could not save framerate stats. Exception: " + iOException);
                }
            }
        }).start();
    }

    public long getWantedFrameTimeNano() {
        return this.wantedFrameTimeNano;
    }

    public long getActuallyWantedFrameTimeNano() {
        return this.actuallyWantedFrameTimeNano;
    }

    public long getFrameTimeMultiplier() {
        return this.frameTimeMultiplier;
    }

    public long getMaxFrameTimeMultiplier() {
        return this.maxFrameTimeMultiplier;
    }

    public long getMinFramesBetweenSkips() {
        return this.minFramesBetweenSkips;
    }

    public long getNumberOfMinSkips() {
        return this.numberOfMinSkips;
    }

    public long getNumberOfMinSkipsBeforeChange() {
        return this.numberOfMinSkipsBeforeChange;
    }

    public long getNumberOfFramesNoSkip() {
        return this.numberOfFramesNoSkip;
    }

    public long getNumberOfFramesWithExcessTime() {
        return this.numberOfFramesWithExcessTime;
    }

    public long getNumberOfFramesWithExcessTimeBeforeIncrease() {
        return this.numberOfFramesWithExcessTimeBeforeIncrease;
    }

    public long getLatestSkipAtFrame() {
        return this.latestSkipAtFrame;
    }

    public float getWantedFrameTimeSeconds() {
        return this.wantedFrameTimeSeconds;
    }

    public long getFrame() {
        return this.frame;
    }

    public long getAccumulator() {
        return this.accumulator;
    }

    public long getMaxFrameDiff() {
        return this.maxFrameDiff;
    }

    public long getFramesSkipped() {
        return this.framesSkipped;
    }

    public long getStart() {
        return this.start;
    }

    public int getFramesSkippedThisRender() {
        return this.framesSkippedThisRender;
    }

    public long getRenderTime() {
        return this.renderTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public long getFlipTime() {
        return this.flipTime;
    }

    private String getString(String string, Object object) {
        this.strBuilder.setLength(0);
        this.formatter.format(string, object);
        return this.strBuilder.toString();
    }

    public boolean isStable() {
        return this.stableForFrames >= this.stabilizedWhenStableForFrames;
    }

    public void halveFrameRateTemporarily() {
        this.frameTimeMultiplier *= 2L;
        this.wantedFrameTimeNano = this.actuallyWantedFrameTimeNano * this.frameTimeMultiplier;
        this.numberOfMinSkips = 0L;
        this.numberOfFramesWithExcessTime = 0L;
    }

    public void doubleFrameRateTemporarily() {
        if (this.frameTimeMultiplier <= 1L) {
            return;
        }
        this.frameTimeMultiplier /= 2L;
        this.wantedFrameTimeNano = this.actuallyWantedFrameTimeNano * this.frameTimeMultiplier;
        this.numberOfMinSkips = 0L;
        this.numberOfFramesWithExcessTime = 0L;
    }
}

