/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.game;

import com.jme.system.GameSettings;
import com.turborilla.game.ExceptionDialog;
import com.turborilla.game.TurboJMEGame;
import com.turborilla.utils.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    Logger logger = Logger.getLogger(ExceptionHandler.class.getCanonicalName());
    private TurboJMEGame game = null;
    private String gameName;
    private String errorFile;
    private String errorHost;
    private GameSettings settings;

    public ExceptionHandler(TurboJMEGame turboJMEGame, String string, String string2, String string3, GameSettings gameSettings) {
        this.game = turboJMEGame;
        this.gameName = string;
        this.errorHost = string2;
        this.errorFile = string3;
        this.settings = gameSettings;
    }

    public void uncaughtException(Thread thread, final Throwable throwable) {
        this.logger.severe("Uncaught Exception: " + throwable + "\nStacktrace: " + Utils.getStackTrace(throwable));
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    ExceptionDialog exceptionDialog = new ExceptionDialog(ExceptionHandler.this.gameName, throwable, ExceptionHandler.this.errorHost, ExceptionHandler.this.errorFile, ExceptionHandler.this.settings);
                    ExceptionHandler.center(exceptionDialog);
                    exceptionDialog.setVisible(true);
                    exceptionDialog.dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.game.shutdown();
        this.game.cleanup();
        this.game.quit();
    }

    public static void center(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        component.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }
}

