/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.fx;

import com.jme.bounding.BoundingBox;
import com.jme.light.DirectionalLight;
import com.jme.light.LightNode;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Dome;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.jme.util.geom.BufferUtils;
import com.jmex.effects.LensFlare;
import com.jmex.effects.LensFlareFactory;
import java.nio.FloatBuffer;

public class SkyDome
extends Node {
    public static final float INFINITY = 3.3E38f;
    public static final float EPSILON = 1.0E-6f;
    private Dome dome;
    private Vector3f cameraPos = new Vector3f();
    private float thetaSun;
    private float phiSun;
    private float turbidity = 2.0f;
    private boolean isLinearExpControl;
    private float exposure = 18.0f;
    private float overcast;
    private float gammaCorrection = 2.5f;
    private float timeOfDay = 0.0f;
    private float julianDay = 0.0f;
    private float latitude = 0.0f;
    private float longitude = 0.0f;
    private float stdMeridian = 0.0f;
    private float sunnyTime = 12.0f;
    private float solarDeclination = 0.0f;
    private float latitudeInRadian = 0.0f;
    private boolean isNight = false;
    private Timer timer;
    private float currentTime;
    private float updateTime = 0.0f;
    private float timeWarp = 180.0f;
    private boolean renderRequired = true;
    private float chi;
    private float zenithLuminance;
    private float zenithX;
    private float zenithY;
    private float[] perezLuminance;
    private float[] perezX;
    private float[] perezY;
    private Vector3f sunDirection = new Vector3f();
    private Vector3f sunPosition = new Vector3f();
    private ColorXYZ color;
    private ColorXYZ colorTemp;
    private TriangleBatch batch;
    private FloatBuffer colorBuf;
    private FloatBuffer normalBuf;
    private Vector3f vertex = new Vector3f();
    private float gamma;
    private float cosTheta;
    private float cosGamma2;
    private float x_value;
    private float y_value;
    private float yClear;
    private float yOver;
    private float _Y;
    private float _X;
    private float _Z;
    private DirectionalLight dr;
    private LightNode sun;
    private LensFlare flare;
    private boolean sunEnabled = true;
    private float[][] distributionLuminance = new float[][]{{0.17872f, -1.46303f}, {-0.3554f, 0.42749f}, {-0.02266f, 5.32505f}, {0.12064f, -2.57705f}, {-0.06696f, 0.37027f}};
    private float[][] distributionXcomp = new float[][]{{-0.01925f, -0.25922f}, {-0.06651f, 8.1E-4f}, {-4.1E-4f, 0.21247f}, {-0.06409f, -0.89887f}, {-0.00325f, 0.04517f}};
    private float[][] distributionYcomp = new float[][]{{-0.01669f, -0.26078f}, {-0.09495f, 0.00921f}, {-0.00792f, 0.21023f}, {-0.04405f, -1.65369f}, {-0.01092f, 0.05291f}};
    private float[][] zenithXmatrix = new float[][]{{0.00165f, -0.00375f, 0.00209f, 0.0f}, {-0.02903f, 0.06377f, -0.03202f, 0.00394f}, {0.11693f, -0.21196f, 0.06052f, 0.25886f}};
    private float[][] zenithYmatrix = new float[][]{{0.00275f, -0.0061f, 0.00317f, 0.0f}, {-0.04214f, 0.0897f, -0.04153f, 0.00516f}, {0.15346f, -0.26756f, 0.0667f, 0.26688f}};

    public SkyDome() {
        this("SkyDome", 11, 18, 100.0f);
    }

    public SkyDome(String string) {
        this(string, 11, 18, 100.0f);
    }

    public SkyDome(String string, int n, int n2, float f) {
        this(string, new Vector3f(0.0f, 0.0f, 0.0f), n, n2, f);
    }

    public SkyDome(String string, Vector3f vector3f, int n, int n2, float f) {
        this.dome = new Dome(string, vector3f, n, n2, f, true);
        this.dome.setIsCollidable(false);
        this.dome.setSolidColor(ColorRGBA.black);
        this.attachChild(this.dome);
        this.timer = Timer.getTimer();
        this.currentTime = this.timer.getTimeInSeconds();
        this.solarDeclination = this.calc_solar_declination(this.julianDay);
        this.sunnyTime = this.calc_sunny_time(this.latitude, this.solarDeclination);
        this.setupLensFlare();
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setWritable(false);
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.setRenderState(zBufferState);
        this.setCullMode(3);
        this.setLightCombineMode(0);
        this.setTextureCombineMode(5);
    }

    public void setSunPosition(Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f();
        vector3f2 = FastMath.cartesianToSpherical(vector3f, vector3f2);
        this.thetaSun = vector3f2.z;
        this.phiSun = vector3f2.y;
    }

    public Vector3f getSunPosition() {
        return this.sunPosition;
    }

    public void setSunPosition(float f) {
        this.timeOfDay = f;
        float f2 = FastMath.sin(this.latitudeInRadian);
        float f3 = FastMath.cos(this.latitudeInRadian);
        float f4 = FastMath.sin(this.solarDeclination);
        float f5 = FastMath.cos(this.solarDeclination);
        float f6 = f + (0.17f * FastMath.sin((float)Math.PI * 4 * (this.julianDay - 80.0f) / 373.0f) - 0.129f * FastMath.sin((float)Math.PI * 2 * (this.julianDay - 8.0f) / 355.0f)) + (this.stdMeridian - this.longitude) / 15.0f;
        float f7 = FastMath.asin(f2 * f4 - f3 * f5 * FastMath.cos((float)Math.PI * f6 / this.sunnyTime));
        float f8 = -f5 * FastMath.sin((float)Math.PI * f6 / this.sunnyTime);
        float f9 = -(f3 * f4 + f2 * f5 * FastMath.cos((float)Math.PI * f6 / this.sunnyTime));
        float f10 = FastMath.atan(f8 / f9);
        if (f7 > 0.0f) {
            this.isNight = false;
            f10 = f8 < 0.0f && f10 < 0.0f || f8 > 0.0f && f10 > 0.0f ? 1.5707964f + f10 : 1.5707964f - f10;
            this.phiSun = (float)Math.PI * 2 - f10;
            this.thetaSun = 1.5707964f - f7;
            this.sunDirection.x = this.dome.radius;
            this.sunDirection.y = this.phiSun;
            this.sunDirection.z = f7;
            this.sunPosition = FastMath.sphericalToCartesian(this.sunDirection, this.sunPosition);
            if (f10 < 0.0f) {
                this.sunPosition.x *= -1.0f;
            }
            if (this.isSunEnabled()) {
                this.sun.setLocalTranslation(this.sunPosition);
            }
        } else {
            this.isNight = true;
        }
    }

    public boolean isNight() {
        return this.isNight;
    }

    public void setDay(float f) {
        this.julianDay = this.clamp(f, 0.0f, 365.0f);
        this.solarDeclination = this.calc_solar_declination(f);
        this.sunnyTime = this.calc_sunny_time(this.latitude, this.solarDeclination);
    }

    public float getDay() {
        return this.julianDay;
    }

    public void setLatitude(float f) {
        this.latitude = this.clamp(f, -90.0f, 90.0f);
        this.latitudeInRadian = (float)Math.PI / 180 * f;
        this.sunnyTime = this.calc_sunny_time(this.latitudeInRadian, this.solarDeclination);
    }

    public float getLatitude() {
        return this.latitude;
    }

    public void setLongitude(float f) {
        this.longitude = f;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public void setStandardMeridian(float f) {
        this.stdMeridian = f;
    }

    public float getStandardMeridian() {
        return this.stdMeridian;
    }

    public void setTurbidity(float f) {
        this.turbidity = this.clamp(f, 1.0f, 512.0f);
    }

    public void setExposure(boolean bl, float f) {
        this.isLinearExpControl = bl;
        this.exposure = 1.0f / this.clamp(f, 1.0f, 3.3E38f);
    }

    public void setOvercastFactor(float f) {
        this.overcast = this.clamp(f, 0.0f, 1.0f);
    }

    public void setGammaCorrection(float f) {
        this.gammaCorrection = 1.0f / this.clamp(f, 1.0E-6f, 3.3E38f);
    }

    public void setUpdateTime(float f) {
        this.updateTime = f;
    }

    public float getUpdateTime() {
        return this.updateTime;
    }

    public void setTimeWarp(float f) {
        this.timeWarp = f;
    }

    public float getTimeWarp() {
        return this.timeWarp;
    }

    public void update() {
        if (this.updateTime > 0.0f && this.timer.getTimeInSeconds() - this.currentTime >= this.updateTime) {
            this.currentTime = this.timer.getTimeInSeconds();
            this.timeOfDay += this.updateTime * this.timeWarp / 3600.0f;
            this.setSunPosition(this.timeOfDay);
            this.renderRequired = true;
        }
        this.cameraPos = DisplaySystem.getDisplaySystem().getRenderer().getCamera().getLocation();
        this.dome.setLocalTranslation(new Vector3f(this.cameraPos.x, 0.0f, this.cameraPos.z));
    }

    public void render() {
        if (!this.renderRequired) {
            return;
        }
        if (this.isNight) {
            this.dome.setSolidColor(ColorRGBA.black);
            return;
        }
        this.chi = (0.44444445f - this.turbidity / 120.0f) * ((float)Math.PI - 2.0f * this.thetaSun);
        this.zenithLuminance = (4.0453f * this.turbidity - 4.971f) * FastMath.tan(this.chi) - 0.2155f * this.turbidity + 2.4192f;
        if (this.zenithLuminance < 0.0f) {
            this.zenithLuminance = -this.zenithLuminance;
        }
        this.zenithX = this.getZenith(this.zenithXmatrix, this.thetaSun, this.turbidity);
        this.zenithY = this.getZenith(this.zenithYmatrix, this.thetaSun, this.turbidity);
        this.perezLuminance = this.getPerez(this.distributionLuminance, this.turbidity);
        this.perezX = this.getPerez(this.distributionXcomp, this.turbidity);
        this.perezY = this.getPerez(this.distributionYcomp, this.turbidity);
        this.zenithX = this.perezFunctionO1(this.perezX, this.thetaSun, this.zenithX);
        this.zenithY = this.perezFunctionO1(this.perezY, this.thetaSun, this.zenithY);
        this.zenithLuminance = this.perezFunctionO1(this.perezLuminance, this.thetaSun, this.zenithLuminance);
        this.sunDirection.x = FastMath.cos(1.5707964f - this.thetaSun) * FastMath.cos(this.phiSun);
        this.sunDirection.y = FastMath.sin(1.5707964f - this.thetaSun);
        this.sunDirection.z = FastMath.cos(1.5707964f - this.thetaSun) * FastMath.sin(this.phiSun);
        this.sunDirection.normalize();
        for (int i = 0; i < this.dome.getBatchCount(); ++i) {
            this.batch = this.dome.getBatch(i);
            this.normalBuf = this.batch.getNormalBuffer();
            this.colorBuf = this.batch.getColorBuffer();
            for (int j = 0; j < this.batch.getVertexCount(); ++j) {
                BufferUtils.populateFromBuffer(this.vertex, this.normalBuf, j);
                this.gamma = FastMath.acos(this.vertex.dot(this.sunDirection));
                if (this.vertex.y < 0.05f) {
                    this.vertex.y = 0.05f;
                }
                this.cosTheta = 1.0f / this.vertex.y;
                this.cosGamma2 = FastMath.sqr(FastMath.cos(this.gamma));
                this.x_value = this.perezFunctionO2(this.perezX, this.cosTheta, this.gamma, this.cosGamma2, this.zenithX);
                this.y_value = this.perezFunctionO2(this.perezY, this.cosTheta, this.gamma, this.cosGamma2, this.zenithY);
                this.yClear = this.perezFunctionO2(this.perezLuminance, this.cosTheta, this.gamma, this.cosGamma2, this.zenithLuminance);
                this.yOver = (1.0f + 2.0f * this.vertex.y) / 3.0f;
                this._Y = FastMath.LERP(this.overcast, this.yClear, this.yOver);
                this._X = this.x_value / this.y_value * this._Y;
                this._Z = (1.0f - this.x_value - this.y_value) / this.y_value * this._Y;
                this.colorTemp = new ColorXYZ(this._X, this._Y, this._Z);
                this.color = this.colorTemp.convertXYZtoRGB();
                this.colorTemp = this.color.convertRGBtoHSV();
                if (this.isLinearExpControl) {
                    this.colorTemp.setValue(this.colorTemp.getValue() * this.exposure);
                } else {
                    this.colorTemp.setValue(1.0f - FastMath.exp(-this.exposure * this.colorTemp.getValue()));
                }
                this.color = this.colorTemp.convertHSVtoRGB();
                this.color.setGammaCorrection(this.gammaCorrection);
                this.color.clamp();
                BufferUtils.setInBuffer(this.color.getRGBA(), this.colorBuf, j);
            }
        }
        this.renderRequired = false;
    }

    public LightNode getSun() {
        return this.sun;
    }

    public void setRootNode(Node node) {
        if (this.flare != null) {
            this.flare.setRootNode(node);
        }
    }

    public void setIntensity(float f) {
        if (this.flare != null) {
            this.flare.setIntensity(f);
        }
    }

    public void setTarget(Spatial spatial) {
        if (this.sun != null) {
            this.sun.setTarget(spatial);
        }
    }

    public void setSunEnabled(boolean bl) {
        this.sunEnabled = bl;
        this.sun.getLight().setEnabled(bl);
    }

    public boolean isSunEnabled() {
        return this.sunEnabled;
    }

    private float calc_solar_declination(float f) {
        return 0.4093f * FastMath.sin((float)Math.PI * 2 * (284.0f + f) / 365.0f);
    }

    private float calc_sunny_time(float f, float f2) {
        float f3 = 2.0f * FastMath.acos(-FastMath.tan(f) * FastMath.tan(f2));
        f3 = f3 * 57.295776f / 15.0f;
        return f3;
    }

    private void setupLensFlare() {
        this.dr = new DirectionalLight();
        this.dr.setEnabled(true);
        this.dr.setDiffuse(ColorRGBA.white);
        this.dr.setAmbient(ColorRGBA.gray);
        this.dr.setDirection(new Vector3f(0.0f, 0.0f, 0.0f));
        this.sun = new LightNode("SunNode", DisplaySystem.getDisplaySystem().getRenderer().createLightState());
        this.sun.setLight(this.dr);
        Vector3f vector3f = new Vector3f(-0.1f, -0.1f, -0.1f);
        Vector3f vector3f2 = new Vector3f(0.1f, 0.1f, 0.1f);
        Box box = new Box("lightbox", vector3f, vector3f2);
        box.setModelBound(new BoundingBox());
        box.updateModelBound();
        this.sun.attachChild(box);
        box.setLightCombineMode(0);
        TextureState[] textureStateArray = new TextureState[4];
        textureStateArray[0] = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureStateArray[0].setTexture(TextureManager.loadTexture(SkyDome.class.getClassLoader().getResource("jmetest/data/texture/flare1.png"), 6, 1, 3, 1.0f, true));
        textureStateArray[0].setEnabled(true);
        textureStateArray[0].apply();
        textureStateArray[1] = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureStateArray[1].setTexture(TextureManager.loadTexture(SkyDome.class.getClassLoader().getResource("jmetest/data/texture/flare2.png"), 6, 1));
        textureStateArray[1].setEnabled(true);
        textureStateArray[1].apply();
        textureStateArray[2] = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureStateArray[2].setTexture(TextureManager.loadTexture(SkyDome.class.getClassLoader().getResource("jmetest/data/texture/flare3.png"), 6, 1));
        textureStateArray[2].setEnabled(true);
        textureStateArray[2].apply();
        textureStateArray[3] = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureStateArray[3].setTexture(TextureManager.loadTexture(SkyDome.class.getClassLoader().getResource("jmetest/data/texture/flare4.png"), 6, 1));
        textureStateArray[3].setEnabled(true);
        textureStateArray[3].apply();
        this.flare = LensFlareFactory.createBasicLensFlare("flare", textureStateArray);
        this.flare.setIntensity(0.5f);
        this.sun.attachChild(this.flare);
        this.attachChild(this.sun);
    }

    private float[] getPerez(float[][] fArray, float f) {
        float[] fArray2 = new float[]{fArray[0][0] * f + fArray[0][1], fArray[1][0] * f + fArray[1][1], fArray[2][0] * f + fArray[2][1], fArray[3][0] * f + fArray[3][1], fArray[4][0] * f + fArray[4][1]};
        return fArray2;
    }

    private float getZenith(float[][] fArray, float f, float f2) {
        float f3 = f * f;
        float f4 = f * f3;
        return (fArray[0][0] * f4 + fArray[0][1] * f3 + fArray[0][2] * f + fArray[0][3]) * f2 * f2 + (fArray[1][0] * f4 + fArray[1][1] * f3 + fArray[1][2] * f + fArray[1][3]) * f2 + (fArray[2][0] * f4 + fArray[2][1] * f3 + fArray[2][2] * f + fArray[2][3]);
    }

    private float perezFunctionO1(float[] fArray, float f, float f2) {
        float f3 = (1.0f + fArray[0] * FastMath.exp(fArray[1])) * (1.0f + fArray[2] * FastMath.exp(fArray[3] * f) + fArray[4] * FastMath.sqr(FastMath.cos(f)));
        return f2 / f3;
    }

    private float perezFunctionO2(float[] fArray, float f, float f2, float f3, float f4) {
        return f4 * (1.0f + fArray[0] * FastMath.exp(fArray[1] * f)) * (1.0f + fArray[2] * FastMath.exp(fArray[3] * f2) + fArray[4] * f3);
    }

    private float clamp(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }

    class ColorXYZ {
        private float x = 0.0f;
        private float y = 0.0f;
        private float z = 0.0f;
        private float r = 0.0f;
        private float g = 0.0f;
        private float b = 0.0f;
        private float a = 1.0f;
        private float hue = 0.0f;
        private float saturation = 0.0f;
        private float value = 0.0f;

        public ColorXYZ(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
        }

        public void setValue(float f) {
            this.value = f;
        }

        public float getValue() {
            return this.value;
        }

        public void clamp() {
            if (this.r < 0.0f) {
                this.r = 0.0f;
            }
            if (this.g < 0.0f) {
                this.g = 0.0f;
            }
            if (this.b < 0.0f) {
                this.b = 0.0f;
            }
            if (this.r > 1.0f) {
                this.r = 1.0f;
            }
            if (this.g > 1.0f) {
                this.g = 1.0f;
            }
            if (this.b > 1.0f) {
                this.b = 1.0f;
            }
        }

        public void setGammaCorrection(float f) {
            this.r = FastMath.pow(this.r, f);
            this.g = FastMath.pow(this.g, f);
            this.b = FastMath.pow(this.b, f);
        }

        public ColorRGBA getRGBA() {
            return new ColorRGBA(this.r, this.g, this.b, this.a);
        }

        public ColorXYZ convertXYZtoRGB() {
            this.r = 3.240479f * this.x - 1.53715f * this.y - 0.498535f * this.z;
            this.g = -0.969256f * this.x + 1.875992f * this.y + 0.041556f * this.z;
            this.b = 0.055648f * this.x - 0.204043f * this.y + 1.057311f * this.z;
            return this;
        }

        public ColorXYZ convertRGBtoHSV() {
            float f = Math.min(Math.min(this.r, this.g), this.b);
            float f2 = Math.max(Math.max(this.r, this.g), this.b);
            float f3 = f2 - f;
            this.value = f2;
            if (FastMath.abs(f2) < 1.0E-6f) {
                this.saturation = 0.0f;
                this.hue = -1.0f;
                return this;
            }
            this.saturation = f3 / f2;
            this.hue = FastMath.abs(this.r - f2) < 1.0E-6f ? (this.g - this.b) / f3 : (FastMath.abs(this.g - f2) < 1.0E-6f ? 2.0f + (this.b - this.r) / f3 : 4.0f + (this.r - this.g) / f3);
            this.hue *= 60.0f;
            if (this.hue < 0.0f) {
                this.hue += 360.0f;
            }
            return this;
        }

        public ColorXYZ convertHSVtoRGB() {
            if (FastMath.abs(this.saturation) < 1.0E-6f) {
                this.r = this.value;
                this.g = this.value;
                this.b = this.value;
                this.a = this.value;
            }
            this.hue /= 60.0f;
            int n = (int)FastMath.floor(this.hue);
            float f = this.hue - (float)n;
            float f2 = this.value * (1.0f - this.saturation);
            float f3 = this.value * (1.0f - this.saturation * f);
            float f4 = this.value * (1.0f - this.saturation * (1.0f - f));
            switch (n) {
                case 0: {
                    this.r = this.value;
                    this.g = f4;
                    this.b = f2;
                    break;
                }
                case 1: {
                    this.r = f3;
                    this.g = this.value;
                    this.b = f2;
                    break;
                }
                case 2: {
                    this.r = f2;
                    this.g = this.value;
                    this.b = f4;
                    break;
                }
                case 3: {
                    this.r = f2;
                    this.g = f3;
                    this.b = this.value;
                    break;
                }
                case 4: {
                    this.r = f4;
                    this.g = f2;
                    this.b = this.value;
                    break;
                }
                default: {
                    this.r = this.value;
                    this.g = f2;
                    this.b = f3;
                }
            }
            return this;
        }
    }
}

