/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.event.typesafe;

import com.turborilla.event.typesafe.EventManager;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class ValidEventsXMLParser
extends DefaultHandler {
    protected EventManager manager;
    private boolean inArgument = false;
    private boolean inEvent = false;

    public ValidEventsXMLParser(EventManager eventManager, URL uRL) throws ParserConfigurationException, SAXException, IOException {
        if (eventManager == null) {
            return;
        }
        this.manager = eventManager;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(uRL.openStream(), (DefaultHandler)this);
        eventManager.endParsing();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        AttributesDebug attributesDebug = new AttributesDebug(attributes);
        if ("EVENT".equals(string3)) {
            if (this.inEvent) {
                throw new SAXException("Nested EVENTs not allowed");
            }
            this.inEvent = true;
            this.manager.startEvent(attributesDebug.getValue("name"), Boolean.parseBoolean(attributesDebug.getValue("enabled")));
        } else if ("ARGUMENT".equals(string3)) {
            if (this.inArgument) {
                throw new SAXException("Nested ARGUMENTs not allowed");
            }
            this.inArgument = true;
            this.manager.startArgument(attributesDebug.getValue("name"), attributesDebug.getValue("type"), Boolean.parseBoolean(attributesDebug.getValue("required")));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("EVENT".equals(string3)) {
            this.manager.endEvent();
            this.inEvent = false;
        } else if ("ARGUMENT".equals(string3)) {
            this.inArgument = false;
        }
    }

    private class AttributesDebug
    extends AttributesImpl {
        public AttributesDebug(Attributes attributes) {
            super(attributes);
        }

        public String getValue(String string) {
            String string2 = super.getValue(string);
            if (string2 == null) {
                throw new RuntimeException("Could not find attribute \"" + string + "\"");
            }
            return string2;
        }
    }
}

