/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.subdivision;

import com.jme.scene.batch.TriangleBatch;
import com.jme.util.geom.BufferUtils;
import com.jmex.subdivision.Subdivision;
import com.jmex.subdivision.Vector;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubdivisionButterfly
extends Subdivision {
    private static final Logger logger = Logger.getLogger(SubdivisionButterfly.class.getName());
    protected ArrayList<Edge> edges;
    protected ArrayList<Triangle> triangles;
    protected ArrayList<Edge>[] vertexEdgeMap;
    Location[] vertexLocation;
    Valence[] vertexValence;

    public SubdivisionButterfly() {
    }

    public SubdivisionButterfly(FloatBuffer floatBuffer, IntBuffer intBuffer) {
        super(floatBuffer, intBuffer);
    }

    public SubdivisionButterfly(TriangleBatch triangleBatch) {
        super(triangleBatch);
    }

    @Override
    public boolean prepare() {
        this.findEdgesAndTriangles();
        this.constructVertexEdgeMap();
        return true;
    }

    @Override
    protected boolean doSubdivide() {
        Object object;
        this.newVertexBuffer = BufferUtils.createVector3Buffer(this.getVertexCount() + this.edges.size());
        this.getVertexBuffer().rewind();
        this.newVertexBuffer.put(this.getVertexBuffer());
        this.newIndexBuffer = BufferUtils.createIntBuffer(this.getTriangleCount() * 4 * 3);
        this.newBuffers = new ArrayList();
        for (Subdivision.SubdivisionBuffer subdivisionBuffer : this.buffers) {
            if (subdivisionBuffer == null) continue;
            subdivisionBuffer.buf.rewind();
            FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(subdivisionBuffer.buf.capacity() + this.edges.size() * subdivisionBuffer.elemSize);
            floatBuffer.put(subdivisionBuffer.buf);
            this.newBuffers.add(new Subdivision.SubdivisionBuffer(floatBuffer, subdivisionBuffer.type));
        }
        int n = 0;
        for (Edge edge : this.edges) {
            Rule rule = VertexType.getRule(this.vertexValence[edge.vertexIndex[0]], this.vertexLocation[edge.vertexIndex[0]], this.vertexValence[edge.vertexIndex[1]], this.vertexLocation[edge.vertexIndex[1]]);
            Vector vector = rule.split(edge, this.vertexBuffer, 3, this.vertexEdgeMap, this.triangles, this.vertexValence, this.vertexLocation);
            edge.newVertexIndex = this.newVertexBuffer.position() / 3;
            this.newVertexBuffer.put(vector.elem, 0, 3);
            object = this.newBuffers.iterator();
            n = 0;
            Iterator iterator = this.buffers.iterator();
            while (iterator.hasNext()) {
                Subdivision.SubdivisionBuffer subdivisionBuffer = (Subdivision.SubdivisionBuffer)object.next();
                Subdivision.SubdivisionBuffer subdivisionBuffer2 = (Subdivision.SubdivisionBuffer)iterator.next();
                if (subdivisionBuffer2.linear) {
                    vector = new Vector(subdivisionBuffer2.elemSize);
                    vector.interpolate(new Vector(subdivisionBuffer2.elemSize).populateFromBuffer(subdivisionBuffer2.buf, edge.vertexIndex[0]), new Vector(subdivisionBuffer2.elemSize).populateFromBuffer(subdivisionBuffer2.buf, edge.vertexIndex[1]));
                } else {
                    vector = rule.split(edge, subdivisionBuffer2.buf, subdivisionBuffer2.elemSize, this.vertexEdgeMap, this.triangles, this.vertexValence, this.vertexLocation);
                }
                subdivisionBuffer.buf.put(vector.elem, 0, subdivisionBuffer.elemSize);
                ++n;
            }
        }
        Iterator iterator = this.newBuffers.iterator();
        while (iterator.hasNext()) {
            ((Subdivision.SubdivisionBuffer)iterator.next()).buf.flip();
        }
        object = new int[6];
        int n2 = 0;
        for (Triangle triangle : this.triangles) {
            object[0] = triangle.vertexIndex[0];
            object[1] = triangle.vertexIndex[1];
            object[2] = triangle.vertexIndex[2];
            object[3] = triangle.findEdge((int)triangle.vertexIndex[0], (int)triangle.vertexIndex[1]).newVertexIndex;
            object[4] = triangle.findEdge((int)triangle.vertexIndex[1], (int)triangle.vertexIndex[2]).newVertexIndex;
            object[5] = triangle.findEdge((int)triangle.vertexIndex[2], (int)triangle.vertexIndex[0]).newVertexIndex;
            this.newIndexBuffer.put((int)object[0]).put((int)object[3]).put((int)object[5]);
            this.newIndexBuffer.put((int)object[1]).put((int)object[4]).put((int)object[3]);
            this.newIndexBuffer.put((int)object[2]).put((int)object[5]).put((int)object[4]);
            this.newIndexBuffer.put((int)object[3]).put((int)object[4]).put((int)object[5]);
            ++n2;
        }
        this.newIndexBuffer.flip();
        return true;
    }

    private int getTriangleCount() {
        if (this.getIndexBuffer() == null) {
            logger.warning("No index buffer set, aborting.");
            return 0;
        }
        return this.indexBuffer.capacity() / 3;
    }

    private void findEdgesAndTriangles() {
        this.edges = new ArrayList();
        this.triangles = new ArrayList(this.getTriangleCount());
        IntBuffer intBuffer = this.getIndexBuffer();
        intBuffer.rewind();
        while (intBuffer.remaining() >= 3) {
            int n = intBuffer.get();
            int n2 = intBuffer.get();
            int n3 = intBuffer.get();
            Triangle triangle = new Triangle(n, n2, n3);
            Edge edge = this.inList(this.edges, n, n2);
            if (edge == null) {
                edge = new Edge(n, n2);
                this.edges.add(edge);
                edge.triangles[0] = triangle;
            } else {
                edge.triangles[1] = triangle;
            }
            triangle.edges[0] = edge;
            edge = this.inList(this.edges, n2, n3);
            if (edge == null) {
                edge = new Edge(n2, n3);
                this.edges.add(edge);
                edge.triangles[0] = triangle;
            } else {
                edge.triangles[1] = triangle;
            }
            triangle.edges[1] = edge;
            edge = this.inList(this.edges, n3, n);
            if (edge == null) {
                edge = new Edge(n3, n);
                this.edges.add(edge);
                edge.triangles[0] = triangle;
            } else {
                edge.triangles[1] = triangle;
            }
            triangle.edges[2] = edge;
            this.triangles.add(triangle);
        }
    }

    private Edge inList(ArrayList<Edge> arrayList, int n, int n2) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Edge edge = arrayList.get(i);
            if (!edge.equals(n, n2)) continue;
            return edge;
        }
        return null;
    }

    private int valence(int n) {
        return this.vertexEdgeMap[n].size();
    }

    private void constructVertexEdgeMap() {
        this.vertexEdgeMap = new ArrayList[this.getVertexCount()];
        this.vertexLocation = new Location[this.getVertexCount()];
        this.vertexValence = new Valence[this.getVertexCount()];
        for (int i = 0; i < this.getVertexCount(); ++i) {
            Edge edge;
            this.vertexLocation[i] = Location.INTERIOR;
            Edge edge2 = null;
            Edge edge3 = edge = this.findOneEdge(i, this.edges);
            this.vertexEdgeMap[i] = new ArrayList();
            while (!edge.equals(edge2) && edge3 != null) {
                this.vertexEdgeMap[i].add(edge3);
                edge3 = edge2 = this.findNextCCWEdge(edge3, i);
            }
            if (edge3 == null) {
                if (edge3 == null) {
                    this.vertexLocation[i] = Location.CREASE;
                }
                edge3 = edge;
                while (edge3 != null) {
                    edge2 = edge3;
                    edge3 = this.findNextCWEdge(edge3, i);
                }
                edge = edge2;
                edge2 = null;
                edge3 = edge;
                this.vertexEdgeMap[i].clear();
                while (!edge.equals(edge2) && edge3 != null) {
                    this.vertexEdgeMap[i].add(edge3);
                    edge3 = edge2 = this.findNextCCWEdge(edge3, i);
                }
            }
            this.vertexValence[i] = Valence.getValence(this.vertexLocation[i], this.valence(i));
        }
    }

    private Edge findOneEdge(int n, ArrayList<Edge> arrayList) {
        Edge edge = null;
        boolean bl = false;
        Iterator<Edge> iterator = arrayList.iterator();
        while (iterator.hasNext() && !bl) {
            edge = iterator.next();
            if (!edge.hasVertex(n)) continue;
            bl = true;
        }
        return edge;
    }

    private Triangle findCCWTriangle(Edge edge, int n) {
        Triangle triangle = null;
        Triangle[] triangleArray = edge.triangles;
        if (triangleArray[0] != null && triangleArray[0].isCCW(edge, n)) {
            return triangleArray[0];
        }
        if (triangleArray[1] != null && triangleArray[1].isCCW(edge, n)) {
            return triangleArray[1];
        }
        return triangle;
    }

    private Triangle findCWTriangle(Edge edge, int n) {
        Triangle triangle = null;
        Triangle[] triangleArray = edge.triangles;
        if (triangleArray[0] != null && !triangleArray[0].isCCW(edge, n)) {
            return triangleArray[0];
        }
        if (triangleArray[1] != null && !triangleArray[1].isCCW(edge, n)) {
            return triangleArray[1];
        }
        return triangle;
    }

    private Edge findNextCCWEdge(Edge edge, int n) {
        Triangle triangle = this.findCCWTriangle(edge, n);
        if (triangle == null) {
            return null;
        }
        return triangle.findOtherSharedEdge(n, edge);
    }

    private Edge findNextCWEdge(Edge edge, int n) {
        Triangle triangle = this.findCWTriangle(edge, n);
        if (triangle == null) {
            return null;
        }
        return triangle.findOtherSharedEdge(n, edge);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VertexType {
        REGULAR_INTERIOR,
        REGULAR_CREASE,
        EXTRAORDINARY_INTERIOR,
        EXTRAORDINARY_CREASE;


        private static VertexType getVertexType(Valence valence, Location location) {
            if (location == Location.INTERIOR) {
                if (valence == Valence.REGULAR) {
                    return REGULAR_INTERIOR;
                }
                return EXTRAORDINARY_INTERIOR;
            }
            if (valence == Valence.REGULAR) {
                return REGULAR_CREASE;
            }
            return EXTRAORDINARY_CREASE;
        }

        public static Rule getRule(Valence valence, Location location, Valence valence2, Location location2) {
            return VertexType.getRule(VertexType.getVertexType(valence, location), VertexType.getVertexType(valence2, location2));
        }

        private static Rule getRule(VertexType vertexType, VertexType vertexType2) {
            if (VertexType.isSame(vertexType, vertexType2, REGULAR_INTERIOR, REGULAR_INTERIOR)) {
                return Rule.STANDARD;
            }
            if (VertexType.isSame(vertexType, vertexType2, REGULAR_INTERIOR, REGULAR_CREASE)) {
                return Rule.REGULAR_INTERIOR_CREASE;
            }
            if (VertexType.isSame(vertexType, vertexType2, REGULAR_CREASE, REGULAR_CREASE)) {
                return Rule.REGULAR_CREASE_CREASE;
            }
            if (VertexType.isSame(vertexType, vertexType2, EXTRAORDINARY_INTERIOR, EXTRAORDINARY_INTERIOR)) {
                return Rule.EXTRAORDINARY_AVERAGE;
            }
            if (VertexType.isSame(vertexType, vertexType2, EXTRAORDINARY_INTERIOR, EXTRAORDINARY_CREASE)) {
                return Rule.EXTRAORDINARY_AVERAGE;
            }
            if (VertexType.isSame(vertexType, vertexType2, EXTRAORDINARY_CREASE, EXTRAORDINARY_CREASE)) {
                return Rule.EXTRAORDINARY_AVERAGE;
            }
            if (VertexType.isSame(vertexType, vertexType2, REGULAR_INTERIOR, EXTRAORDINARY_INTERIOR)) {
                return Rule.EXTRAORDINARY_INTERIOR;
            }
            if (VertexType.isSame(vertexType, vertexType2, REGULAR_INTERIOR, EXTRAORDINARY_CREASE)) {
                return Rule.EXTRAORDINARY_CREASE;
            }
            if (VertexType.isSame(vertexType, vertexType2, EXTRAORDINARY_INTERIOR, REGULAR_CREASE)) {
                return Rule.EXTRAORDINARY_INTERIOR;
            }
            if (VertexType.isSame(vertexType, vertexType2, REGULAR_CREASE, EXTRAORDINARY_CREASE)) {
                return Rule.EXTRAORDINARY_CREASE;
            }
            logger.info("Warning: unknown rule for " + (Object)((Object)vertexType) + " and " + (Object)((Object)vertexType2));
            return Rule.EXTRAORDINARY_AVERAGE;
        }

        public static boolean isSame(VertexType vertexType, VertexType vertexType2, VertexType vertexType3, VertexType vertexType4) {
            return vertexType == vertexType3 && vertexType2 == vertexType4 || vertexType == vertexType4 && vertexType2 == vertexType3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Valence {
        REGULAR,
        EXTRAORDINARY;


        public static Valence getValence(Location location, int n) {
            if (location == Location.INTERIOR ? n == 6 : n == 4) {
                return REGULAR;
            }
            return EXTRAORDINARY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        INTERIOR,
        CREASE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rule {
        STANDARD{

            @Override
            Vector split(Edge edge, FloatBuffer floatBuffer, int n, ArrayList<Edge>[] arrayListArray, ArrayList<Triangle> arrayList, Valence[] valenceArray, Location[] locationArray) {
                ++standard;
                this.newVector = Rule.regularButterfly(edge, edge.vertexIndex[0], floatBuffer, n, arrayListArray[edge.vertexIndex[0]]).addLocal(Rule.regularButterfly(edge, edge.vertexIndex[1], floatBuffer, n, arrayListArray[edge.vertexIndex[1]]));
                return this.newVector;
            }
        }
        ,
        REGULAR_INTERIOR_CREASE{

            @Override
            Vector split(Edge edge, FloatBuffer floatBuffer, int n, ArrayList<Edge>[] arrayListArray, ArrayList<Triangle> arrayList, Valence[] valenceArray, Location[] locationArray) {
                ++regularInteriorCrease;
                int n2 = locationArray[edge.vertexIndex[0]] == Location.INTERIOR ? 0 : 1;
                this.newVector = Rule.regularInteriorCrease(edge, edge.vertexIndex[n2], floatBuffer, n, arrayListArray[edge.vertexIndex[n2]], arrayListArray[edge.vertexIndex[n2 == 0 ? 1 : 0]]);
                return this.newVector;
            }
        }
        ,
        REGULAR_CREASE_CREASE{

            @Override
            Vector split(Edge edge, FloatBuffer floatBuffer, int n, ArrayList<Edge>[] arrayListArray, ArrayList<Triangle> arrayList, Valence[] valenceArray, Location[] locationArray) {
                ++regularCreaseCrease;
                this.newVector = Rule.regularCreaseCrease(edge, floatBuffer, n, arrayListArray);
                return this.newVector;
            }
        }
        ,
        EXTRAORDINARY_AVERAGE{

            @Override
            Vector split(Edge edge, FloatBuffer floatBuffer, int n, ArrayList<Edge>[] arrayListArray, ArrayList<Triangle> arrayList, Valence[] valenceArray, Location[] locationArray) {
                ++extraordinaryAverage;
                this.newVector = Rule.extraordinaryInterior(edge, edge.vertexIndex[0], floatBuffer, n, arrayListArray[edge.vertexIndex[0]], arrayList).addLocal(Rule.extraordinaryInterior(edge, edge.vertexIndex[1], floatBuffer, n, arrayListArray[edge.vertexIndex[1]], arrayList));
                this.newVector.multLocal(0.5f);
                return this.newVector;
            }
        }
        ,
        EXTRAORDINARY_INTERIOR{

            @Override
            Vector split(Edge edge, FloatBuffer floatBuffer, int n, ArrayList<Edge>[] arrayListArray, ArrayList<Triangle> arrayList, Valence[] valenceArray, Location[] locationArray) {
                ++extraordinaryInterior;
                int n2 = valenceArray[edge.vertexIndex[0]] == Valence.EXTRAORDINARY ? 0 : 1;
                this.newVector = Rule.extraordinaryInterior(edge, edge.vertexIndex[n2], floatBuffer, n, arrayListArray[edge.vertexIndex[n2]], arrayList);
                return this.newVector;
            }
        }
        ,
        EXTRAORDINARY_CREASE{

            @Override
            Vector split(Edge edge, FloatBuffer floatBuffer, int n, ArrayList<Edge>[] arrayListArray, ArrayList<Triangle> arrayList, Valence[] valenceArray, Location[] locationArray) {
                ++extraordinaryCrease;
                int n2 = valenceArray[edge.vertexIndex[0]] == Valence.EXTRAORDINARY ? 0 : 1;
                this.newVector = Rule.extraordinaryCrease(edge, edge.vertexIndex[n2], floatBuffer, n, arrayListArray[edge.vertexIndex[n2]]);
                return this.newVector;
            }
        };

        private static final float WEIGHT = 0.0f;
        Vector newVector = null;
        static int standard;
        static int regularCreaseCrease;
        static int regularInteriorCrease;
        static int extraordinaryAverage;
        static int extraordinaryInterior;
        static int extraordinaryCrease;

        abstract Vector split(Edge var1, FloatBuffer var2, int var3, ArrayList<Edge>[] var4, ArrayList<Triangle> var5, Valence[] var6, Location[] var7);

        private static Vector extraordinaryCrease(Edge edge, int n, FloatBuffer floatBuffer, int n2, ArrayList<Edge> arrayList) {
            Vector vector = new Vector(n2);
            int n3 = arrayList.size();
            int n4 = n3 - 1;
            int[] nArray = new int[n3];
            int n5 = -1;
            double d = Math.PI / (double)n4;
            double d2 = 0.0;
            int n6 = n3 - 1;
            for (Edge edge2 : arrayList) {
                nArray[n6] = edge2.otherVertex(n);
                if (edge2.equals(edge)) {
                    n5 = n6;
                }
                --n6;
            }
            Vector vector2 = new Vector(n2);
            vector2.populateFromBuffer(floatBuffer, n);
            d2 = 1.0 - Math.sin(d) * Math.sin((double)n5 * d) / ((double)n4 * (1.0 - Math.cos(d)));
            vector2.multLocal((float)d2);
            vector.addLocal(vector2);
            for (n6 = 0; n6 < n3; ++n6) {
                vector2.populateFromBuffer(floatBuffer, nArray[n6]);
                if (n6 == 0 || n6 == n3 - 1) {
                    d2 = 0.25 * Math.cos((double)n5 * d) - Math.sin(2.0 * d) * Math.sin(2.0 * (double)n5 * d) / (4.0 * (double)n4 * (Math.cos(d) - Math.cos(2.0 * d)));
                    if (n6 == n3 - 1) {
                        d2 = -d2;
                    }
                } else {
                    d2 = 1.0 / (double)n4 * (Math.sin((double)n5 * d) * Math.sin((double)n6 * d) + 0.5 * Math.sin(2.0 * (double)n5 * d) * Math.sin(2.0 * (double)n6 * d));
                }
                vector2.multLocal((float)d2);
                vector.addLocal(vector2);
            }
            return vector;
        }

        private static Vector regularCreaseCrease(Edge edge, FloatBuffer floatBuffer, int n, ArrayList<Edge>[] arrayListArray) {
            ArrayList<Edge> arrayList;
            Vector vector = new Vector(n);
            boolean bl = false;
            ArrayList<Edge> arrayList2 = arrayListArray[edge.vertexIndex[0]];
            ArrayList<Edge> arrayList3 = arrayListArray[edge.vertexIndex[1]];
            int n2 = -1;
            int n3 = -1;
            if (arrayList2.get(0).otherVertex(edge.vertexIndex[0]) == arrayList3.get(3).otherVertex(edge.vertexIndex[1])) {
                bl = true;
                n2 = edge.vertexIndex[0];
                n3 = edge.vertexIndex[1];
            } else if (arrayList2.get(3).otherVertex(edge.vertexIndex[0]) == arrayList3.get(0).otherVertex(edge.vertexIndex[1])) {
                bl = true;
                n2 = edge.vertexIndex[1];
                n3 = edge.vertexIndex[0];
                arrayList = arrayList3;
                arrayList3 = arrayList2;
                arrayList2 = arrayList;
                arrayList = null;
            } else {
                bl = false;
            }
            if (bl) {
                Vector vector2 = new Vector(n);
                vector2.populateFromBuffer(floatBuffer, n2);
                vector2.multLocal(0.5f);
                vector.addLocal(vector2);
                vector2.populateFromBuffer(floatBuffer, arrayList2.get(2).otherVertex(n2));
                vector2.multLocal(0.25f);
                vector.addLocal(vector2);
                vector2.populateFromBuffer(floatBuffer, arrayList2.get(3).otherVertex(n2));
                vector2.multLocal(-0.125f);
                vector.addLocal(vector2);
                vector2.populateFromBuffer(floatBuffer, n3);
                vector2.multLocal(0.5f);
                vector.addLocal(vector2);
                vector2.populateFromBuffer(floatBuffer, arrayList3.get(0).otherVertex(n3));
                vector2.multLocal(-0.125f);
                vector.addLocal(vector2);
            } else {
                if (arrayList2.get(0).equals(edge)) {
                    n2 = edge.vertexIndex[1];
                    n3 = edge.vertexIndex[0];
                    arrayList = arrayList3;
                    arrayList3 = arrayList2;
                    arrayList2 = arrayList;
                    arrayList = null;
                } else {
                    n2 = edge.vertexIndex[0];
                    n3 = edge.vertexIndex[1];
                }
                Vector vector3 = new Vector(n);
                vector3.populateFromBuffer(floatBuffer, n2);
                vector3.multLocal(0.5625f);
                vector.addLocal(vector3);
                vector3.populateFromBuffer(floatBuffer, arrayList2.get(0).otherVertex(n2));
                vector3.multLocal(-0.0625f);
                vector.addLocal(vector3);
                vector3.populateFromBuffer(floatBuffer, n3);
                vector3.multLocal(0.5625f);
                vector.addLocal(vector3);
                vector3.populateFromBuffer(floatBuffer, arrayList3.get(3).otherVertex(n3));
                vector3.multLocal(-0.0625f);
                vector.addLocal(vector3);
            }
            return vector;
        }

        private static Vector regularInteriorCrease(Edge edge, int n, FloatBuffer floatBuffer, int n2, ArrayList<Edge> arrayList, ArrayList<Edge> arrayList2) {
            Vector vector = new Vector(n2);
            int[] nArray = new int[6];
            Iterator<Edge> iterator = arrayList.iterator();
            while (iterator.hasNext() && !edge.equals(iterator.next())) {
            }
            for (int i = 0; i < 6; ++i) {
                if (!iterator.hasNext()) {
                    iterator = arrayList.iterator();
                }
                nArray[i] = iterator.next().otherVertex(n);
            }
            Vector vector2 = new Vector(n2);
            vector2.populateFromBuffer(floatBuffer, n);
            vector2.multLocal(0.625f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, nArray[0]);
            vector2.multLocal(0.1875f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, nArray[1]);
            vector2.multLocal(-0.125f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, nArray[3]);
            vector2.multLocal(-0.0625f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, nArray[4]);
            vector2.multLocal(0.0625f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, nArray[5]);
            vector2.multLocal(0.375f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, arrayList2.get(0).otherVertex(edge.otherVertex(n)));
            vector2.multLocal(-0.0625f);
            vector.addLocal(vector2);
            return vector;
        }

        private static Vector extraordinaryInterior(Edge edge, int n, FloatBuffer floatBuffer, int n2, ArrayList<Edge> arrayList, ArrayList<Triangle> arrayList2) {
            Vector vector = new Vector(n2);
            int n3 = arrayList.size();
            int[] nArray = new int[n3];
            Edge edge2 = null;
            Iterator<Edge> iterator = arrayList.iterator();
            while (iterator.hasNext() && !edge.equals(edge2 = iterator.next())) {
            }
            for (int i = 0; i < n3; ++i) {
                nArray[i] = edge2.otherVertex(n);
                if (!iterator.hasNext()) {
                    iterator = arrayList.iterator();
                }
                edge2 = iterator.next();
            }
            Vector vector2 = new Vector(n2);
            if (n3 == 3) {
                vector2.populateFromBuffer(floatBuffer, n);
                vector2.multLocal(0.75f);
                vector.addLocal(vector2);
                vector2.populateFromBuffer(floatBuffer, nArray[0]);
                vector2.multLocal(0.41666666f);
                vector.addLocal(vector2);
                vector2.populateFromBuffer(floatBuffer, nArray[1]);
                vector2.multLocal(-0.083333336f);
                vector.addLocal(vector2);
                vector2.populateFromBuffer(floatBuffer, nArray[2]);
                vector2.multLocal(-0.083333336f);
                vector.addLocal(vector2);
            } else if (n3 == 4) {
                vector2.populateFromBuffer(floatBuffer, n);
                vector2.multLocal(0.75f);
                vector.addLocal(vector2);
                vector2.populateFromBuffer(floatBuffer, nArray[0]);
                vector2.multLocal(0.375f);
                vector.addLocal(vector2);
                vector2.populateFromBuffer(floatBuffer, nArray[2]);
                vector2.multLocal(-0.125f);
                vector.addLocal(vector2);
            } else {
                vector2.populateFromBuffer(floatBuffer, n);
                vector2.multLocal(0.75f);
                vector.addLocal(vector2);
                int n4 = n3;
                for (int i = 0; i < n4; ++i) {
                    vector2.populateFromBuffer(floatBuffer, nArray[i]);
                    vector2.multLocal((float)(0.25 + Math.cos(Math.PI * 2 * (double)i / (double)n4) + 0.5 * Math.cos(Math.PI * 4 * (double)i / (double)n4)));
                    vector2.multLocal(1.0f / (float)n4);
                    vector.addLocal(vector2);
                }
            }
            return vector;
        }

        private static Vector regularButterfly(Edge edge, int n, FloatBuffer floatBuffer, int n2, ArrayList<Edge> arrayList) {
            Vector vector = new Vector(n2);
            int[] nArray = new int[6];
            Iterator<Edge> iterator = arrayList.iterator();
            while (iterator.hasNext() && !edge.equals(iterator.next())) {
            }
            for (int i = 0; i < 6; ++i) {
                if (!iterator.hasNext()) {
                    iterator = arrayList.iterator();
                }
                nArray[i] = iterator.next().otherVertex(n);
            }
            Vector vector2 = new Vector(n2);
            vector2.populateFromBuffer(floatBuffer, n);
            vector2.multLocal(0.5f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, nArray[0]);
            vector2.multLocal(0.0625f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, nArray[1]);
            vector2.multLocal(-0.0625f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, nArray[2]);
            vector2.multLocal(0.0f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, nArray[3]);
            vector2.multLocal(-0.0625f);
            vector.addLocal(vector2);
            vector2.populateFromBuffer(floatBuffer, nArray[4]);
            vector2.multLocal(0.0625f);
            vector.addLocal(vector2);
            return vector;
        }

        public static String stats() {
            return "standard = " + standard + ", regularCreaseCrease = " + regularCreaseCrease + ", regularInteriorCrease = " + regularInteriorCrease + ", extraordinaryAverage = " + extraordinaryAverage + ", extraordinaryInterior = " + extraordinaryInterior + ", extraordinaryCrease = " + extraordinaryCrease;
        }

        static {
            standard = 0;
            regularCreaseCrease = 0;
            regularInteriorCrease = 0;
            extraordinaryAverage = 0;
            extraordinaryInterior = 0;
            extraordinaryCrease = 0;
        }
    }

    public class Triangle {
        public int[] vertexIndex = new int[3];
        public Edge[] edges = new Edge[3];

        public Triangle() {
        }

        public Triangle(int n, int n2, int n3) {
            this();
            this.vertexIndex[0] = n;
            this.vertexIndex[1] = n2;
            this.vertexIndex[2] = n3;
        }

        public boolean hasEdge(Edge edge) {
            boolean bl = false;
            for (int i = 0; i < 3; ++i) {
                if (!edge.equals(this.edges[i])) continue;
                bl = true;
            }
            return bl;
        }

        public boolean isCCW(Edge edge, int n) {
            if (this.vertexIndex[0] == n && this.vertexIndex[1] == edge.otherVertex(n)) {
                return true;
            }
            if (this.vertexIndex[1] == n && this.vertexIndex[2] == edge.otherVertex(n)) {
                return true;
            }
            return this.vertexIndex[2] == n && this.vertexIndex[0] == edge.otherVertex(n);
        }

        public Edge findEdge(int n, int n2) {
            Edge edge = null;
            if (this.edges[0].equals(n, n2)) {
                edge = this.edges[0];
            }
            if (this.edges[1].equals(n, n2)) {
                edge = this.edges[1];
            }
            if (this.edges[2].equals(n, n2)) {
                edge = this.edges[2];
            }
            return edge;
        }

        public int findThirdVertex(Edge edge) {
            int n = -1;
            if (edge.equals(this.vertexIndex[0], this.vertexIndex[1])) {
                n = this.vertexIndex[2];
            }
            if (edge.equals(this.vertexIndex[1], this.vertexIndex[2])) {
                n = this.vertexIndex[0];
            }
            if (edge.equals(this.vertexIndex[0], this.vertexIndex[2])) {
                n = this.vertexIndex[1];
            }
            return n;
        }

        public int findThirdVertex(int n, int n2) {
            return this.findThirdVertex(new Edge(n, n2));
        }

        public Edge findOtherSharedEdge(int n, Edge edge) {
            if (this.edges[0].hasVertex(n) && !this.edges[0].equals(edge)) {
                return this.edges[0];
            }
            if (this.edges[1].hasVertex(n) && !this.edges[1].equals(edge)) {
                return this.edges[1];
            }
            if (this.edges[2].hasVertex(n) && !this.edges[2].equals(edge)) {
                return this.edges[2];
            }
            return null;
        }

        public String toString() {
            String string = "{" + this.vertexIndex[0] + "," + this.vertexIndex[1] + "," + this.vertexIndex[2] + "}";
            return string;
        }
    }

    public class Edge {
        public int[] vertexIndex = new int[2];
        public Edge[] newEdges = new Edge[2];
        public Triangle[] triangles = new Triangle[2];
        public int newVertexIndex = -1;

        public Edge() {
        }

        public Edge(int n, int n2) {
            this();
            if (n < n2) {
                this.vertexIndex[0] = n;
                this.vertexIndex[1] = n2;
            } else {
                this.vertexIndex[0] = n2;
                this.vertexIndex[1] = n;
            }
        }

        public boolean equals(Edge edge) {
            if (edge == null) {
                return false;
            }
            return this.vertexIndex[0] == edge.vertexIndex[0] && this.vertexIndex[1] == edge.vertexIndex[1] || this.vertexIndex[1] == edge.vertexIndex[0] && this.vertexIndex[0] == edge.vertexIndex[1];
        }

        public boolean equals(int n, int n2) {
            return this.vertexIndex[0] == n && this.vertexIndex[1] == n2 || this.vertexIndex[1] == n && this.vertexIndex[0] == n2;
        }

        public boolean hasVertex(int n) {
            if (this.vertexIndex[0] == n) {
                return true;
            }
            return this.vertexIndex[1] == n;
        }

        public int otherVertex(int n) {
            if (this.vertexIndex[0] == n) {
                return this.vertexIndex[1];
            }
            if (this.vertexIndex[1] == n) {
                return this.vertexIndex[0];
            }
            return -1;
        }

        public String toString() {
            return "{" + this.vertexIndex[0] + "," + this.vertexIndex[1] + "}";
        }
    }
}

