/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.pool;

import com.jmex.pool.ObjectGenerator;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectPool<T> {
    private Class<T> c;
    private ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
    private ObjectGenerator<T> generator;
    private volatile int total;

    public ObjectPool(ObjectGenerator<T> objectGenerator, int n) {
        this.generator = objectGenerator;
        for (int i = 0; i < n; ++i) {
            this.queue.offer(this.newInstance());
        }
    }

    public ObjectPool(Class<T> clazz, int n) {
        this.c = clazz;
        for (int i = 0; i < n; ++i) {
            this.queue.offer(this.newInstance());
        }
    }

    protected T newInstance() {
        T t = null;
        if (this.generator != null) {
            t = this.generator.newInstance();
        } else if (this.c != null) {
            try {
                t = this.c.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to instantiate Class: " + this.c.getCanonicalName(), exception);
            }
        }
        if (t != null) {
            ++this.total;
        }
        return t;
    }

    public T get() {
        T t = this.queue.poll();
        if (t == null) {
            t = this.newInstance();
        }
        if (this.generator != null) {
            this.generator.enable(t);
        }
        return t;
    }

    public T request() throws Exception {
        T t = this.queue.poll();
        if (t != null && this.generator != null) {
            this.generator.enable(t);
        }
        return t;
    }

    public boolean release(T t) {
        if (this.generator != null) {
            this.generator.disable(t);
        }
        return this.queue.offer(t);
    }

    public int available() {
        return this.queue.size();
    }

    public int size() {
        return this.total;
    }
}

