/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters.maxutils;

import com.jmex.model.converters.maxutils.ChunkHeader;
import com.jmex.model.converters.maxutils.ChunkerClass;
import java.io.DataInput;
import java.io.IOException;
import java.util.logging.Logger;

class TextureChunk
extends ChunkerClass {
    private static final Logger logger = Logger.getLogger(TextureChunk.class.getName());
    float percent;
    String texName;
    int flags;
    float textureBlur;
    float bumpPercentage;
    float vScale;
    float uScale;

    public TextureChunk(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        super(dataInput, chunkHeader);
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 48: {
                this.percent = (float)this.myIn.readShort() / 100.0f;
                if (DEBUG) {
                    logger.info("Texture percent:" + this.percent);
                }
                return true;
            }
            case 41728: {
                this.texName = this.readcStr(chunkHeader.length);
                return true;
            }
            case 41809: {
                this.flags = this.myIn.readUnsignedShort();
                return true;
            }
            case 41811: {
                this.textureBlur = this.myIn.readFloat();
                return true;
            }
            case 41554: {
                this.bumpPercentage = (float)this.myIn.readShort() / 100.0f;
                if (DEBUG) {
                    logger.info("Texture bump percent:" + this.bumpPercentage);
                }
                return true;
            }
            case 41812: {
                this.vScale = this.myIn.readFloat();
                return true;
            }
            case 41814: {
                this.uScale = this.myIn.readFloat();
                return true;
            }
        }
        return false;
    }
}

