/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters.maxutils;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jmex.model.converters.maxutils.ChunkHeader;
import com.jmex.model.converters.maxutils.ChunkerClass;
import com.jmex.model.converters.maxutils.SpotLightChunk;
import java.io.DataInput;
import java.io.IOException;
import java.util.logging.Logger;

class LightChunk
extends ChunkerClass {
    private static final Logger logger = Logger.getLogger(LightChunk.class.getName());
    Vector3f myLoc;
    ColorRGBA lightColor;
    float outterRange;
    float innerRange;
    float mult;
    SpotLightChunk spotInfo;
    boolean attenuateOn;

    public LightChunk(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        super(dataInput, chunkHeader);
    }

    protected void initializeVariables() throws IOException {
        this.myLoc = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
        this.decrHeaderLen(12);
        this.mult = 1.0f;
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 16: {
                this.lightColor = new ColorRGBA(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat(), 1.0f);
                if (DEBUG) {
                    logger.info("Light color:" + this.lightColor);
                }
                return true;
            }
            case 18010: {
                this.readOuterLightRange();
                return true;
            }
            case 18009: {
                this.readInnerLightRange();
                return true;
            }
            case 18011: {
                this.readLightMultiplier();
                return true;
            }
            case 17936: {
                if (this.spotInfo != null) {
                    throw new IOException("logic error... spotInfo not null");
                }
                this.spotInfo = new SpotLightChunk(this.myIn, chunkHeader);
                return true;
            }
            case 17957: {
                this.attenuateOn = true;
                return true;
            }
        }
        return false;
    }

    private void readLightMultiplier() throws IOException {
        this.mult = this.myIn.readFloat();
    }

    private void readInnerLightRange() throws IOException {
        this.innerRange = this.myIn.readFloat();
        if (DEBUG || DEBUG_LIGHT) {
            logger.info("Inner range:" + this.innerRange);
        }
    }

    private void readOuterLightRange() throws IOException {
        this.outterRange = this.myIn.readFloat();
        if (DEBUG || DEBUG_LIGHT) {
            logger.info("Outter range:" + this.outterRange);
        }
    }
}

