/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters;

import com.jme.bounding.BoundingBox;
import com.jme.image.Image;
import com.jme.image.Texture;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SimpleLightNode;
import com.jme.light.SpotLight;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Line;
import com.jme.scene.Spatial;
import com.jme.scene.SwitchNode;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Cone;
import com.jme.scene.shape.Cylinder;
import com.jme.scene.shape.Disk;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.BumpMapColorController;
import com.jme.util.CloneImportExport;
import com.jme.util.TextureKey;
import com.jme.util.TextureManager;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.geom.BufferUtils;
import com.jme.util.geom.NonIndexedNormalGenerator;
import com.jme.util.geom.NormalGenerator;
import com.jmex.model.converters.FormatConverter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X3dToJme
extends FormatConverter {
    private static final Logger logger = Logger.getLogger(X3dToJme.class.getName());
    private static final String WHITESPACE_REGEX = "\\s+";
    private static final String WHITESPACE_COMMA_REGEX = "(\\s*,\\s*)|\\s+";
    private static final String[] SCENE_NODE_TYPES = new String[]{"Group", "StaticGroup", "Transform", "Switch", "Shape", "DirectionalLight", "PointLight", "SpotLight"};
    private static final String[] GEOMETRY_TYPES = new String[]{"Box", "IndexedFaceSet", "Sphere", "Cylinder", "Cone", "LineSet"};
    private static final int SPHERE_Z_SAMPLES = 16;
    private static final int SPHERE_RADIAL_SAMPLES = 16;
    private static final int CYLINDER_AXIS_SAMPLES = 2;
    private static final int CYLINDER_RADIAL_SAMPLES = 20;
    private DocumentBuilder documentBuilder;
    private Hashtable<String, Object> defs = new Hashtable();
    private Map<String, InputStream> texData;
    private LightState lightState;
    private NormalGenerator normalGenerator = new NormalGenerator();
    private NonIndexedNormalGenerator nonIndexedNormalGenerator = new NonIndexedNormalGenerator();
    private boolean createBumpController = false;
    private boolean addToTransparentQueue = false;

    public X3dToJme() throws InstantiationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InstantiationException("X3DLoader creation failed: Unable to instantiate XML DocumentBuilder!");
        }
    }

    public void setDTDResolver(EntityResolver entityResolver) {
        this.documentBuilder.setEntityResolver(entityResolver);
    }

    @Override
    public void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            Spatial spatial = this.loadScene(inputStream, null, null);
            BinaryExporter.getInstance().save((Savable)spatial, outputStream);
        }
        catch (Exception exception) {
            logger.info("Unable to load file: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public Spatial loadScene(InputStream inputStream, Map<String, InputStream> map, LightState lightState) throws Exception {
        Node node;
        this.texData = map;
        Document document = this.documentBuilder.parse(inputStream);
        NodeList nodeList = document.getElementsByTagName("X3D");
        if (nodeList.getLength() == 0) {
            logger.info("No X3D document root!");
            return new com.jme.scene.Node();
        }
        Node node2 = this.getChildNode(nodeList.item(0), "Scene");
        com.jme.scene.Node node3 = new com.jme.scene.Node();
        if (lightState == null) {
            this.lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
            this.lightState.setEnabled(true);
            node3.setRenderState(this.lightState);
        } else {
            this.lightState = lightState;
        }
        Node node4 = this.getChildNode(node2, "WorldInfo");
        if (node4 != null && (node = node4.getAttributes().getNamedItem("title")) != null) {
            node3.setName(node.getNodeValue());
        }
        if ((node = this.getChildNode(node2, "Layer3D")) != null) {
            node2 = node;
        }
        for (Node node5 = node2.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
            Spatial spatial;
            if (node5.getNodeType() == 3 || node5.getNodeType() == 8 || (spatial = this.parseNode(node5)) == null) continue;
            node3.attachChild(spatial);
        }
        node3.setModelBound(new BoundingBox());
        node3.updateModelBound();
        this.defs.clear();
        this.texData = null;
        this.lightState = null;
        this.addToTransparentQueue = false;
        this.createBumpController = false;
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return node3;
    }

    private Node getChildNode(Node node, String string) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null && node2.getNodeName() != string; node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    private Spatial parseNode(Node node) throws Exception {
        Node node2;
        Node node3 = node.getAttributes().getNamedItem("USE");
        if (node3 != null) {
            return (Spatial)this.getDef(node3.getNodeValue());
        }
        String string = node.getNodeName();
        Spatial spatial = null;
        if (string.equals("Group") || string.equals("StaticGroup") || string.equals("Transform") || string.equals("Switch")) {
            spatial = this.parseGroup(node);
        } else if (string.equals("Shape")) {
            spatial = this.parseShape(node);
        } else if (string.equals("DirectionalLight") || string.equals("PointLight") || string.equals("SpotLight")) {
            spatial = this.parseLight(node);
        }
        if (spatial != null && (node2 = node.getAttributes().getNamedItem("DEF")) != null) {
            spatial.setName(node2.getNodeValue());
            CloneImportExport cloneImportExport = new CloneImportExport();
            cloneImportExport.saveClone(spatial);
            this.defs.put(node2.getNodeValue(), cloneImportExport);
        }
        return spatial;
    }

    private Savable getDef(String string) {
        CloneImportExport cloneImportExport = (CloneImportExport)this.defs.get(string);
        if (cloneImportExport != null) {
            return cloneImportExport.loadClone();
        }
        return null;
    }

    private com.jme.scene.Node parseGroup(Node node) throws Exception {
        Object object;
        boolean bl;
        com.jme.scene.Node node2;
        if (node.getNodeName().equals("Switch")) {
            node2 = new SwitchNode();
            bl = true;
        } else {
            node2 = new com.jme.scene.Node();
            bl = false;
        }
        BoundingBox boundingBox = this.parseBoundingBox(node);
        if (boundingBox != null) {
            node2.setModelBound(boundingBox);
        }
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            if (!this.isSceneNodeType(node3.getNodeName()) || (object = this.parseNode(node3)) == null) continue;
            node2.attachChild((Spatial)object);
        }
        if (bl) {
            object = node.getAttributes().getNamedItem("whichChoice").getNodeValue().trim();
            try {
                int n = Integer.parseInt((String)object);
                ((SwitchNode)node2).setActiveChild(n);
            }
            catch (NumberFormatException numberFormatException) {
                ((SwitchNode)node2).setActiveChild(-1);
            }
        } else if (node.getNodeName().equals("Transform")) {
            this.setTransformation(node2, node);
        }
        return node2;
    }

    private BoundingBox parseBoundingBox(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("bboxSize");
        if (node2 == null) {
            return null;
        }
        String string = node2.getNodeValue().trim();
        String[] stringArray = string.split(WHITESPACE_REGEX);
        if (stringArray.length < 3) {
            return null;
        }
        float f = this.getFloat(stringArray[0], -1.0f);
        float f2 = this.getFloat(stringArray[1], -1.0f);
        float f3 = this.getFloat(stringArray[2], -1.0f);
        if (f < 0.0f || f2 < 0.0f || f3 < 0.0f) {
            return null;
        }
        Node node3 = namedNodeMap.getNamedItem("bboxCenter");
        if (node3 == null) {
            return null;
        }
        String string2 = node3.getNodeValue().trim();
        stringArray = string2.split(WHITESPACE_REGEX);
        if (stringArray.length < 3) {
            return null;
        }
        float f4 = this.getFloat(stringArray[0], 0.0f);
        float f5 = this.getFloat(stringArray[1], 0.0f);
        float f6 = this.getFloat(stringArray[2], 0.0f);
        return new BoundingBox(new Vector3f(f4, f5, f6), f * 0.5f, f2 * 0.5f, f3 * 0.5f);
    }

    private boolean isSceneNodeType(String string) {
        for (String string2 : SCENE_NODE_TYPES) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void setTransformation(com.jme.scene.Node node, Node node2) {
        String string;
        String[] stringArray;
        float f;
        float f2;
        String[] stringArray2;
        float f3;
        float f4;
        Object object;
        Object object2;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Node node3 = namedNodeMap.getNamedItem("translation");
        if (node3 != null && ((String[])(object2 = ((String)(object = node3.getNodeValue().trim())).split(WHITESPACE_REGEX))).length >= 3) {
            float f5 = this.getFloat((String)object2[0], 0.0f);
            f4 = this.getFloat((String)object2[1], 0.0f);
            f3 = this.getFloat((String)object2[2], 0.0f);
            node.setLocalTranslation(f5, f4, f3);
        }
        if ((object = namedNodeMap.getNamedItem("rotation")) != null && (stringArray2 = ((String)(object2 = object.getNodeValue().trim())).split(WHITESPACE_REGEX)).length >= 4) {
            try {
                f4 = Float.parseFloat(stringArray2[0]);
                f3 = Float.parseFloat(stringArray2[1]);
                f2 = Float.parseFloat(stringArray2[2]);
                f = Float.parseFloat(stringArray2[3]);
                node.getLocalRotation().fromAngleAxis(f, new Vector3f(f4, f3, f2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((object2 = namedNodeMap.getNamedItem("scale")) != null && (stringArray = (string = object2.getNodeValue().trim()).split(WHITESPACE_REGEX)).length >= 3) {
            f3 = this.getFloat(stringArray[0], 1.0f);
            f2 = this.getFloat(stringArray[1], 1.0f);
            f = this.getFloat(stringArray[2], 1.0f);
            node.setLocalScale(new Vector3f(f3, f2, f));
        }
    }

    private int getInt(String string, int n) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private float getFloat(String string, float f) {
        if (string != null) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f;
    }

    private Spatial parseShape(Node node) throws Exception {
        RenderState[] renderStateArray;
        com.jme.scene.Node node2 = new com.jme.scene.Node();
        BoundingBox boundingBox = this.parseBoundingBox(node);
        Node node3 = null;
        Node node4 = null;
        for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
            if (node5.getNodeName().equals("Appearance")) {
                node4 = node5;
                continue;
            }
            if (!this.isGeometryType(node5.getNodeName())) continue;
            node3 = node5;
        }
        Geometry geometry = null;
        if (node3 != null) {
            geometry = this.parseGeometry(node3);
            if (geometry != null) {
                node2.attachChild(geometry);
            }
            if (geometry != null && boundingBox != null) {
                geometry.setModelBound(boundingBox);
            }
        }
        this.createBumpController = false;
        this.addToTransparentQueue = false;
        if (node4 != null && (renderStateArray = this.parseAppearance(node4)) != null && geometry != null) {
            if (this.createBumpController) {
                RenderState[] renderStateArray2 = new BumpMapColorController(geometry);
                geometry.addController((Controller)renderStateArray2);
            }
            if (this.addToTransparentQueue) {
                geometry.setRenderQueueMode(3);
            }
            for (RenderState renderState : renderStateArray) {
                if (renderState == null) continue;
                node2.setRenderState(renderState);
                if (!(renderState instanceof TextureState) || ((TextureState)renderState).getNumberOfSetTextures() <= 1) continue;
                this.copyTexCoords((TextureState)renderState, geometry);
            }
        }
        return node2;
    }

    private boolean isGeometryType(String string) {
        for (String string2 : GEOMETRY_TYPES) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private Geometry parseGeometry(Node node) throws Exception {
        Node node2 = node.getAttributes().getNamedItem("USE");
        if (node2 != null) {
            return (Geometry)this.getDef(node2.getNodeValue());
        }
        Node node3 = node.getAttributes().getNamedItem("DEF");
        String string = null;
        if (node3 != null) {
            string = node3.getNodeValue();
        }
        Geometry geometry = null;
        String string2 = node.getNodeName();
        if (string2.equals("Box")) {
            geometry = this.parseBox(node, string);
        } else if (string2.equals("IndexedFaceSet")) {
            geometry = this.parseIFS(node, string);
        } else if (string2.equals("Sphere")) {
            geometry = this.parseSphere(node, string);
        } else if (string2.equals("Cylinder")) {
            geometry = this.parseCylinder(node, string);
        } else if (string2.equals("Cone")) {
            geometry = this.parseCone(node, string);
        } else if (string2.equals("LineSet")) {
            geometry = this.parseLS(node, string);
        }
        if (geometry != null) {
            Object object;
            geometry.setModelBound(new BoundingBox());
            boolean bl = true;
            Node node4 = node.getAttributes().getNamedItem("solid");
            if (node4 != null && node4.getNodeValue().equalsIgnoreCase("false")) {
                bl = false;
            }
            if (bl) {
                object = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
                ((CullState)object).setCullMode(2);
                geometry.setRenderState((RenderState)object);
            }
            if (string != null) {
                object = new CloneImportExport();
                ((CloneImportExport)object).saveClone(geometry);
                this.defs.put(string, object);
            }
        }
        return geometry;
    }

    private Box parseBox(Node node, String string) {
        Box box = null;
        String string2 = node.getAttributes().getNamedItem("size").getNodeValue().trim();
        String[] stringArray = string2.split(WHITESPACE_REGEX);
        if (stringArray.length >= 3) {
            float f = this.getFloat(stringArray[0], 0.0f) * 0.5f;
            float f2 = this.getFloat(stringArray[1], 0.0f) * 0.5f;
            float f3 = this.getFloat(stringArray[2], 0.0f) * 0.5f;
            if (f > 0.0f && f2 > 0.0f && f3 > 0.0f) {
                box = string != null ? new Box(string, new Vector3f(), f, f2, f3) : new Box("X3D_Box", new Vector3f(), f, f2, f3);
            }
        }
        return box;
    }

    private Geometry parseIFS(Node node, String string) {
        TriMesh triMesh;
        Object object;
        float[] fArray;
        float[] fArray2 = null;
        Node node2 = this.getChildNode(node, "Coordinate");
        if (node2 != null) {
            fArray2 = this.parseValues(node2, "point");
        }
        if (fArray2 == null) {
            return null;
        }
        int[] nArray = this.parseIndices(node, "coordIndex");
        boolean bl = false;
        if (nArray == null) {
            nArray = new int[fArray2.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
        } else {
            bl = true;
        }
        float[] fArray3 = null;
        int n = 3;
        Node node3 = this.getChildNode(node, "Color");
        if (node3 == null) {
            n = 4;
            node3 = this.getChildNode(node, "ColorRGBA");
        }
        if (node3 != null) {
            fArray3 = this.parseValues(node3, "color");
        }
        int[] nArray2 = null;
        if (fArray3 != null) {
            nArray2 = this.parseIndices(node, "colorIndex");
        }
        if (fArray3 != null && n == 3) {
            fArray = new float[fArray3.length / 3 * 4];
            int n2 = 0;
            while (n2 * 3 < fArray3.length) {
                fArray[n2 * 4 + 0] = fArray3[n2 * 3 + 0];
                fArray[n2 * 4 + 1] = fArray3[n2 * 3 + 1];
                fArray[n2 * 4 + 2] = fArray3[n2 * 3 + 2];
                fArray[n2 * 4 + 3] = 1.0f;
                ++n2;
            }
            fArray3 = fArray;
            n = 4;
        }
        fArray = null;
        Node node4 = this.getChildNode(node, "Normal");
        if (node4 != null) {
            fArray = this.parseValues(node4, "vector");
        }
        int[] nArray3 = null;
        if (fArray != null) {
            nArray3 = this.parseIndices(node, "normalIndex");
        }
        float f = this.getFloat(node.getAttributes().getNamedItem("creaseAngle").getNodeValue().trim(), 0.0f);
        float[] fArray4 = null;
        Node node5 = this.getChildNode(node, "TextureCoordinate");
        if (node5 != null) {
            fArray4 = this.parseValues(node5, "point");
        }
        int[] nArray4 = null;
        if (fArray4 != null) {
            nArray4 = this.parseIndices(node, "texCoordIndex");
        }
        if (fArray4 == null) {
            fArray4 = this.generateTexCoords(fArray2);
        }
        if (bl && nArray3 == null && nArray2 == null && nArray4 == null) {
            object = BufferUtils.createIntBuffer(nArray);
            FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(fArray2);
            FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(fArray3);
            FloatBuffer floatBuffer3 = BufferUtils.createFloatBuffer(fArray);
            FloatBuffer floatBuffer4 = BufferUtils.createFloatBuffer(fArray4);
            triMesh = new TriMesh(null, floatBuffer, floatBuffer3, floatBuffer2, floatBuffer4, (IntBuffer)object);
            if (floatBuffer3 == null) {
                this.normalGenerator.generateNormals(triMesh, f);
            }
        } else {
            object = (int[])nArray.clone();
            if (bl) {
                fArray2 = this.expandValues(fArray2, nArray, 3, true);
            }
            if (fArray != null) {
                if (nArray3 != null) {
                    fArray = this.expandValues(fArray, nArray3, 3, false);
                } else if (bl) {
                    fArray = this.expandValues(fArray, (int[])object, 3, false);
                }
            }
            if (fArray3 != null) {
                if (nArray2 != null) {
                    fArray3 = this.expandValues(fArray3, nArray2, n, false);
                } else if (bl) {
                    fArray3 = this.expandValues(fArray3, (int[])object, n, false);
                }
            }
            if (fArray4 != null) {
                if (nArray4 != null) {
                    fArray4 = this.expandValues(fArray4, nArray4, 2, false);
                } else if (bl) {
                    fArray4 = this.expandValues(fArray4, (int[])object, 2, false);
                }
            }
            if (fArray == null) {
                fArray = this.nonIndexedNormalGenerator.generateNormals(fArray2, (int[])object, f);
            }
            IntBuffer intBuffer = BufferUtils.createIntBuffer(nArray);
            FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(fArray2);
            FloatBuffer floatBuffer5 = BufferUtils.createFloatBuffer(fArray3);
            FloatBuffer floatBuffer6 = BufferUtils.createFloatBuffer(fArray);
            FloatBuffer floatBuffer7 = BufferUtils.createFloatBuffer(fArray4);
            triMesh = new TriMesh(null, floatBuffer, floatBuffer6, floatBuffer5, floatBuffer7, intBuffer);
        }
        if (fArray3 == null) {
            triMesh.setDefaultColor(ColorRGBA.white.clone());
        }
        object = string != null ? string : "X3D_IndexedFaceSet";
        triMesh.setName((String)object);
        return triMesh;
    }

    private float[] parseValues(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        String string2 = node2.getNodeValue().trim();
        String[] stringArray = string2.split(WHITESPACE_COMMA_REGEX);
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fArray[i] = this.getFloat(stringArray[i], 0.0f);
        }
        return fArray;
    }

    private int[] parseIndices(Node node, String string) {
        int[] nArray;
        int n;
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        String string2 = node2.getNodeValue().trim();
        String[] stringArray = string2.split(WHITESPACE_COMMA_REGEX);
        int n2 = 5;
        int[] nArray2 = new int[n2];
        int n3 = 0;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(stringArray.length / 4 * 3);
        for (int i = 0; i < stringArray.length; ++i) {
            n = this.getInt(stringArray[i], 0);
            if (n > -1) {
                if (n3 == n2) {
                    nArray = new int[n2 + 1];
                    System.arraycopy(nArray2, 0, nArray, 0, n2);
                    nArray2 = nArray;
                    ++n2;
                }
                nArray2[n3++] = n;
                continue;
            }
            this.splitPolygon(nArray2, arrayList, n3);
            n3 = 0;
        }
        if (n3 > 2) {
            this.splitPolygon(nArray2, arrayList, n3);
        }
        int[] nArray3 = new int[arrayList.size() * 3];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray = arrayList.get(n);
            nArray3[n * 3 + 0] = nArray[0];
            nArray3[n * 3 + 1] = nArray[1];
            nArray3[n * 3 + 2] = nArray[2];
        }
        return nArray3;
    }

    private void splitPolygon(int[] nArray, ArrayList<int[]> arrayList, int n) {
        for (int i = 0; i < n - 2; ++i) {
            arrayList.add(new int[]{nArray[i], nArray[i + 1], nArray[n - 1]});
        }
    }

    private float[] expandValues(float[] fArray, int[] nArray, int n, boolean bl) {
        float[] fArray2 = new float[nArray.length * n];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray2[i * n + j] = fArray[nArray[i] * n + j];
            }
            if (!bl) continue;
            nArray[i] = i;
        }
        return fArray2;
    }

    private float[] generateTexCoords(float[] fArray) {
        float[] fArray2 = new float[fArray.length / 3 * 2];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n = 0;
        while (n * 3 < fArray.length) {
            f = Math.min(f, fArray[n * 3 + 0]);
            f2 = Math.max(f2, fArray[n * 3 + 0]);
            f3 = Math.min(f3, fArray[n * 3 + 1]);
            f4 = Math.max(f4, fArray[n * 3 + 1]);
            f5 = Math.min(f5, fArray[n * 3 + 2]);
            f6 = Math.max(f6, fArray[n * 3 + 2]);
            ++n;
        }
        float f7 = f2 - f;
        float f8 = f4 - f3;
        float f9 = f6 - f5;
        int n2 = 0;
        int n3 = 1;
        if (f8 > f7) {
            if (f9 > f8) {
                n2 = 2;
                n3 = 1;
            } else {
                n2 = 1;
                n3 = f9 > f7 ? 2 : 0;
            }
        } else if (f9 > f7) {
            n2 = 2;
            n3 = 0;
        } else if (f9 > f8) {
            n3 = 2;
        }
        float[] fArray3 = new float[]{f, f3, f5};
        float[] fArray4 = new float[]{f7, f8, f9};
        int n4 = 0;
        while (n4 * 3 < fArray.length) {
            fArray2[n4 * 2 + 0] = (fArray[n4 * 3 + n2] - fArray3[n2]) / fArray4[n2];
            fArray2[n4 * 2 + 1] = (fArray[n4 * 3 + n3] - fArray3[n3]) / fArray4[n3];
            ++n4;
        }
        return fArray2;
    }

    private Sphere parseSphere(Node node, String string) {
        Sphere sphere = null;
        String string2 = node.getAttributes().getNamedItem("radius").getNodeValue().trim();
        float f = this.getFloat(string2, 1.0f);
        sphere = string != null ? new Sphere(string, 16, 16, f) : new Sphere("X3D_Sphere", 16, 16, f);
        sphere.getLocalRotation().fromAngleNormalAxis(1.5707964f, Vector3f.UNIT_X);
        return sphere;
    }

    private Cylinder parseCylinder(Node node, String string) {
        Object object;
        Cylinder cylinder = null;
        String string2 = node.getAttributes().getNamedItem("height").getNodeValue().trim();
        float f = this.getFloat(string2, 2.0f);
        String string3 = node.getAttributes().getNamedItem("radius").getNodeValue().trim();
        float f2 = this.getFloat(string3, 1.0f);
        Node node2 = node.getAttributes().getNamedItem("top");
        boolean bl = true;
        if (node2 != null) {
            object = node2.getNodeValue().trim();
            bl = Boolean.valueOf((String)object);
        }
        object = node.getAttributes().getNamedItem("bottom");
        boolean bl2 = true;
        if (object != null) {
            String string4 = object.getNodeValue().trim();
            bl2 = Boolean.valueOf(string4);
        }
        cylinder = string != null ? new Cylinder(string, 2, 20, f2, f, bl && bl2) : new Cylinder("X3D_Cylinder", 2, 20, f2, f, bl && bl2);
        cylinder.getLocalRotation().fromAngleNormalAxis(1.5707964f, Vector3f.UNIT_X);
        return cylinder;
    }

    private Geometry parseCone(Node node, String string) {
        Object object;
        String string2 = node.getAttributes().getNamedItem("height").getNodeValue().trim();
        float f = this.getFloat(string2, 2.0f);
        String string3 = node.getAttributes().getNamedItem("bottomRadius").getNodeValue().trim();
        float f2 = this.getFloat(string3, 1.0f);
        Node node2 = node.getAttributes().getNamedItem("side");
        boolean bl = true;
        if (node2 != null) {
            String string4 = node2.getNodeValue().trim();
            bl = Boolean.valueOf(string4);
        }
        boolean bl2 = true;
        Node node3 = node.getAttributes().getNamedItem("bottom");
        if (node3 != null) {
            object = node3.getNodeValue().trim();
            bl2 = Boolean.valueOf((String)object);
        }
        if (bl) {
            object = null;
            object = string != null ? new Cone(string, 2, 20, f2, f, bl2) : new Cone("X3D_Cone", 2, 20, f2, f, bl2);
            ((Spatial)object).getLocalRotation().fromAngleNormalAxis(1.5707964f, Vector3f.UNIT_X);
            return object;
        }
        object = null;
        object = string != null ? new Disk(string, 1, 20, f2) : new Disk("X3D_Cone", 1, 20, f2);
        ((Spatial)object).setLocalTranslation(0.0f, -f * 0.5f, 0.0f);
        ((Spatial)object).getLocalRotation().fromAngleNormalAxis(1.5707964f, Vector3f.UNIT_X);
        return object;
    }

    private Line parseLS(Node node, String string) {
        Object object;
        float[] fArray = null;
        Node node2 = this.getChildNode(node, "Coordinate");
        if (node2 != null) {
            fArray = this.parseValues(node2, "point");
        }
        if (fArray == null) {
            return null;
        }
        Object object2 = null;
        int n = 3;
        Node node3 = this.getChildNode(node, "Color");
        if (node3 == null) {
            n = 4;
            node3 = this.getChildNode(node, "ColorRGBA");
        }
        if (node3 != null) {
            object2 = this.parseValues(node3, "color");
        }
        if (object2 != null && n == 3) {
            object = new float[((float[])object2).length / 3 * 4];
            int n2 = 0;
            while (n2 * 3 < ((float[])object2).length) {
                object[n2 * 4 + 0] = object2[n2 * 3 + 0];
                object[n2 * 4 + 1] = object2[n2 * 3 + 1];
                object[n2 * 4 + 2] = object2[n2 * 3 + 2];
                object[n2 * 4 + 3] = 1.0f;
                ++n2;
            }
            object2 = object;
            n = 4;
        }
        object = BufferUtils.createFloatBuffer(fArray);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(object2);
        String string2 = string != null ? string : "X3D_LineSet";
        Line line = new Line(string2, (FloatBuffer)object, null, floatBuffer, null);
        line.setMode(1);
        return line;
    }

    private RenderState[] parseAppearance(Node node) {
        RenderState[] renderStateArray;
        Object object;
        Node node2 = node.getAttributes().getNamedItem("USE");
        if (node2 != null) {
            return this.getRenderStateDEFs(node2.getNodeValue());
        }
        ArrayList<RenderState> arrayList = new ArrayList<RenderState>(3);
        TextureState textureState = null;
        Node node3 = this.getChildNode(node, "ImageTexture");
        if (node3 != null) {
            object = this.parseTexture(node3, null, 0);
            if (object != null) {
                textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                textureState.setEnabled(true);
                textureState.setTexture((Texture)object);
            }
        } else {
            node3 = this.getChildNode(node, "MultiTexture");
            if (node3 != null) {
                textureState = this.parseMultiTexture(node3);
            }
        }
        if (textureState != null) {
            arrayList.add(textureState);
        }
        if ((object = this.getChildNode(node, "Material")) != null) {
            renderStateArray = this.parseMaterial((Node)object);
            for (RenderState renderState : renderStateArray) {
                if (renderState == null) continue;
                arrayList.add(renderState);
            }
        }
        renderStateArray = arrayList.toArray(new RenderState[arrayList.size()]);
        Node node4 = node.getAttributes().getNamedItem("DEF");
        if (node4 != null) {
            this.storeRenderStateDEFs(renderStateArray, node4.getNodeValue());
        }
        return renderStateArray;
    }

    private RenderState[] getRenderStateDEFs(String string) {
        RenderState[] renderStateArray = (RenderState[])this.defs.get(string);
        if (renderStateArray != null) {
            RenderState[] renderStateArray2 = new RenderState[renderStateArray.length];
            System.arraycopy(renderStateArray, 0, renderStateArray2, 0, renderStateArray.length);
            return renderStateArray2;
        }
        return null;
    }

    private void storeRenderStateDEFs(RenderState[] renderStateArray, String string) {
        this.defs.put(string, renderStateArray);
    }

    private RenderState[] parseMaterial(Node node) {
        float f;
        Object object;
        String[] stringArray;
        float f2;
        Object object2;
        Node node2 = node.getAttributes().getNamedItem("USE");
        if (node2 != null) {
            return this.getRenderStateDEFs(node2.getNodeValue());
        }
        MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        materialState.setEnabled(true);
        if (this.createBumpController) {
            materialState.setColorMaterial(3);
        }
        ColorRGBA colorRGBA = new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f);
        Node node3 = node.getAttributes().getNamedItem("diffuseColor");
        if (node3 != null && ((String[])(object2 = node3.getNodeValue().trim().split(WHITESPACE_REGEX))).length >= 3) {
            f2 = this.getFloat(object2[0], 0.0f);
            f2 = FastMath.clamp(f2, 0.0f, 1.0f);
            float f3 = this.getFloat((String)object2[1], 0.0f);
            f3 = FastMath.clamp(f3, 0.0f, 1.0f);
            float f4 = this.getFloat((String)object2[2], 0.0f);
            f4 = FastMath.clamp(f4, 0.0f, 1.0f);
            colorRGBA.set(f2, f3, f4, 1.0f);
        }
        materialState.setDiffuse(colorRGBA);
        object2 = node.getAttributes().getNamedItem("ambientIntensity");
        if (object2 != null) {
            f2 = 0.2f;
            f2 = this.getFloat(object2.getNodeValue().trim(), 0.2f);
            f2 = FastMath.clamp(f2, 0.0f, 1.0f);
            materialState.setAmbient(new ColorRGBA(colorRGBA.r * f2, colorRGBA.g * f2, colorRGBA.b * f2, 1.0f));
        }
        ColorRGBA colorRGBA2 = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        Node node4 = node.getAttributes().getNamedItem("emissiveColor");
        if (node4 != null && (stringArray = node4.getNodeValue().trim().split(WHITESPACE_REGEX)).length >= 3) {
            float f5 = this.getFloat(stringArray[0], 0.0f);
            f5 = FastMath.clamp(f5, 0.0f, 1.0f);
            float f6 = this.getFloat(stringArray[1], 0.0f);
            f6 = FastMath.clamp(f6, 0.0f, 1.0f);
            float f7 = this.getFloat(stringArray[2], 0.0f);
            f7 = FastMath.clamp(f7, 0.0f, 1.0f);
            colorRGBA2.set(f5, f6, f7, 1.0f);
        }
        materialState.setEmissive(colorRGBA2);
        float f8 = 0.2f;
        Node node5 = node.getAttributes().getNamedItem("shininess");
        if (node5 != null) {
            f8 = this.getFloat(node5.getNodeValue().trim(), 0.2f);
            f8 = FastMath.clamp(f8, 0.1f, 128.0f);
        }
        materialState.setShininess(f8);
        ColorRGBA colorRGBA3 = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        Node node6 = node.getAttributes().getNamedItem("specularColor");
        if (node6 != null) {
            object = node6.getNodeValue().trim().split(WHITESPACE_REGEX);
            if (((String[])object).length >= 3) {
                float f9 = this.getFloat(object[0], 0.0f);
                f9 = FastMath.clamp(f9, 0.0f, 1.0f);
                f = this.getFloat(object[1], 0.0f);
                f = FastMath.clamp(f, 0.0f, 1.0f);
                float f10 = this.getFloat((String)object[2], 0.0f);
                f10 = FastMath.clamp(f10, 0.0f, 1.0f);
                colorRGBA3.set(f9, f, f10, 1.0f);
            }
            materialState.setSpecular(colorRGBA3);
        }
        object = null;
        Node node7 = node.getAttributes().getNamedItem("transparency");
        if (node7 != null) {
            f = this.getFloat(node7.getNodeValue().trim(), 0.0f);
            if ((f = FastMath.clamp(f, 0.0f, 1.0f)) > 0.0f) {
                object = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                ((RenderState)object).setEnabled(true);
                ((AlphaState)object).setBlendEnabled(true);
                ((AlphaState)object).setTestEnabled(true);
                materialState.getAmbient().a = 1.0f - f;
                materialState.getDiffuse().a = 1.0f - f;
                materialState.getEmissive().a = 1.0f - f;
                materialState.getSpecular().a = 1.0f - f;
                this.addToTransparentQueue = true;
            }
        }
        RenderState[] renderStateArray = object != null ? new RenderState[]{materialState, object} : new RenderState[]{materialState};
        Node node8 = node.getAttributes().getNamedItem("DEF");
        if (node8 != null) {
            this.storeRenderStateDEFs(renderStateArray, node8.getNodeValue());
        }
        return renderStateArray;
    }

    private Texture parseTexture(Node node, String string, int n) {
        Serializable serializable;
        Object object;
        Node node2 = node.getAttributes().getNamedItem("url");
        if (node2 == null) {
            return null;
        }
        String string2 = node2.getNodeValue().replaceAll("\"", "").replaceAll("'", "").trim();
        Texture texture = null;
        TextureKey textureKey = new TextureKey();
        try {
            textureKey.setLocation(new File(string2).toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        Texture texture2 = TextureManager.findCachedTexture(textureKey);
        if (texture2 != null) {
            texture = texture2.createSimpleClone();
            if (texture.getCombineFuncRGB() == 6) {
                this.createBumpController = true;
            }
            return texture;
        }
        if (this.texData != null) {
            object = this.texData.get(string2);
            if (object == null) {
                logger.info("No data InputStream found for texture " + string2 + "!");
                return null;
            }
            serializable = TextureManager.loadImage(string2.substring(string2.indexOf(46) + 1), (InputStream)object, true);
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            texture = new Texture();
            texture.setFilter(1);
            texture.setMipmapState(6);
            texture.setImage((Image)serializable);
        } else {
            object = null;
            serializable = (URL)this.getProperty("textures");
            if (serializable != null) {
                try {
                    object = new URL((URL)serializable, string2);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            if (object != null) {
                texture = TextureManager.loadTexture((URL)object, true);
                texture.setFilter(1);
                texture.setMipmapState(2);
            } else {
                return null;
            }
        }
        object = node.getAttributes().getNamedItem("repeatS");
        boolean bl = Boolean.parseBoolean(object.getNodeValue().trim());
        Node node3 = node.getAttributes().getNamedItem("repeatT");
        boolean bl2 = Boolean.parseBoolean(node3.getNodeValue().trim());
        if (bl) {
            if (bl2) {
                texture.setWrap(3);
            } else {
                texture.setWrap(2);
            }
        } else if (bl2) {
            texture.setWrap(1);
        } else {
            texture.setWrap(0);
        }
        if (string != null) {
            int n2 = string.indexOf(44);
            if (n2 > -1) {
                string = string.substring(0, n2);
            }
            if (string.equalsIgnoreCase("REPLACE")) {
                texture.setApply(0);
            } else if (string.equalsIgnoreCase("ADD")) {
                texture.setApply(5);
            } else if (string.equalsIgnoreCase("BLENDFACTORALPHA")) {
                texture.setApply(1);
            } else if (string.equalsIgnoreCase("DOTPRODUCT3")) {
                texture.setApply(4);
                texture.setCombineFuncRGB(6);
                texture.setCombineSrc0RGB(0);
                if (n == 0) {
                    texture.setCombineSrc1RGB(1);
                } else {
                    texture.setCombineSrc1RGB(3);
                }
                this.createBumpController = true;
            }
        }
        texture.setTextureKey(textureKey);
        texture.setStoreTexture(true);
        TextureManager.addToCache(texture);
        return texture;
    }

    private TextureState parseMultiTexture(Node node) {
        Object object;
        Object object2;
        Node node2 = node.getAttributes().getNamedItem("USE");
        if (node2 != null) {
            TextureState textureState = (TextureState)this.getDef(node2.getNodeValue());
            if (textureState != null) {
                for (int i = 0; i < textureState.getNumberOfSetTextures(); ++i) {
                    if (textureState.getTexture(i).getCombineFuncRGB() != 6) continue;
                    this.createBumpController = true;
                }
            }
            return textureState;
        }
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        Node node3 = node.getAttributes().getNamedItem("mode");
        String[] stringArray = null;
        if (node3 != null) {
            stringArray = node3.getNodeValue().trim().split(WHITESPACE_COMMA_REGEX);
        }
        int n = 0;
        for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            if (!node4.getNodeName().equals("ImageTexture")) continue;
            object2 = null;
            if (stringArray != null && stringArray.length > n) {
                object2 = stringArray[n];
            }
            if ((object = this.parseTexture(node4, (String)object2, n)) == null) continue;
            textureState.setTexture((Texture)object, n);
            ++n;
        }
        object2 = node.getAttributes().getNamedItem("def");
        if (object2 != null) {
            object = new CloneImportExport();
            ((CloneImportExport)object).saveClone(textureState);
            this.defs.put(object2.getNodeValue(), object);
        }
        return textureState;
    }

    private void copyTexCoords(TextureState textureState, Geometry geometry) {
        if (geometry != null) {
            for (int i = 1; i < textureState.getNumberOfSetTextures(); ++i) {
                geometry.copyTextureCoords(0, 0, i);
            }
        }
    }

    private SimpleLightNode parseLight(Node node) {
        Object object;
        String string = "X3D_Light";
        Node node2 = node.getAttributes().getNamedItem("DEF");
        if (node2 != null) {
            string = node2.getNodeValue();
        }
        SimpleLightNode simpleLightNode = null;
        Light light = null;
        if (node.getNodeName().equals("DirectionalLight")) {
            light = new DirectionalLight();
            this.lightState.attach(light);
            simpleLightNode = new SimpleLightNode(string, light);
            this.setDirection(node, simpleLightNode);
        } else if (node.getNodeName().equals("PointLight")) {
            light = new PointLight();
            this.lightState.attach(light);
            simpleLightNode = new SimpleLightNode(string, light);
            this.setLocation(node, simpleLightNode);
            this.setAttenuation(node, light);
        } else if (node.getNodeName().equals("SpotLight")) {
            object = new SpotLight();
            light = object;
            this.lightState.attach(light);
            simpleLightNode = new SimpleLightNode(string, light);
            this.setLocation(node, simpleLightNode);
            this.setDirection(node, simpleLightNode);
            this.setAttenuation(node, light);
            Node node3 = node.getAttributes().getNamedItem("cutOffAngle");
            float f = this.getFloat(node3.getNodeValue().trim(), 0.7853982f);
            ((SpotLight)object).setAngle(f * 180.0f / (float)Math.PI);
        }
        object = node.getAttributes().getNamedItem("intensity");
        float f = this.getFloat(object.getNodeValue().trim(), 1.0f);
        f = FastMath.clamp(f, 0.0f, 1.0f);
        Node node4 = node.getAttributes().getNamedItem("color");
        String[] stringArray = node4.getNodeValue().trim().split(WHITESPACE_REGEX);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        if (stringArray.length >= 3) {
            f2 = this.getFloat(stringArray[0], 1.0f);
            f2 = FastMath.clamp(f2, 0.0f, 1.0f) * f;
            f3 = this.getFloat(stringArray[1], 1.0f);
            f3 = FastMath.clamp(f3, 0.0f, 1.0f) * f;
            f4 = this.getFloat(stringArray[2], 1.0f);
            f4 = FastMath.clamp(f4, 0.0f, 1.0f) * f;
        }
        Node node5 = node.getAttributes().getNamedItem("ambientIntensity");
        float f5 = this.getFloat(node5.getNodeValue().trim(), 0.0f);
        f5 = FastMath.clamp(f5, 0.0f, 1.0f);
        light.getAmbient().set(f2 * f5, f3 * f5, f4 * f5, 1.0f);
        light.getDiffuse().set(f2, f3, f4, 1.0f);
        light.getSpecular().set(f2 * f, f3 * f, f4 * f, 1.0f);
        Node node6 = node.getAttributes().getNamedItem("on");
        if (node6.getNodeValue().trim().equalsIgnoreCase("false")) {
            light.setEnabled(false);
        } else {
            light.setEnabled(true);
        }
        return simpleLightNode;
    }

    private void setDirection(Node node, com.jme.scene.Node node2) {
        Node node3 = node.getAttributes().getNamedItem("direction");
        String[] stringArray = node3.getNodeValue().trim().split(WHITESPACE_REGEX);
        if (stringArray.length >= 3) {
            float f;
            float f2;
            float f3 = this.getFloat(stringArray[0], 0.0f);
            Vector3f vector3f = new Vector3f(f3, f2 = this.getFloat(stringArray[1], 0.0f), f = this.getFloat(stringArray[2], -1.0f));
            if (this.parallelToYAxis(vector3f)) {
                node2.getLocalRotation().lookAt(vector3f, Vector3f.UNIT_Z);
            } else {
                node2.getLocalRotation().lookAt(vector3f, Vector3f.UNIT_Y);
            }
        } else {
            node2.getLocalRotation().set(1.0f, 0.0f, 0.0f, (float)Math.PI);
        }
    }

    private void setLocation(Node node, com.jme.scene.Node node2) {
        Node node3 = node.getAttributes().getNamedItem("location");
        String[] stringArray = node3.getNodeValue().trim().split(WHITESPACE_REGEX);
        if (stringArray.length >= 3) {
            float f = this.getFloat(stringArray[0], 0.0f);
            float f2 = this.getFloat(stringArray[1], 0.0f);
            float f3 = this.getFloat(stringArray[2], 0.0f);
            node2.setLocalTranslation(f, f2, f3);
        }
    }

    private void setAttenuation(Node node, Light light) {
        Node node2 = node.getAttributes().getNamedItem("attenuation");
        String[] stringArray = node2.getNodeValue().trim().split(WHITESPACE_REGEX);
        if (stringArray.length >= 3) {
            float f = this.getFloat(stringArray[0], 1.0f);
            float f2 = this.getFloat(stringArray[1], 0.0f);
            float f3 = this.getFloat(stringArray[2], 0.0f);
            light.setAttenuate(true);
            light.setConstant(f);
            light.setLinear(f2);
            light.setQuadratic(f3);
        }
    }

    private boolean parallelToYAxis(Vector3f vector3f) {
        return FastMath.abs(vector3f.x) <= 1.0E-4f && FastMath.abs(vector3f.z) <= 1.0E-4f && FastMath.abs(vector3f.y) > 1.0E-4f;
    }
}

