/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters;

import com.jme.image.Texture;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.TriMesh;
import com.jme.scene.state.CullState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.system.dummy.DummyDisplaySystem;
import com.jme.util.LittleEndien;
import com.jme.util.TextureKey;
import com.jme.util.TextureManager;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.geom.BufferUtils;
import com.jme.util.resource.ResourceLocatorTool;
import com.jmex.model.JointMesh;
import com.jmex.model.animation.JointController;
import com.jmex.model.converters.FormatConverter;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class MilkToJme
extends FormatConverter {
    private DataInput inFile;
    private byte[] tempChar = new byte[128];
    private int nNumVertices;
    private int nNumTriangles;
    private MilkTriangle[] myTris;
    private MilkVertex[] myVerts;
    private int[] materialIndexes;
    private Node finalNode;

    public static void main(String[] stringArray) {
        new DummyDisplaySystem();
        new MilkToJme().attemptFileConvert(stringArray);
    }

    public void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.inFile = new LittleEndien(inputStream);
        this.finalNode = new Node("ms3d file");
        CullState cullState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.finalNode.setRenderState(cullState);
        this.checkHeader();
        this.readVerts();
        this.readTriangles();
        this.readGroups();
        this.readMats();
        this.readJoints();
        BinaryExporter.getInstance().save((Savable)this.finalNode, outputStream);
        this.nullAll();
    }

    private void addJointMeshes(Node node, JointController jointController) {
        for (int i = 0; i < node.getQuantity(); ++i) {
            if (!(node.getChild(i) instanceof JointMesh)) continue;
            jointController.addJointMesh((JointMesh)node.getChild(i));
        }
    }

    private void nullAll() {
        this.myTris = null;
        this.myVerts = null;
        this.finalNode = null;
    }

    private boolean readJoints() throws IOException {
        int n;
        int n2;
        float f = this.inFile.readFloat();
        float f2 = this.inFile.readFloat();
        int n3 = this.inFile.readInt();
        int n4 = this.inFile.readUnsignedShort();
        if (n4 == 0) {
            return false;
        }
        String[] stringArray = new String[n4];
        String[] stringArray2 = new String[n4];
        JointController jointController = new JointController(n4);
        jointController.FPS = f;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5;
            this.inFile.readByte();
            this.inFile.readFully(this.tempChar, 0, 32);
            stringArray[n2] = MilkToJme.cutAtNull(this.tempChar);
            this.inFile.readFully(this.tempChar, 0, 32);
            stringArray2[n2] = MilkToJme.cutAtNull(this.tempChar);
            jointController.localRefMatrix[n2].setEulerRot(this.inFile.readFloat(), this.inFile.readFloat(), this.inFile.readFloat());
            jointController.localRefMatrix[n2].setTranslation(this.inFile.readFloat(), this.inFile.readFloat(), this.inFile.readFloat());
            n = this.inFile.readUnsignedShort();
            int n6 = this.inFile.readUnsignedShort();
            for (n5 = 0; n5 < n; ++n5) {
                jointController.setRotation(n2, this.inFile.readFloat(), this.inFile.readFloat(), this.inFile.readFloat(), this.inFile.readFloat());
            }
            for (n5 = 0; n5 < n6; ++n5) {
                jointController.setTranslation(n2, this.inFile.readFloat(), this.inFile.readFloat(), this.inFile.readFloat(), this.inFile.readFloat());
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            jointController.parentIndex[n2] = -1;
            for (n = 0; n < n4; ++n) {
                if (!stringArray2[n2].equals(stringArray[n])) continue;
                jointController.parentIndex[n2] = n;
            }
        }
        jointController.setRepeatType(1);
        this.finalNode.addController(jointController);
        this.addJointMeshes(this.finalNode, jointController);
        return true;
    }

    private void readMats() throws IOException {
        int n = this.inFile.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            URL uRL;
            float f;
            this.inFile.skipBytes(32);
            MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
            materialState.setAmbient(this.getNextColor());
            materialState.setDiffuse(this.getNextColor());
            materialState.setSpecular(this.getNextColor());
            materialState.setEmissive(this.getNextColor());
            materialState.setShininess(this.inFile.readFloat());
            materialState.getDiffuse().a = f = this.inFile.readFloat();
            materialState.getEmissive().a = f;
            materialState.getAmbient().a = f;
            this.inFile.readByte();
            this.inFile.readFully(this.tempChar, 0, 128);
            TextureState textureState = null;
            String string = MilkToJme.cutAtNull(this.tempChar);
            if (string.length() != 0 && (uRL = ResourceLocatorTool.locateResource("texture", string)) != null) {
                textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                Texture texture = new Texture();
                texture.setTextureKey(new TextureKey(uRL, true, TextureManager.COMPRESS_BY_DEFAULT ? -1 : -2));
                texture.setAnisoLevel(0.0f);
                texture.setMipmapState(2);
                texture.setFilter(1);
                texture.setWrap(3);
                textureState.setTexture(texture);
            }
            this.inFile.readFully(this.tempChar, 0, 128);
            this.applyStates(materialState, textureState, i);
        }
    }

    private void applyStates(MaterialState materialState, TextureState textureState, int n) {
        for (int i = 0; i < this.finalNode.getQuantity(); ++i) {
            if (this.materialIndexes[i] != n) continue;
            if (materialState != null) {
                ((TriMesh)this.finalNode.getChild(i)).setRenderState(materialState);
            }
            if (textureState == null) continue;
            ((TriMesh)this.finalNode.getChild(i)).setRenderState(textureState);
        }
    }

    private ColorRGBA getNextColor() throws IOException {
        return new ColorRGBA(this.inFile.readFloat(), this.inFile.readFloat(), this.inFile.readFloat(), this.inFile.readFloat());
    }

    private void readGroups() throws IOException {
        int n = this.inFile.readUnsignedShort();
        this.materialIndexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.inFile.readByte();
            this.inFile.readFully(this.tempChar, 0, 32);
            int n2 = this.inFile.readUnsignedShort();
            Vector3f[] vector3fArray = new Vector3f[n2 * 3];
            Vector3f[] vector3fArray2 = new Vector3f[n2 * 3];
            Vector3f[] vector3fArray3 = new Vector3f[n2 * 3];
            Vector3f[] vector3fArray4 = new Vector3f[n2 * 3];
            Vector2f[] vector2fArray = new Vector2f[n2 * 3];
            int[] nArray = new int[n2 * 3];
            int[] nArray2 = new int[n2 * 3];
            JointMesh jointMesh = new JointMesh(MilkToJme.cutAtNull(this.tempChar));
            for (int j = 0; j < n2; ++j) {
                int n3 = this.inFile.readUnsignedShort();
                for (int k = 0; k < 3; ++k) {
                    vector3fArray[j * 3 + k] = this.myVerts[this.myTris[n3].vertIndicies[k]].vertex;
                    vector3fArray2[j * 3 + k] = this.myTris[n3].vertNormals[k];
                    vector2fArray[j * 3 + k] = this.myTris[n3].vertTexCoords[k];
                    nArray[j * 3 + k] = j * 3 + k;
                    vector3fArray3[j * 3 + k] = vector3fArray[j * 3 + k];
                    vector3fArray4[j * 3 + k] = vector3fArray2[j * 3 + k];
                    nArray2[j * 3 + k] = this.myVerts[this.myTris[n3].vertIndicies[k]].boneID;
                }
            }
            jointMesh.reconstruct(BufferUtils.createFloatBuffer(vector3fArray), BufferUtils.createFloatBuffer(vector3fArray2), null, BufferUtils.createFloatBuffer(vector2fArray), BufferUtils.createIntBuffer(nArray));
            jointMesh.originalNormal = vector3fArray4;
            jointMesh.originalVertex = vector3fArray3;
            jointMesh.jointIndex = nArray2;
            this.finalNode.attachChild(jointMesh);
            this.materialIndexes[i] = this.inFile.readByte();
        }
    }

    private void readTriangles() throws IOException {
        this.nNumTriangles = this.inFile.readUnsignedShort();
        this.myTris = new MilkTriangle[this.nNumTriangles];
        for (int i = 0; i < this.nNumTriangles; ++i) {
            int n;
            this.myTris[i] = new MilkTriangle();
            this.inFile.readUnsignedShort();
            for (n = 0; n < 3; ++n) {
                this.myTris[i].vertIndicies[n] = this.inFile.readUnsignedShort();
            }
            for (n = 0; n < 3; ++n) {
                this.myTris[i].vertNormals[n] = new Vector3f(this.inFile.readFloat(), this.inFile.readFloat(), this.inFile.readFloat());
            }
            for (n = 0; n < 3; ++n) {
                this.myTris[i].vertTexCoords[n] = new Vector2f();
                this.myTris[i].vertTexCoords[n].x = this.inFile.readFloat();
            }
            for (n = 0; n < 3; ++n) {
                this.myTris[i].vertTexCoords[n].y = 1.0f - this.inFile.readFloat();
            }
            this.inFile.readByte();
            this.inFile.readByte();
        }
    }

    private void readVerts() throws IOException {
        this.nNumVertices = this.inFile.readUnsignedShort();
        this.myVerts = new MilkVertex[this.nNumVertices];
        for (int i = 0; i < this.nNumVertices; ++i) {
            this.myVerts[i] = new MilkVertex();
            this.inFile.readByte();
            this.myVerts[i].vertex = new Vector3f(this.inFile.readFloat(), this.inFile.readFloat(), this.inFile.readFloat());
            this.myVerts[i].boneID = this.inFile.readByte();
            this.inFile.readByte();
        }
    }

    private void checkHeader() throws IOException {
        this.inFile.readFully(this.tempChar, 0, 10);
        if (!"MS3D000000".equals(new String(this.tempChar, 0, 10))) {
            throw new JmeException("Wrong File type: not Milkshape file??");
        }
        if (this.inFile.readInt() != 4) {
            throw new JmeException("Wrong file version: Not 4");
        }
    }

    private static String cutAtNull(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            return new String(byArray, 0, i);
        }
        return new String(byArray);
    }

    public static JointController findController(Node node) {
        if (node.getQuantity() == 0 || node.getChild(0).getControllers().size() == 0 || !(node.getChild(0).getController(0) instanceof JointController)) {
            return null;
        }
        return (JointController)node.getChild(0).getController(0);
    }

    private static class MilkTriangle {
        int[] vertIndicies = new int[3];
        Vector3f[] vertNormals = new Vector3f[3];
        Vector2f[] vertTexCoords = new Vector2f[3];

        private MilkTriangle() {
        }
    }

    private static class MilkVertex {
        Vector3f vertex;
        byte boneID;

        private MilkVertex() {
        }
    }
}

