/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font2d;

import com.jme.scene.Text;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jmex.font2d.Text2D;
import com.jmex.font3d.TextFactory;
import java.util.Hashtable;

public class Font2D
implements TextFactory {
    private static final String DEFAULT_FONT = "com/jme/app/defaultfont.tga";
    private static Hashtable<String, TextureState> cachedFontTextureStates = new Hashtable();
    private String fontBitmapFile = "com/jme/app/defaultfont.tga";
    private TextureState fontTextureState;

    public static TextureState getFontTextureState(String string) {
        TextureState textureState = cachedFontTextureStates.get(string);
        if (textureState == null) {
            textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            textureState.setTexture(TextureManager.loadTexture(Text.class.getClassLoader().getResource(string), 2, 1));
            textureState.setEnabled(true);
            cachedFontTextureStates.put(string, textureState);
        }
        return textureState;
    }

    public TextureState getFontTextureState() {
        return this.fontTextureState;
    }

    public String getFontBitmapFile() {
        return this.fontBitmapFile;
    }

    public Font2D() {
        this(DEFAULT_FONT);
    }

    public Font2D(String string) {
        this.fontBitmapFile = string;
        this.fontTextureState = Font2D.getFontTextureState(this.fontBitmapFile);
    }

    public Text2D createText(String string, float f, int n) {
        Text2D text2D = new Text2D(this, string, f, n);
        text2D.setCullMode(3);
        text2D.setRenderState(this.fontTextureState);
        text2D.setRenderState(Font2D.getFontAlpha());
        text2D.setTextureCombineMode(5);
        text2D.setLightCombineMode(0);
        return text2D;
    }

    private static AlphaState getFontAlpha() {
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        return alphaState;
    }

    public static void clearCachedFontTextureStates() {
        try {
            for (TextureState textureState : cachedFontTextureStates.values()) {
                textureState.deleteAll(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        cachedFontTextureStates.clear();
    }
}

