/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.water;

import com.jme.math.FastMath;
import com.jme.math.Matrix4f;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.AbstractCamera;
import com.jme.renderer.Camera;
import com.jme.renderer.Renderer;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.lwjgl.records.RendererRecord;
import com.jme.system.DisplaySystem;
import com.jme.util.Timer;
import com.jme.util.geom.BufferUtils;
import com.jmex.effects.water.HeightGenerator;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class ProjectedGrid
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ProjectedGrid.class.getName());
    private int sizeX;
    private int sizeY;
    private static Vector3f calcVec1 = new Vector3f();
    private static Vector3f calcVec2 = new Vector3f();
    private static Vector3f calcVec3 = new Vector3f();
    private TriangleBatch geomBatch;
    private int vertQuantity;
    private FloatBuffer vertBuf;
    private FloatBuffer normBuf;
    private FloatBuffer texs;
    private IntBuffer indexBuffer;
    private float viewPortWidth = 0.0f;
    private float viewPortHeight = 0.0f;
    private float viewPortLeft = 0.0f;
    private float viewPortBottom = 0.0f;
    private Quaternion origin = new Quaternion();
    private Quaternion direction = new Quaternion();
    private Vector2f source = new Vector2f();
    private Matrix4f modelViewMatrix = new Matrix4f();
    private Matrix4f projectionMatrix = new Matrix4f();
    private Matrix4f modelViewProjectionInverse = new Matrix4f();
    private Quaternion intersectBottomLeft = new Quaternion();
    private Quaternion intersectTopLeft = new Quaternion();
    private Quaternion intersectTopRight = new Quaternion();
    private Quaternion intersectBottomRight = new Quaternion();
    private Matrix4f modelViewMatrix1 = new Matrix4f();
    private Matrix4f projectionMatrix1 = new Matrix4f();
    private Matrix4f modelViewProjection1 = new Matrix4f();
    private Matrix4f modelViewProjectionInverse1 = new Matrix4f();
    private Quaternion intersectBottomLeft1 = new Quaternion();
    private Quaternion intersectTopLeft1 = new Quaternion();
    private Quaternion intersectTopRight1 = new Quaternion();
    private Quaternion intersectBottomRight1 = new Quaternion();
    private Vector3f camloc = new Vector3f();
    private Vector3f camdir = new Vector3f();
    private Quaternion pointFinal = new Quaternion();
    private Quaternion pointTop = new Quaternion();
    private Quaternion pointBottom = new Quaternion();
    private Vector3f realPoint = new Vector3f();
    public boolean freezeProjector = false;
    public boolean useReal = false;
    private Vector3f projectorLoc = new Vector3f();
    private Vector3f limit = new Vector3f();
    private Timer timer;
    private Camera cam;
    private HeightGenerator heightGenerator;
    private float textureScale;
    private float[] vertBufArray;
    private float[] normBufArray;
    private float[] texBufArray;
    private static final FloatBuffer tmp_FloatBuffer = org.lwjgl.BufferUtils.createFloatBuffer(16);
    private Vector3f localDir = new Vector3f();
    private Vector3f localLeft = new Vector3f();
    private Vector3f localUp = new Vector3f();
    private Vector3f tmpVec = new Vector3f();
    Vector3f oppositePoint = new Vector3f();
    Vector3f adjacentPoint = new Vector3f();
    Vector3f rootPoint = new Vector3f();
    Vector3f tempNorm = new Vector3f();

    public ProjectedGrid(String string, Camera camera, int n, int n2, float f, HeightGenerator heightGenerator) {
        super(string);
        this.sizeX = n;
        this.sizeY = n2;
        this.textureScale = f;
        this.heightGenerator = heightGenerator;
        this.cam = camera;
        this.timer = Timer.getTimer();
        this.geomBatch = this.getBatch(0);
        this.vertQuantity = n * n2;
        this.geomBatch.setVertexCount(this.vertQuantity);
        this.vertBufArray = new float[this.vertQuantity * 3];
        this.normBufArray = new float[this.vertQuantity * 3];
        this.texBufArray = new float[this.vertQuantity * 2];
        this.buildVertices();
        this.buildTextureCoordinates();
        this.buildNormals();
    }

    public void switchFreeze() {
        this.freezeProjector = !this.freezeProjector;
    }

    public void draw(Renderer renderer) {
        this.update();
        super.draw(renderer);
    }

    public void update() {
        int n;
        int n2;
        if (this.freezeProjector) {
            return;
        }
        float f = this.timer.getTimeInSeconds();
        this.camloc.set(this.cam.getLocation());
        this.camdir.set(this.cam.getDirection());
        AbstractCamera abstractCamera = (AbstractCamera)this.cam;
        this.viewPortWidth = abstractCamera.getWidth();
        this.viewPortHeight = abstractCamera.getHeight();
        this.viewPortLeft = abstractCamera.getViewPortLeft();
        this.viewPortBottom = abstractCamera.getViewPortBottom();
        this.modelViewMatrix.set(abstractCamera.getModelViewMatrix());
        this.projectionMatrix.set(abstractCamera.getProjectionMatrix());
        this.modelViewProjectionInverse.set(this.modelViewMatrix).multLocal(this.projectionMatrix);
        this.modelViewProjectionInverse.invertLocal();
        this.source.set(0.5f, 0.5f);
        this.getWorldIntersection(this.source, this.modelViewProjectionInverse, this.pointFinal);
        this.pointFinal.multLocal(1.0f / this.pointFinal.w);
        this.realPoint.set(this.pointFinal.x, this.pointFinal.y, this.pointFinal.z);
        this.projectorLoc.set(this.cam.getLocation());
        this.realPoint.set(this.projectorLoc).addLocal(this.cam.getDirection());
        Matrix4f matrix4f = null;
        if (this.useReal) {
            Vector3f vector3f = new Vector3f(this.projectorLoc);
            Vector3f vector3f2 = new Vector3f(this.realPoint);
            vector3f.addLocal(0.0f, 1000.0f, 0.0f);
            matrix4f = this.getMinMax(vector3f, vector3f2, this.cam);
        }
        this.matrixLookAt(this.projectorLoc, this.realPoint, this.modelViewMatrix);
        this.matrixProjection(55.0f, this.viewPortWidth / this.viewPortHeight, this.cam.getFrustumNear(), this.cam.getFrustumFar(), this.projectionMatrix);
        this.modelViewProjectionInverse.set(this.modelViewMatrix).multLocal(this.projectionMatrix);
        this.modelViewProjectionInverse.invertLocal();
        if (this.useReal && matrix4f != null) {
            matrix4f.multLocal(this.modelViewProjectionInverse);
            this.modelViewProjectionInverse.set(matrix4f);
        }
        this.source.set(0.0f, 0.0f);
        this.getWorldIntersection(this.source, this.modelViewProjectionInverse, this.intersectBottomLeft);
        this.source.set(0.0f, 1.0f);
        this.getWorldIntersection(this.source, this.modelViewProjectionInverse, this.intersectTopLeft);
        this.source.set(1.0f, 1.0f);
        this.getWorldIntersection(this.source, this.modelViewProjectionInverse, this.intersectTopRight);
        this.source.set(1.0f, 0.0f);
        this.getWorldIntersection(this.source, this.modelViewProjectionInverse, this.intersectBottomRight);
        this.tmpVec.set(this.cam.getLocation()).addLocal(this.cam.getDirection());
        this.matrixLookAt(this.cam.getLocation(), this.tmpVec, null);
        this.matrixProjection(45.0f, this.viewPortWidth / this.viewPortHeight, this.cam.getFrustumNear(), this.cam.getFrustumFar(), null);
        this.vertBuf.rewind();
        float f2 = 1.0f / (float)(this.sizeX - 1);
        float f3 = 1.0f / (float)(this.sizeY - 1);
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n3 = 0;
        for (n2 = 0; n2 < this.sizeY; ++n2) {
            for (n = 0; n < this.sizeX; ++n) {
                this.interpolate(this.intersectTopLeft, this.intersectTopRight, f4, this.pointTop);
                this.interpolate(this.intersectBottomLeft, this.intersectBottomRight, f4, this.pointBottom);
                this.interpolate(this.pointTop, this.pointBottom, f5, this.pointFinal);
                this.pointFinal.x /= this.pointFinal.w;
                this.pointFinal.z /= this.pointFinal.w;
                this.realPoint.set(this.pointFinal.x, this.heightGenerator.getHeight(this.pointFinal.x, this.pointFinal.z, f), this.pointFinal.z);
                this.vertBufArray[n3++] = this.realPoint.x;
                this.vertBufArray[n3++] = this.realPoint.y;
                this.vertBufArray[n3++] = this.realPoint.z;
                f4 += f2;
            }
            f5 += f3;
            f4 = 0.0f;
        }
        this.vertBuf.put(this.vertBufArray);
        this.texs.rewind();
        for (n2 = 0; n2 < this.vertQuantity; ++n2) {
            this.texBufArray[n2 * 2] = this.vertBufArray[n2 * 3] * this.textureScale;
            this.texBufArray[n2 * 2 + 1] = this.vertBufArray[n2 * 3 + 2] * this.textureScale;
        }
        this.texs.put(this.texBufArray);
        this.normBuf.rewind();
        this.oppositePoint.set(0.0f, 0.0f, 0.0f);
        this.adjacentPoint.set(0.0f, 0.0f, 0.0f);
        this.rootPoint.set(0.0f, 0.0f, 0.0f);
        this.tempNorm.set(0.0f, 0.0f, 0.0f);
        n2 = 0;
        n = 0;
        int n4 = 0;
        for (int i = 0; i < this.sizeY; ++i) {
            for (int j = 0; j < this.sizeX; ++j) {
                if (i == this.sizeY - 1) {
                    if (j == this.sizeX - 1) {
                        n2 = n4 - this.sizeX;
                        n = n4 - 1;
                    } else {
                        n2 = n4 + 1;
                        n = n4 - this.sizeX;
                    }
                } else if (j == this.sizeX - 1) {
                    n2 = n4 - 1;
                    n = n4 + this.sizeX;
                } else {
                    n2 = n4 + this.sizeX;
                    n = n4 + 1;
                }
                this.rootPoint.set(this.vertBufArray[n4 * 3], this.vertBufArray[n4 * 3 + 1], this.vertBufArray[n4 * 3 + 2]);
                this.adjacentPoint.set(this.vertBufArray[n2 * 3], this.vertBufArray[n2 * 3 + 1], this.vertBufArray[n2 * 3 + 2]);
                this.oppositePoint.set(this.vertBufArray[n * 3], this.vertBufArray[n * 3 + 1], this.vertBufArray[n * 3 + 2]);
                this.tempNorm.set(this.adjacentPoint).subtractLocal(this.rootPoint).crossLocal(this.oppositePoint.subtractLocal(this.rootPoint)).normalizeLocal();
                this.normBufArray[n4 * 3] = this.tempNorm.x;
                this.normBufArray[n4 * 3 + 1] = this.tempNorm.y;
                this.normBufArray[n4 * 3 + 2] = this.tempNorm.z;
                ++n4;
            }
        }
        this.normBuf.put(this.normBufArray);
    }

    private Matrix4f getMinMax(Vector3f vector3f, Vector3f vector3f2, Camera camera) {
        this.matrixLookAt(vector3f, vector3f2, this.modelViewMatrix1);
        this.matrixProjection(45.0f, this.viewPortWidth / this.viewPortHeight, camera.getFrustumNear(), camera.getFrustumFar(), this.projectionMatrix1);
        this.modelViewProjection1.set(this.modelViewMatrix1).multLocal(this.projectionMatrix1);
        this.modelViewProjectionInverse1.set(this.modelViewProjection1).invertLocal();
        this.source.set(0.0f, 0.0f);
        this.getWorldIntersection(this.source, this.modelViewProjectionInverse, this.intersectBottomLeft1);
        this.source.set(0.0f, 1.0f);
        this.getWorldIntersection(this.source, this.modelViewProjectionInverse, this.intersectTopLeft1);
        this.source.set(1.0f, 1.0f);
        this.getWorldIntersection(this.source, this.modelViewProjectionInverse, this.intersectTopRight1);
        this.source.set(1.0f, 0.0f);
        this.getWorldIntersection(this.source, this.modelViewProjectionInverse, this.intersectBottomRight1);
        Vector3f vector3f3 = new Vector3f();
        vector3f3.set(this.intersectBottomLeft.x, this.intersectBottomLeft.y, this.intersectBottomLeft.z);
        this.modelViewProjection1.mult(vector3f3, vector3f3);
        this.intersectBottomLeft.x = vector3f3.x;
        this.intersectBottomLeft.y = vector3f3.y;
        this.intersectBottomLeft.z = vector3f3.z;
        vector3f3.set(this.intersectTopLeft1.x, this.intersectTopLeft1.y, this.intersectTopLeft1.z);
        this.modelViewProjection1.mult(vector3f3, vector3f3);
        this.intersectTopLeft1.x = vector3f3.x;
        this.intersectTopLeft1.y = vector3f3.y;
        this.intersectTopLeft1.z = vector3f3.z;
        vector3f3.set(this.intersectTopRight1.x, this.intersectTopRight1.y, this.intersectTopRight1.z);
        this.modelViewProjection1.mult(vector3f3, vector3f3);
        this.intersectTopRight1.x = vector3f3.x;
        this.intersectTopRight1.y = vector3f3.y;
        this.intersectTopRight1.z = vector3f3.z;
        vector3f3.set(this.intersectBottomRight1.x, this.intersectBottomRight1.y, this.intersectBottomRight1.z);
        this.modelViewProjection1.mult(vector3f3, vector3f3);
        this.intersectBottomRight1.x = vector3f3.x;
        this.intersectBottomRight1.y = vector3f3.y;
        this.intersectBottomRight1.z = vector3f3.z;
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MIN_VALUE;
        if (this.intersectBottomLeft1.x < f) {
            f = this.intersectBottomLeft1.x;
        }
        if (this.intersectTopLeft1.x < f) {
            f = this.intersectTopLeft1.x;
        }
        if (this.intersectTopRight1.x < f) {
            f = this.intersectTopRight1.x;
        }
        if (this.intersectBottomRight1.x < f) {
            f = this.intersectBottomRight1.x;
        }
        if (this.intersectBottomLeft1.x > f3) {
            f3 = this.intersectBottomLeft1.x;
        }
        if (this.intersectTopLeft1.x > f3) {
            f3 = this.intersectTopLeft1.x;
        }
        if (this.intersectTopRight1.x > f3) {
            f3 = this.intersectTopRight1.x;
        }
        if (this.intersectBottomRight1.x > f3) {
            f3 = this.intersectBottomRight1.x;
        }
        if (this.intersectBottomLeft1.y < f2) {
            f2 = this.intersectBottomLeft1.y;
        }
        if (this.intersectTopLeft1.y < f2) {
            f2 = this.intersectTopLeft1.y;
        }
        if (this.intersectTopRight1.y < f2) {
            f2 = this.intersectTopRight1.y;
        }
        if (this.intersectBottomRight1.y < f2) {
            f2 = this.intersectBottomRight1.y;
        }
        if (this.intersectBottomLeft1.y > f4) {
            f4 = this.intersectBottomLeft1.y;
        }
        if (this.intersectTopLeft1.y > f4) {
            f4 = this.intersectTopLeft1.y;
        }
        if (this.intersectTopRight1.y > f4) {
            f4 = this.intersectTopRight1.y;
        }
        if (this.intersectBottomRight1.y > f4) {
            f4 = this.intersectBottomRight1.y;
        }
        Matrix4f matrix4f = new Matrix4f(f3 - f, 0.0f, 0.0f, f, 0.0f, f4 - f2, 0.0f, f2, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        matrix4f.transpose();
        return matrix4f;
    }

    private void matrixLookAt(Vector3f vector3f, Vector3f vector3f2, Matrix4f matrix4f) {
        this.localDir.set(vector3f2).subtractLocal(vector3f).normalizeLocal();
        this.localDir.cross(Vector3f.UNIT_Y, this.localLeft);
        this.localLeft.cross(this.localDir, this.localUp);
        RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
        rendererRecord.switchMode(5888);
        GL11.glLoadIdentity();
        GLU.gluLookAt(vector3f.x, vector3f.y, vector3f.z, vector3f2.x, vector3f2.y, vector3f2.z, this.localUp.x, this.localUp.y, this.localUp.z);
        if (matrix4f != null) {
            tmp_FloatBuffer.rewind();
            GL11.glGetFloat(2982, tmp_FloatBuffer);
            tmp_FloatBuffer.rewind();
            matrix4f.readFloatBuffer(tmp_FloatBuffer);
        }
    }

    private void matrixProjection(float f, float f2, float f3, float f4, Matrix4f matrix4f) {
        float f5 = FastMath.tan(f * ((float)Math.PI / 180)) * f3 * 0.5f;
        float f6 = f5 * f2;
        float f7 = -f6;
        float f8 = f6;
        float f9 = -f5;
        float f10 = f5;
        float f11 = f3;
        float f12 = f4;
        RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
        rendererRecord.switchMode(5889);
        GL11.glLoadIdentity();
        GL11.glFrustum(f7, f8, f9, f10, f11, f12);
        if (matrix4f != null) {
            tmp_FloatBuffer.rewind();
            GL11.glGetFloat(2983, tmp_FloatBuffer);
            tmp_FloatBuffer.rewind();
            matrix4f.readFloatBuffer(tmp_FloatBuffer);
        }
    }

    private void interpolate(Quaternion quaternion, Quaternion quaternion2, float f, Quaternion quaternion3) {
        quaternion3.x = (1.0f - f) * quaternion.x + f * quaternion2.x;
        quaternion3.z = (1.0f - f) * quaternion.z + f * quaternion2.z;
        quaternion3.w = (1.0f - f) * quaternion.w + f * quaternion2.w;
    }

    private void interpolate(Vector3f vector3f, Vector3f vector3f2, float f, Vector3f vector3f3) {
        vector3f3.x = (1.0f - f) * vector3f.x + f * vector3f2.x;
        vector3f3.y = (1.0f - f) * vector3f.y + f * vector3f2.y;
        vector3f3.z = (1.0f - f) * vector3f.z + f * vector3f2.z;
    }

    private void getWorldIntersection(Vector2f vector2f, Matrix4f matrix4f, Quaternion quaternion) {
        this.origin.set(vector2f.x * 2.0f - 1.0f, vector2f.y * 2.0f - 1.0f, -1.0f, 1.0f);
        this.direction.set(vector2f.x * 2.0f - 1.0f, vector2f.y * 2.0f - 1.0f, 1.0f, 1.0f);
        matrix4f.mult(this.origin, this.origin);
        matrix4f.mult(this.direction, this.direction);
        if (this.cam.getLocation().y > 0.0f) {
            if (this.direction.y > 0.0f) {
                this.direction.y = 0.0f;
            }
        } else if (this.direction.y < 0.0f) {
            this.direction.y = 0.0f;
        }
        this.direction.subtractLocal(this.origin);
        float f = -this.origin.y / this.direction.y;
        this.direction.multLocal(f);
        quaternion.set(this.origin);
        quaternion.addLocal(this.direction);
    }

    private float homogenousIntersect(Quaternion quaternion, Quaternion quaternion2, Quaternion quaternion3) {
        return 0.0f;
    }

    private float dotXYZ(Quaternion quaternion, Quaternion quaternion2) {
        return quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z;
    }

    private void mulXYZ(Quaternion quaternion, Quaternion quaternion2) {
    }

    public int getType() {
        return 6;
    }

    public void setDetailTexture(int n, int n2) {
        this.copyTextureCoords(0, 0, n, n2);
    }

    public Vector3f getSurfaceNormal(Vector2f vector2f, Vector3f vector3f) {
        return this.getSurfaceNormal(vector2f.x, vector2f.y, vector3f);
    }

    public Vector3f getSurfaceNormal(Vector3f vector3f, Vector3f vector3f2) {
        return this.getSurfaceNormal(vector3f.x, vector3f.z, vector3f2);
    }

    public Vector3f getSurfaceNormal(float f, float f2, Vector3f vector3f) {
        float f3 = FastMath.floor(f);
        float f4 = FastMath.floor(f2);
        if (f3 < 0.0f || f4 < 0.0f || f3 >= (float)(this.sizeX - 1) || f4 >= (float)(this.sizeY - 1)) {
            return null;
        }
        float f5 = f - f3;
        float f6 = f2 - f4;
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        Vector3f vector3f2 = vector3f;
        Vector3f vector3f3 = calcVec1;
        Vector3f vector3f4 = calcVec2;
        Vector3f vector3f5 = calcVec3;
        int n = (int)(f3 + f4 * (float)this.sizeX);
        BufferUtils.populateFromBuffer(vector3f2, this.normBuf, n);
        BufferUtils.populateFromBuffer(vector3f3, this.normBuf, n + 1);
        BufferUtils.populateFromBuffer(vector3f4, this.normBuf, n + this.sizeX);
        BufferUtils.populateFromBuffer(vector3f5, this.normBuf, n + this.sizeX + 1);
        vector3f2.interpolate(vector3f3, f5);
        vector3f4.interpolate(vector3f5, f5);
        vector3f2.interpolate(vector3f4, f6);
        return vector3f2.normalizeLocal();
    }

    private void buildVertices() {
        int n;
        int n2;
        this.vertBuf = BufferUtils.createVector3Buffer(this.vertBuf, this.vertQuantity);
        this.geomBatch.setVertexBuffer(this.vertBuf);
        Vector3f vector3f = new Vector3f();
        for (n2 = 0; n2 < this.sizeX; ++n2) {
            for (n = 0; n < this.sizeY; ++n) {
                vector3f.set(n2, 0.0f, n);
                BufferUtils.setInBuffer(vector3f, this.vertBuf, n2 + n * this.sizeX);
            }
        }
        n2 = (this.sizeX - 1) * (this.sizeY - 1) * 2;
        this.geomBatch.setTriangleQuantity(n2);
        this.indexBuffer = BufferUtils.createIntBuffer(n2 * 3);
        this.geomBatch.setIndexBuffer(this.indexBuffer);
        for (n = 0; n < this.sizeX * (this.sizeY - 1); ++n) {
            if (n % (this.sizeX * (n / this.sizeX + 1) - 1) == 0 && n != 0) continue;
            this.indexBuffer.put(n);
            this.indexBuffer.put(1 + this.sizeX + n);
            this.indexBuffer.put(1 + n);
            this.indexBuffer.put(n);
            this.indexBuffer.put(this.sizeX + n);
            this.indexBuffer.put(1 + this.sizeX + n);
        }
    }

    private void buildTextureCoordinates() {
        this.texs = BufferUtils.createVector2Buffer(this.vertQuantity);
        this.geomBatch.setTextureBuffer(this.texs, 0);
        this.texs.clear();
        this.vertBuf.rewind();
        for (int i = 0; i < this.vertQuantity; ++i) {
            this.texs.put(this.vertBuf.get() * this.textureScale);
            this.vertBuf.get();
            this.texs.put(this.vertBuf.get() * this.textureScale);
        }
    }

    private void buildNormals() {
        this.normBuf = BufferUtils.createVector3Buffer(this.normBuf, this.vertQuantity);
        this.geomBatch.setNormalBuffer(this.normBuf);
        this.oppositePoint.set(0.0f, 0.0f, 0.0f);
        this.adjacentPoint.set(0.0f, 0.0f, 0.0f);
        this.rootPoint.set(0.0f, 0.0f, 0.0f);
        this.tempNorm.set(0.0f, 0.0f, 0.0f);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.sizeY; ++i) {
            for (int j = 0; j < this.sizeX; ++j) {
                BufferUtils.populateFromBuffer(this.rootPoint, this.vertBuf, n3);
                if (i == this.sizeY - 1) {
                    if (j == this.sizeX - 1) {
                        n = n3 - this.sizeX;
                        n2 = n3 - 1;
                    } else {
                        n = n3 + 1;
                        n2 = n3 - this.sizeX;
                    }
                } else if (j == this.sizeY - 1) {
                    n = n3 - 1;
                    n2 = n3 + this.sizeX;
                } else {
                    n = n3 + this.sizeX;
                    n2 = n3 + 1;
                }
                BufferUtils.populateFromBuffer(this.adjacentPoint, this.vertBuf, n);
                BufferUtils.populateFromBuffer(this.oppositePoint, this.vertBuf, n2);
                this.tempNorm.set(this.adjacentPoint).subtractLocal(this.rootPoint).crossLocal(this.oppositePoint.subtractLocal(this.rootPoint)).normalizeLocal();
                BufferUtils.setInBuffer(this.tempNorm, this.normBuf, n3);
                ++n3;
            }
        }
    }
}

