/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.particles;

import com.jme.math.FastMath;
import com.jme.math.Line;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jmex.effects.particles.Particle;
import com.jmex.effects.particles.ParticleGeometry;
import com.jmex.effects.particles.ParticleInfluence;
import java.io.IOException;

public final class SimpleParticleInfluenceFactory {
    private SimpleParticleInfluenceFactory() {
    }

    public static ParticleInfluence createBasicWind(float f, Vector3f vector3f, boolean bl, boolean bl2) {
        return new BasicWind(f, vector3f, bl, bl2);
    }

    public static ParticleInfluence createBasicGravity(Vector3f vector3f, boolean bl) {
        return new BasicGravity(vector3f, bl);
    }

    public static ParticleInfluence createBasicDrag(float f) {
        return new BasicDrag(f);
    }

    public static ParticleInfluence createBasicVortex(float f, float f2, Line line, boolean bl, boolean bl2) {
        return new BasicVortex(f, f2, line, bl, bl2);
    }

    public static class BasicVortex
    extends ParticleInfluence {
        public static final int VT_CYLINDER = 0;
        public static final int VT_TORUS = 1;
        private int type = 0;
        private float strength;
        private float divergence;
        private float height;
        private float radius;
        private Line axis;
        private boolean random;
        private boolean transformWithScene;
        private Vector3f v1 = new Vector3f();
        private Vector3f v2 = new Vector3f();
        private Vector3f v3 = new Vector3f();
        private Quaternion rot = new Quaternion();
        private Line line = new Line();

        public BasicVortex() {
        }

        public BasicVortex(float f, float f2, Line line, boolean bl, boolean bl2) {
            this.strength = f;
            this.divergence = f2;
            this.axis = line;
            this.height = 0.0f;
            this.radius = 1.0f;
            this.random = bl;
            this.transformWithScene = bl2;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public float getStrength() {
            return this.strength;
        }

        public void setStrength(float f) {
            this.strength = f;
        }

        public float getDivergence() {
            return this.divergence;
        }

        public void setDivergence(float f) {
            this.divergence = f;
        }

        public Line getAxis() {
            return this.axis;
        }

        public void setAxis(Line line) {
            this.axis = line;
        }

        public float getHeight() {
            return this.height;
        }

        public void setHeight(float f) {
            this.height = f;
        }

        public float getRadius() {
            return this.radius;
        }

        public void setRadius(float f) {
            this.radius = f;
        }

        public boolean isRandom() {
            return this.random;
        }

        public void setRandom(boolean bl) {
            this.random = bl;
        }

        public boolean isTransformWithScene() {
            return this.transformWithScene;
        }

        public void setTransformWithScene(boolean bl) {
            this.transformWithScene = bl;
        }

        public void prepare(ParticleGeometry particleGeometry) {
            this.line.getOrigin().set(this.axis.getOrigin());
            this.line.getDirection().set(this.axis.getDirection());
            if (this.transformWithScene) {
                particleGeometry.getEmitterTransform().multPoint(this.line.getOrigin());
                particleGeometry.getEmitterTransform().multNormal(this.line.getDirection());
            }
            if (this.type == 0) {
                this.rot.fromAngleAxis(-this.divergence, this.line.getDirection());
            }
        }

        public void apply(float f, Particle particle, int n) {
            float f2 = f * this.strength * (this.random ? FastMath.nextRandomFloat() : 1.0f);
            particle.getPosition().subtract(this.line.getOrigin(), this.v1);
            this.line.getDirection().cross(this.v1, this.v2);
            if (this.v2.length() == 0.0f) {
                return;
            }
            this.v2.normalizeLocal();
            if (this.type == 0) {
                this.rot.multLocal(this.v2);
                particle.getVelocity().scaleAdd(f2, this.v2, particle.getVelocity());
                return;
            }
            this.v2.cross(this.line.getDirection(), this.v1);
            this.v1.multLocal(this.radius);
            this.v1.scaleAdd(this.height, this.line.getDirection(), this.v1);
            this.v1.addLocal(this.line.getOrigin());
            this.v1.subtractLocal(particle.getPosition());
            if (this.v1.length() == 0.0f) {
                return;
            }
            this.v1.normalizeLocal();
            this.v1.cross(this.v2, this.v3);
            this.rot.fromAngleAxis(-this.divergence, this.v2);
            this.rot.multLocal(this.v3);
            particle.getVelocity().scaleAdd(f2, this.v3, particle.getVelocity());
        }

        public void write(JMEExporter jMEExporter) throws IOException {
            super.write(jMEExporter);
            OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
            outputCapsule.write(this.type, "type", 0);
            outputCapsule.write(this.strength, "strength", 1.0f);
            outputCapsule.write(this.divergence, "divergence", 0.0f);
            outputCapsule.write(this.axis, "axis", new Line(new Vector3f(), new Vector3f(Vector3f.UNIT_Y)));
            outputCapsule.write(this.height, "height", 0.0f);
            outputCapsule.write(this.radius, "radius", 1.0f);
            outputCapsule.write(this.random, "random", false);
            outputCapsule.write(this.transformWithScene, "transformWithScene", true);
        }

        public void read(JMEImporter jMEImporter) throws IOException {
            super.read(jMEImporter);
            InputCapsule inputCapsule = jMEImporter.getCapsule(this);
            this.type = inputCapsule.readInt("type", 0);
            this.strength = inputCapsule.readFloat("strength", 1.0f);
            this.divergence = inputCapsule.readFloat("divergence", 0.0f);
            this.axis = (Line)inputCapsule.readSavable("axis", new Line(new Vector3f(), Vector3f.UNIT_Y.clone()));
            this.height = inputCapsule.readFloat("height", 0.0f);
            this.radius = inputCapsule.readFloat("radius", 1.0f);
            this.random = inputCapsule.readBoolean("random", false);
            this.transformWithScene = inputCapsule.readBoolean("transformWithScene", true);
        }

        public Class getClassTag() {
            return this.getClass();
        }
    }

    public static class BasicDrag
    extends ParticleInfluence {
        private Vector3f velocity = new Vector3f();
        private float dragCoefficient;

        public BasicDrag() {
        }

        public BasicDrag(float f) {
            this.dragCoefficient = f;
        }

        public float getDragCoefficient() {
            return this.dragCoefficient;
        }

        public void setDragCoefficient(float f) {
            this.dragCoefficient = f;
        }

        public void apply(float f, Particle particle, int n) {
            this.velocity.set(particle.getVelocity());
            particle.getVelocity().addLocal(this.velocity.multLocal(-this.dragCoefficient * f * particle.getInvMass()));
        }

        public void write(JMEExporter jMEExporter) throws IOException {
            super.write(jMEExporter);
            OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
            outputCapsule.write(this.dragCoefficient, "dragCoefficient", 1.0f);
        }

        public void read(JMEImporter jMEImporter) throws IOException {
            super.read(jMEImporter);
            InputCapsule inputCapsule = jMEImporter.getCapsule(this);
            this.dragCoefficient = inputCapsule.readFloat("dragCoefficient", 1.0f);
        }

        public Class getClassTag() {
            return this.getClass();
        }
    }

    public static class BasicGravity
    extends ParticleInfluence {
        private Vector3f gravity;
        private boolean rotateWithScene;
        private Vector3f vector = new Vector3f();

        public BasicGravity() {
        }

        public BasicGravity(Vector3f vector3f, boolean bl) {
            this.gravity = new Vector3f(vector3f);
            this.rotateWithScene = bl;
        }

        public Vector3f getGravityForce() {
            return this.gravity;
        }

        public void setGravityForce(Vector3f vector3f) {
            this.gravity = vector3f;
        }

        public boolean isRotateWithScene() {
            return this.rotateWithScene;
        }

        public void setRotateWithScene(boolean bl) {
            this.rotateWithScene = bl;
        }

        public void prepare(ParticleGeometry particleGeometry) {
            this.vector.set(this.gravity);
            if (this.rotateWithScene) {
                particleGeometry.getEmitterTransform().multNormal(this.vector);
            }
        }

        public void apply(float f, Particle particle, int n) {
            particle.getVelocity().scaleAdd(f, this.vector, particle.getVelocity());
        }

        public void write(JMEExporter jMEExporter) throws IOException {
            super.write(jMEExporter);
            OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
            outputCapsule.write(this.gravity, "gravity", Vector3f.ZERO);
            outputCapsule.write(this.rotateWithScene, "rotateWithScene", true);
        }

        public void read(JMEImporter jMEImporter) throws IOException {
            super.read(jMEImporter);
            InputCapsule inputCapsule = jMEImporter.getCapsule(this);
            this.gravity = (Vector3f)inputCapsule.readSavable("gravity", Vector3f.ZERO.clone());
            this.rotateWithScene = inputCapsule.readBoolean("rotateWithScene", true);
        }

        public Class getClassTag() {
            return this.getClass();
        }
    }

    public static class BasicWind
    extends ParticleInfluence {
        private float strength;
        private Vector3f windDirection;
        private boolean random;
        private boolean rotateWithScene;
        private Vector3f vector = new Vector3f();

        public BasicWind() {
        }

        public BasicWind(float f, Vector3f vector3f, boolean bl, boolean bl2) {
            this.strength = f;
            this.windDirection = vector3f;
            this.random = bl;
            this.rotateWithScene = bl2;
        }

        public float getStrength() {
            return this.strength;
        }

        public void setStrength(float f) {
            this.strength = f;
        }

        public Vector3f getWindDirection() {
            return this.windDirection;
        }

        public void setWindDirection(Vector3f vector3f) {
            this.windDirection = vector3f;
        }

        public boolean isRandom() {
            return this.random;
        }

        public void setRandom(boolean bl) {
            this.random = bl;
        }

        public boolean isRotateWithScene() {
            return this.rotateWithScene;
        }

        public void setRotateWithScene(boolean bl) {
            this.rotateWithScene = bl;
        }

        public void prepare(ParticleGeometry particleGeometry) {
            this.vector.set(this.windDirection);
            if (this.rotateWithScene) {
                particleGeometry.getEmitterTransform().multNormal(this.vector);
            }
        }

        public void apply(float f, Particle particle, int n) {
            float f2 = this.random ? FastMath.nextRandomFloat() * this.strength : this.strength;
            particle.getVelocity().scaleAdd(f2 * f, this.vector, particle.getVelocity());
        }

        public void write(JMEExporter jMEExporter) throws IOException {
            super.write(jMEExporter);
            OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
            outputCapsule.write(this.strength, "strength", 1.0f);
            outputCapsule.write(this.windDirection, "windDirection", Vector3f.UNIT_X);
            outputCapsule.write(this.random, "random", false);
            outputCapsule.write(this.rotateWithScene, "rotateWithScene", true);
        }

        public void read(JMEImporter jMEImporter) throws IOException {
            super.read(jMEImporter);
            InputCapsule inputCapsule = jMEImporter.getCapsule(this);
            this.strength = inputCapsule.readFloat("strength", 1.0f);
            this.windDirection = (Vector3f)inputCapsule.readSavable("windDirection", Vector3f.UNIT_X.clone());
            this.random = inputCapsule.readBoolean("random", false);
            this.rotateWithScene = inputCapsule.readBoolean("rotateWithScene", true);
        }

        public Class getClassTag() {
            return this.getClass();
        }
    }
}

