/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.particles;

import com.jme.bounding.CollisionTree;
import com.jme.bounding.CollisionTreeManager;
import com.jme.intersection.CollisionResults;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import com.jmex.effects.particles.Particle;
import com.jmex.effects.particles.ParticleGeometry;
import java.io.IOException;
import java.util.ArrayList;

public class ParticleMesh
extends ParticleGeometry {
    private static final long serialVersionUID = 2L;
    private boolean useBatchTexCoords = true;
    private boolean useTriangleNormalEmit = true;

    public ParticleMesh() {
    }

    public ParticleMesh(String string, int n) {
        super(string, n);
        this.setRenderQueueMode(3);
        this.setLightCombineMode(0);
        this.setTextureCombineMode(5);
    }

    public ParticleMesh(String string, int n, int n2) {
        super(string, n, n2);
        this.setRenderQueueMode(3);
        this.setLightCombineMode(0);
        this.setTextureCombineMode(5);
    }

    public ParticleMesh(String string, TriangleBatch triangleBatch) {
        super(string, 0, 4);
        this.numParticles = triangleBatch.getTriangleCount();
        this.psBatch = triangleBatch;
        this.setRenderQueueMode(3);
        this.setLightCombineMode(0);
        this.setTextureCombineMode(5);
        this.initializeParticles(triangleBatch.getTriangleCount());
    }

    protected void initializeParticles(int n) {
        int n2;
        int[] nArray;
        Vector2f[] vector2fArray;
        TriangleBatch triangleBatch = this.getBatch(0);
        this.particles = new Particle[n];
        if (n == 0) {
            return;
        }
        switch (this.getParticleType()) {
            case 1: 
            case 4: {
                vector2fArray = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(0.0f, 2.0f), new Vector2f(2.0f, 0.0f)};
                break;
            }
            case 0: {
                vector2fArray = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f)};
                break;
            }
            default: {
                throw new IllegalStateException("Particle Mesh may only have particle type of PT_QUAD or PT_TRIANGLE");
            }
        }
        int n3 = ParticleMesh.getVertsForParticleType(this.getParticleType());
        this.geometryCoordinates = BufferUtils.createVector3Buffer(n * n3);
        switch (this.getParticleType()) {
            case 1: 
            case 4: {
                nArray = new int[n * 3];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[0 + n2 * 3] = n2 * 3 + 2;
                    nArray[1 + n2 * 3] = n2 * 3 + 1;
                    nArray[2 + n2 * 3] = n2 * 3 + 0;
                }
                break;
            }
            case 0: {
                nArray = new int[n * 6];
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[0 + n2 * 6] = n2 * 4 + 2;
                    nArray[1 + n2 * 6] = n2 * 4 + 1;
                    nArray[2 + n2 * 6] = n2 * 4 + 0;
                    nArray[3 + n2 * 6] = n2 * 4 + 2;
                    nArray[4 + n2 * 6] = n2 * 4 + 3;
                    nArray[5 + n2 * 6] = n2 * 4 + 1;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Particle Mesh may only have particle type of PT_QUAD or PT_TRIANGLE");
            }
        }
        this.appearanceColors = BufferUtils.createColorBuffer(n * n3);
        triangleBatch.setVertexBuffer(this.geometryCoordinates);
        triangleBatch.setColorBuffer(this.appearanceColors);
        triangleBatch.setTextureBuffer(BufferUtils.createVector2Buffer(n * n3), 0);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(nArray));
        this.invScale = new Vector3f();
        for (n2 = 0; n2 < n; ++n2) {
            this.particles[n2] = new Particle(this);
            this.particles[n2].init();
            this.particles[n2].setStartIndex(n2 * n3);
            for (int i = n3 - 1; i >= 0; --i) {
                int n4 = n2 * n3 + i;
                if (this.particleType == 4 && this.useBatchTexCoords) {
                    int n5 = ((TriangleBatch)this.psBatch).getIndexBuffer().get(n4);
                    BufferUtils.populateFromBuffer(workVect2, this.psBatch.getTextureBuffer(0), n5);
                    BufferUtils.setInBuffer(workVect2, triangleBatch.getTextureBuffer(0), n4);
                } else {
                    BufferUtils.setInBuffer(vector2fArray[i], triangleBatch.getTextureBuffer(0), n4);
                }
                BufferUtils.setInBuffer(this.particles[n2].getCurrentColor(), this.appearanceColors, n4);
            }
        }
    }

    public void draw(Renderer renderer) {
        TriangleBatch triangleBatch;
        Camera camera = renderer.getCamera();
        for (int i = 0; i < this.particles.length; ++i) {
            Particle particle = this.particles[i];
            if (particle.getStatus() != 1) continue;
            particle.updateVerts(camera);
        }
        if (this.getBatchCount() == 1 && (triangleBatch = this.getBatch(0)) != null && triangleBatch.isEnabled()) {
            triangleBatch.setLastFrustumIntersection(this.frustrumIntersects);
            triangleBatch.draw(renderer);
            return;
        }
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            TriangleBatch triangleBatch2 = this.getBatch(i);
            if (triangleBatch2 == null || !triangleBatch2.isEnabled()) continue;
            triangleBatch2.onDraw(renderer);
        }
    }

    public void resetParticleVelocity(int n) {
        if (this.particleType == 4 && this.useTriangleNormalEmit) {
            this.particles[n].getVelocity().set(this.particles[n].getTriangleModel().getNormal());
            this.particles[n].getVelocity().multLocal(this.emissionDirection);
            this.particles[n].getVelocity().multLocal(this.getInitialVelocity());
        } else {
            super.resetParticleVelocity(n);
        }
    }

    public boolean isUseBatchTexCoords() {
        return this.useBatchTexCoords;
    }

    public void setUseBatchTexCoords(boolean bl) {
        this.useBatchTexCoords = bl;
    }

    public boolean isUseTriangleNormalEmit() {
        return this.useTriangleNormalEmit;
    }

    public void setUseTriangleNormalEmit(boolean bl) {
        this.useTriangleNormalEmit = bl;
    }

    protected void setupBatchList() {
        this.batchList = new ArrayList(1);
        TriangleBatch triangleBatch = new TriangleBatch();
        triangleBatch.setParentGeom(this);
        this.batchList.add(triangleBatch);
    }

    public TriangleBatch getBatch(int n) {
        return (TriangleBatch)this.batchList.get(n);
    }

    public boolean hasCollision(Spatial spatial, boolean bl) {
        if (this == spatial || !this.isCollidable || !spatial.isCollidable()) {
            return false;
        }
        if (this.getWorldBound().intersects(spatial.getWorldBound())) {
            if ((spatial.getType() & 1) != 0) {
                Node node = (Node)spatial;
                for (int i = 0; i < node.getQuantity(); ++i) {
                    if (!this.hasCollision(node.getChild(i), bl)) continue;
                    return true;
                }
                return false;
            }
            if (!bl) {
                return true;
            }
            return this.hasTriangleCollision((TriMesh)spatial);
        }
        return false;
    }

    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
        if (this == spatial || !this.isCollidable || !spatial.isCollidable()) {
            return;
        }
        if (this.getWorldBound().intersects(spatial.getWorldBound())) {
            if ((spatial.getType() & 1) != 0) {
                Node node = (Node)spatial;
                for (int i = 0; i < node.getQuantity(); ++i) {
                    this.findCollisions(node.getChild(i), collisionResults);
                }
            } else {
                collisionResults.addCollision(this, (Geometry)spatial);
            }
        }
    }

    public boolean hasTriangleCollision(TriMesh triMesh) {
        for (int i = 0; i < this.getBatchCount(); ++i) {
            TriangleBatch triangleBatch = this.getBatch(i);
            if (triangleBatch == null || !triangleBatch.isEnabled()) continue;
            for (int j = 0; j < triMesh.getBatchCount(); ++j) {
                TriangleBatch triangleBatch2 = triMesh.getBatch(j);
                if (triangleBatch2 == null || !triangleBatch2.isEnabled() || !this.hasTriangleCollision(triMesh, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasTriangleCollision(TriMesh triMesh, int n, int n2) {
        CollisionTree collisionTree = CollisionTreeManager.getInstance().getCollisionTree(this.getBatch(n));
        CollisionTree collisionTree2 = CollisionTreeManager.getInstance().getCollisionTree(triMesh.getBatch(n2));
        if (collisionTree == null || collisionTree2 == null || !this.isCollidable || !triMesh.isCollidable()) {
            return false;
        }
        collisionTree.getBounds().transform(this.worldRotation, this.worldTranslation, this.worldScale, collisionTree.getWorldBounds());
        return collisionTree.intersect(collisionTree2);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.useBatchTexCoords, "useBatchTexCoords", true);
        outputCapsule.write(this.useTriangleNormalEmit, "useTriangleNormalEmit", true);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.useBatchTexCoords = inputCapsule.readBoolean("useBatchTexCoords", true);
        this.useTriangleNormalEmit = inputCapsule.readBoolean("useTriangleNormalEmit", true);
    }
}

