/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.cloth;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.math.spring.SpringPoint;
import com.jme.math.spring.SpringPointForce;
import com.jme.math.spring.SpringSystem;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class ClothPatch
extends TriMesh {
    private static final long serialVersionUID = 1L;
    protected int clothNodesX;
    protected int clothNodesY;
    protected float springLength;
    protected SpringSystem system;
    protected float sinceLast = 0.0f;
    protected float timeDilation = 1.0f;
    private Vector3f tNorm = new Vector3f();
    private Vector3f tempV1 = new Vector3f();
    private Vector3f tempV2 = new Vector3f();
    private Vector3f tempV3 = new Vector3f();

    public ClothPatch() {
    }

    public ClothPatch(String string, int n, int n2, float f, float f2) {
        super(string);
        this.clothNodesX = n;
        this.clothNodesY = n2;
        this.springLength = f;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount(this.clothNodesY * this.clothNodesX);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setTriangleQuantity((this.clothNodesX - 1) * (this.clothNodesY - 1) * 2);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(3 * triangleBatch.getTriangleCount()));
        this.initCloth(f2);
    }

    public ClothPatch(String string, int n, int n2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, float f) {
        super(string);
        this.clothNodesX = n;
        this.clothNodesY = n2;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount(this.clothNodesY * this.clothNodesX);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setTriangleQuantity((this.clothNodesX - 1) * (this.clothNodesY - 1) * 2);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(3 * triangleBatch.getTriangleCount()));
        this.initCloth(f, vector3f, vector3f2, vector3f3, vector3f4);
    }

    public void addForce(SpringPointForce springPointForce) {
        this.system.addForce(springPointForce);
    }

    public boolean removeForce(SpringPointForce springPointForce) {
        return this.system.removeForce(springPointForce);
    }

    public void updateNormals() {
        int n;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.getNormalBuffer().clear();
        int n2 = triangleBatch.getNormalBuffer().capacity();
        while (--n2 >= 0) {
            triangleBatch.getNormalBuffer().put(0.0f);
        }
        triangleBatch.getIndexBuffer().rewind();
        int n3 = triangleBatch.getIndexBuffer().capacity();
        for (n = 0; n < n3; n += 3) {
            n2 = triangleBatch.getIndexBuffer().get();
            int n4 = triangleBatch.getIndexBuffer().get();
            int n5 = triangleBatch.getIndexBuffer().get();
            this.getTriangleNormal(n2, n4, n5, this.tNorm);
            BufferUtils.addInBuffer(this.tNorm, triangleBatch.getNormalBuffer(), n2);
            BufferUtils.addInBuffer(this.tNorm, triangleBatch.getNormalBuffer(), n4);
            BufferUtils.addInBuffer(this.tNorm, triangleBatch.getNormalBuffer(), n5);
        }
        n = triangleBatch.getVertexCount();
        while (--n >= 0) {
            BufferUtils.normalizeVector3(triangleBatch.getNormalBuffer(), n);
        }
    }

    protected Vector3f getTriangleNormal(int n, int n2, int n3, Vector3f vector3f) {
        TriangleBatch triangleBatch = this.getBatch(0);
        BufferUtils.populateFromBuffer(this.tempV1, triangleBatch.getVertexBuffer(), n);
        BufferUtils.populateFromBuffer(this.tempV2, triangleBatch.getVertexBuffer(), n2);
        BufferUtils.populateFromBuffer(this.tempV3, triangleBatch.getVertexBuffer(), n3);
        this.tempV2.subtractLocal(this.tempV1);
        this.tempV3.subtractLocal(this.tempV1);
        this.tempV2.cross(this.tempV3, vector3f);
        return vector3f;
    }

    protected void initCloth(float f) {
        float f2 = this.springLength * (0.0f - 0.5f * (float)(this.clothNodesX - 1));
        float f3 = this.springLength * ((float)(this.clothNodesX - 1) - 0.5f * (float)(this.clothNodesX - 1));
        float f4 = this.springLength * (0.5f * (float)(this.clothNodesY - 1) - 0.0f);
        float f5 = this.springLength * (0.5f * (float)(this.clothNodesY - 1) - (float)(this.clothNodesY - 1));
        Vector3f vector3f = new Vector3f(f2, f4, 0.0f);
        Vector3f vector3f2 = new Vector3f(f2, f5, 0.0f);
        Vector3f vector3f3 = new Vector3f(f3, f5, 0.0f);
        Vector3f vector3f4 = new Vector3f(f3, f4, 0.0f);
        this.initCloth(f, vector3f, vector3f2, vector3f3, vector3f4);
    }

    protected void initCloth(float f, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        Vector2f vector2f = new Vector2f();
        Vector3f vector3f5 = new Vector3f();
        Vector3f vector3f6 = new Vector3f();
        Vector3f vector3f7 = new Vector3f();
        TriangleBatch triangleBatch = this.getBatch(0);
        FloatBuffer floatBuffer = triangleBatch.getTextureBuffers().get(0);
        for (int i = 0; i < this.clothNodesY; ++i) {
            for (int j = 0; j < this.clothNodesX; ++j) {
                int n = this.getIndex(j, i);
                float f2 = (float)j / (float)(this.clothNodesX - 1);
                vector3f6.interpolate(vector3f, vector3f4, f2);
                vector3f7.interpolate(vector3f2, vector3f3, f2);
                vector3f5.interpolate(vector3f6, vector3f7, (float)i / (float)(this.clothNodesY - 1));
                BufferUtils.setInBuffer(vector3f5, triangleBatch.getVertexBuffer(), n);
                vector2f.set((float)j / (float)(this.clothNodesX - 1), (float)(this.clothNodesY - (i + 1)) / (float)(this.clothNodesY - 1));
                BufferUtils.setInBuffer(vector2f, floatBuffer, n);
            }
        }
        this.system = SpringSystem.createRectField(this.clothNodesX, this.clothNodesY, triangleBatch.getVertexBuffer(), f);
        this.setupIndices();
    }

    public SpringSystem getSystem() {
        return this.system;
    }

    public int getClothNodesY() {
        return this.clothNodesY;
    }

    public int getClothNodesX() {
        return this.clothNodesX;
    }

    public float getSpringLength() {
        return this.springLength;
    }

    public float getTimeDilation() {
        return this.timeDilation;
    }

    public void setTimeDilation(float f) {
        this.timeDilation = f;
    }

    protected void setupIndices() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.getIndexBuffer().rewind();
        for (int i = 0; i < this.clothNodesY - 1; ++i) {
            for (int j = 0; j < this.clothNodesX - 1; ++j) {
                triangleBatch.getIndexBuffer().put(this.getIndex(j, i));
                triangleBatch.getIndexBuffer().put(this.getIndex(j, i + 1));
                triangleBatch.getIndexBuffer().put(this.getIndex(j + 1, i + 1));
                triangleBatch.getIndexBuffer().put(this.getIndex(j, i));
                triangleBatch.getIndexBuffer().put(this.getIndex(j + 1, i + 1));
                triangleBatch.getIndexBuffer().put(this.getIndex(j + 1, i));
            }
        }
    }

    protected int getIndex(int n, int n2) {
        return n2 * this.clothNodesX + n;
    }

    public void updateWorldData(float f) {
        super.updateWorldData(f);
        this.sinceLast += f;
        if (this.sinceLast >= 0.025f) {
            this.sinceLast *= this.timeDilation;
            this.calcForces(this.sinceLast);
            this.doUpdate(this.sinceLast);
            this.sinceLast = 0.0f;
        }
    }

    protected void calcForces(float f) {
        this.system.calcForces(f);
    }

    protected void doUpdate(float f) {
        this.system.update(f);
        this.updateVertexBufferfer();
        this.updateNormals();
    }

    protected void updateVertexBufferfer() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.getVertexBuffer().rewind();
        for (int i = 0; i < this.system.getNodeCount(); ++i) {
            SpringPoint springPoint = this.system.getNode(i);
            triangleBatch.getVertexBuffer().put(springPoint.position.x).put(springPoint.position.y).put(springPoint.position.z);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.clothNodesX, "clothNodesX", 0);
        outputCapsule.write(this.clothNodesY, "clothNodesY", 0);
        outputCapsule.write(this.springLength, "springLength", 0.0f);
        outputCapsule.write(this.system, "system", null);
        outputCapsule.write(this.timeDilation, "timeDilation", 1.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.clothNodesX = inputCapsule.readInt("clothNodesX", 0);
        this.clothNodesY = inputCapsule.readInt("clothNodesY", 0);
        this.springLength = inputCapsule.readFloat("springLength", 0.0f);
        this.system = (SpringSystem)inputCapsule.readSavable("system", null);
        this.timeDilation = inputCapsule.readFloat("timeDilation", 1.0f);
        if (this.system == null) {
            this.initCloth(0.0f);
        }
    }
}

