/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects;

import com.jme.math.Vector2f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.VBOInfo;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jmex.effects.FlareQuad;
import com.jmex.effects.LensFlare;

public class LensFlareFactory {
    private LensFlareFactory() {
    }

    public static LensFlare createBasicLensFlare(String string, TextureState[] textureStateArray) {
        if (textureStateArray == null) {
            throw new JmeException("Invalid (null) TextureStates array provided to LensFlareFactory.createBasicLensFlare(String, TextureState[])");
        }
        if (textureStateArray.length != 4) {
            throw new JmeException("Wrong number of TextureStates provided to LensFlareFactory.createBasicLensFlare(String, TextureState[]).  Must be 4.");
        }
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        Vector2f vector2f = new Vector2f(displaySystem.getWidth() >> 1, displaySystem.getHeight() >> 1);
        LensFlare lensFlare = new LensFlare(string);
        lensFlare.setRenderState(textureStateArray[2]);
        FlareQuad[] flareQuadArray = new FlareQuad[16];
        flareQuadArray[0] = new FlareQuad("sf0", vector2f.x * 1.25f, vector2f.x * 1.25f);
        flareQuadArray[0].setOffset(0.8f, 0.8f);
        flareQuadArray[0].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.0f, 1.0f));
        flareQuadArray[0].setRenderState(textureStateArray[3]);
        flareQuadArray[1] = new FlareQuad("sf1", vector2f.x * 0.75f, vector2f.x * 0.75f);
        flareQuadArray[1].setOffset(1.0f, 1.0f);
        flareQuadArray[1].setDefaultColor(new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f));
        flareQuadArray[1].setRenderState(textureStateArray[1]);
        flareQuadArray[2] = new FlareQuad("sf2", vector2f.x * 0.15f, vector2f.x * 0.15f);
        flareQuadArray[2].setOffset(0.8f, 0.8f);
        flareQuadArray[2].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.0f, 1.0f));
        flareQuadArray[3] = new FlareQuad("sf3", vector2f.x * 0.08f, vector2f.x * 0.08f);
        flareQuadArray[3].setOffset(2.0f, 2.0f);
        flareQuadArray[3].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.19607843f, 1.0f));
        flareQuadArray[4] = new FlareQuad("sf4", vector2f.x * 0.4f, vector2f.x * 0.4f);
        flareQuadArray[4].setOffset(2.2f, 2.2f);
        flareQuadArray[4].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.19607843f, 1.0f));
        flareQuadArray[5] = new FlareQuad("sf5", vector2f.x * 0.1f, vector2f.x * 0.1f);
        flareQuadArray[5].setOffset(2.4f, 2.4f);
        flareQuadArray[5].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.19607843f, 1.0f));
        flareQuadArray[6] = new FlareQuad("sf6", vector2f.x * 0.25f, vector2f.x * 0.25f);
        flareQuadArray[6].setOffset(3.0f, 3.0f);
        flareQuadArray[6].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.19607843f, 1.0f));
        flareQuadArray[7] = new FlareQuad("sf7", vector2f.x * 0.01f, vector2f.x * 0.01f);
        flareQuadArray[7].setOffset(5.0f, 5.0f);
        flareQuadArray[7].setDefaultColor(new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f));
        flareQuadArray[8] = new FlareQuad("sf8", vector2f.x * 0.02f, vector2f.x * 0.02f);
        flareQuadArray[8].setOffset(-3.0f, -3.0f);
        flareQuadArray[8].setDefaultColor(new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f));
        flareQuadArray[9] = new FlareQuad("sf9", vector2f.x * 0.1f, vector2f.x * 0.1f);
        flareQuadArray[9].setOffset(-2.0f, -2.0f);
        flareQuadArray[9].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.0f, 1.0f));
        flareQuadArray[10] = new FlareQuad("sf10", vector2f.x * 0.06f, vector2f.x * 0.06f);
        flareQuadArray[10].setOffset(-1.8f, -1.8f);
        flareQuadArray[10].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.0f, 1.0f));
        flareQuadArray[11] = new FlareQuad("sf11", vector2f.x * 0.375f, vector2f.x * 0.375f);
        flareQuadArray[11].setOffset(-1.5f, -1.5f);
        flareQuadArray[11].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.0f, 1.0f));
        flareQuadArray[12] = new FlareQuad("sf12", vector2f.x * 0.1f, vector2f.x * 0.1f);
        flareQuadArray[12].setOffset(-1.4f, -1.4f);
        flareQuadArray[12].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.0f, 1.0f));
        flareQuadArray[13] = new FlareQuad("sf13", vector2f.x * 0.25f, vector2f.x * 0.25f);
        flareQuadArray[13].setOffset(-1.1f, -1.1f);
        flareQuadArray[13].setDefaultColor(new ColorRGBA(0.11764706f, 0.11764706f, 0.0f, 1.0f));
        flareQuadArray[14] = new FlareQuad("sf14", vector2f.x * 0.75f, vector2f.x * 0.75f);
        flareQuadArray[14].setOffset(-1.0f, -1.0f);
        flareQuadArray[14].setDefaultColor(new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f));
        flareQuadArray[14].setRenderState(textureStateArray[1]);
        flareQuadArray[15] = new FlareQuad("mainFlare", vector2f.x * 0.75f, vector2f.x * 0.75f);
        flareQuadArray[15].setOffset(1.0f, 1.0f);
        flareQuadArray[15].setDefaultColor(new ColorRGBA(0.95f, 0.95f, 0.95f, 1.0f));
        flareQuadArray[15].setRenderState(textureStateArray[0]);
        for (int i = 0; i < flareQuadArray.length; ++i) {
            flareQuadArray[i].setVBOInfo(new VBOInfo(true));
            lensFlare.attachChild(flareQuadArray[i]);
        }
        return lensFlare;
    }
}

