/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.widget;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jmex.editors.swing.widget.ValuePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SphericalUnitVectorPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private ValuePanel azimuthPanel = new ValuePanel("Azimuth: ", "", -180.0f, 180.0f, 1.0f);
    private ValuePanel elevationPanel = new ValuePanel("Elevation: ", "", -90.0f, 90.0f, 1.0f);
    private ArrayList<ChangeListener> changeListeners = new ArrayList();
    private boolean setting;
    private Vector3f vector = new Vector3f();

    public SphericalUnitVectorPanel() {
        super(new GridBagLayout());
        this.azimuthPanel.addChangeListener(this);
        this.elevationPanel.addChangeListener(this);
        this.add((Component)this.azimuthPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.elevationPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setValue(Vector3f vector3f) {
        FastMath.cartesianToSpherical(vector3f, this.vector);
        this.setting = true;
        this.azimuthPanel.setValue(this.vector.y * 57.295776f);
        this.elevationPanel.setValue(this.vector.z * 57.295776f);
        this.setting = false;
    }

    public Vector3f getValue() {
        this.vector.set(1.0f, this.azimuthPanel.getFloatValue() * ((float)Math.PI / 180), this.elevationPanel.getFloatValue() * ((float)Math.PI / 180));
        Vector3f vector3f = new Vector3f();
        FastMath.sphericalToCartesian(this.vector, vector3f);
        return vector3f;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.setting) {
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }
}

