/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt.swingui;

import com.jme.input.InputHandler;
import com.jme.scene.Node;
import com.jme.system.DisplaySystem;
import com.jme.util.GameTaskQueueManager;
import com.jmex.awt.swingui.JMEDesktop;
import com.jmex.game.state.BasicGameState;
import java.awt.Color;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JMEDesktopState
extends BasicGameState {
    private static final Logger logger = Logger.getLogger(JMEDesktopState.class.getName());
    private boolean variableDesktopSize;
    private Node guiNode;
    private InputHandler guiInput;
    private JMEDesktop desktop;
    private int width;
    private int height;

    public JMEDesktopState() {
        this(800, 600);
    }

    public JMEDesktopState(int n, int n2) {
        super("jMEDesktop");
        this.width = n;
        this.height = n2;
        this.init();
    }

    public JMEDesktopState(boolean bl) {
        super("jMEDesktop");
        this.variableDesktopSize = bl;
        this.init();
    }

    private void init() {
        this.guiNode = new Node("GUI");
        this.guiNode.setCullMode(3);
        this.guiNode.setLightCombineMode(0);
        this.rootNode = new Node("RootNode");
        this.guiInput = new InputHandler();
        this.guiInput.setEnabled(true);
        Future<JMEDesktop> future = GameTaskQueueManager.getManager().update(new Callable<JMEDesktop>(){

            @Override
            public JMEDesktop call() throws Exception {
                if (JMEDesktopState.this.variableDesktopSize) {
                    return new JMEDesktop("Desktop", DisplaySystem.getDisplaySystem().getWidth(), DisplaySystem.getDisplaySystem().getHeight(), JMEDesktopState.this.guiInput);
                }
                return new JMEDesktop("Desktop", JMEDesktopState.this.width, JMEDesktopState.this.height, JMEDesktopState.this.guiInput);
            }
        });
        try {
            this.desktop = future.get();
            this.desktop.getJDesktop().setName("Desktop");
            this.desktop.getJDesktop().setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
            this.desktop.getJDesktop().setOpaque(true);
            this.guiNode.attachChild(this.desktop);
            this.guiNode.getLocalTranslation().set(DisplaySystem.getDisplaySystem().getWidth() / 2, DisplaySystem.getDisplaySystem().getHeight() / 2, 0.0f);
            this.guiNode.getLocalScale().set(1.0f, 1.0f, 1.0f);
            this.guiNode.updateRenderState();
            this.guiNode.updateGeometricState(0.0f, true);
            this.guiNode.setRenderQueueMode(4);
            this.guiNode.updateGeometricState(0.0f, true);
            this.guiNode.updateRenderState();
        }
        catch (InterruptedException interruptedException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "init()", "Exception", interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "init()", "Exception", executionException);
        }
        this.buildUI();
    }

    protected void buildUI() {
    }

    public void update(float f) {
        this.guiInput.update(f);
        this.guiNode.updateGeometricState(f, true);
        super.update(f);
    }

    public void render(float f) {
        DisplaySystem.getDisplaySystem().getRenderer().draw(this.guiNode);
    }

    public void cleanup() {
        this.desktop.dispose();
    }

    public Node getGUINode() {
        return this.guiNode;
    }

    public JMEDesktop getDesktop() {
        return this.desktop;
    }

    public InputHandler getInputHandler() {
        return this.guiInput;
    }
}

