/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt.input;

import com.jme.image.Image;
import com.jme.input.MouseInput;
import com.jme.input.MouseInputListener;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.net.URL;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;

public class AWTMouseInput
extends MouseInput
implements MouseListener,
MouseWheelListener,
MouseMotionListener {
    public static int WHEEL_AMP = 40;
    private int currentWheelDelta;
    private int wheelDelta;
    private int wheelRotation;
    private boolean enabled = true;
    private boolean dragOnly = false;
    private BitSet buttons = new BitSet(3);
    private Point absPoint = new Point();
    private Point lastPoint = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private Point currentDeltaPoint = new Point();
    private Point deltaPoint = new Point();
    private Component deltaRelative;
    private List<MouseEvent> swingEvents = new LinkedList<MouseEvent>();
    private int lastEventX;
    private int lastEventY;

    protected AWTMouseInput() {
    }

    protected void destroy() {
    }

    public int getButtonIndex(String string) {
        if ("MOUSE0".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("MOUSE1".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("MOUSE2".equalsIgnoreCase(string)) {
            return 2;
        }
        throw new IllegalArgumentException("invalid buttonName: " + string);
    }

    public boolean isButtonDown(int n) {
        return this.buttons.get(n);
    }

    public String getButtonName(int n) {
        switch (n) {
            case 0: {
                return "MOUSE0";
            }
            case 1: {
                return "MOUSE1";
            }
            case 2: {
                return "MOUSE2";
            }
        }
        throw new IllegalArgumentException("invalid buttonIndex: " + n);
    }

    public int getWheelDelta() {
        return this.wheelDelta;
    }

    public int getXDelta() {
        if (this.deltaRelative != null) {
            if (!this.enabled) {
                return 0;
            }
            int n = this.deltaRelative.getWidth() / 2 - this.absPoint.x;
            return (int)((float)n * -0.01f);
        }
        return this.deltaPoint.x;
    }

    public int getYDelta() {
        if (this.deltaRelative != null) {
            if (!this.enabled) {
                return 0;
            }
            int n = this.deltaRelative.getHeight() / 2 - this.absPoint.y;
            return (int)((float)n * 0.05f);
        }
        return this.deltaPoint.y;
    }

    public int getXAbsolute() {
        return this.absPoint.x;
    }

    public int getYAbsolute() {
        return this.absPoint.y;
    }

    public void update() {
        int n = this.lastEventX;
        int n2 = this.lastEventY;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            block5: while (!this.swingEvents.isEmpty()) {
                MouseEvent mouseEvent = this.swingEvents.remove(0);
                switch (mouseEvent.getID()) {
                    case 503: 
                    case 506: {
                        MouseInputListener mouseInputListener;
                        int n3;
                        for (n3 = 0; n3 < this.listeners.size(); ++n3) {
                            mouseInputListener = (MouseInputListener)this.listeners.get(n3);
                            mouseInputListener.onMove(mouseEvent.getX() - n, n2 - mouseEvent.getY(), mouseEvent.getX(), mouseEvent.getY());
                        }
                        n = mouseEvent.getX();
                        n2 = mouseEvent.getY();
                        break;
                    }
                    case 501: 
                    case 502: {
                        MouseInputListener mouseInputListener;
                        int n3;
                        for (n3 = 0; n3 < this.listeners.size(); ++n3) {
                            mouseInputListener = (MouseInputListener)this.listeners.get(n3);
                            mouseInputListener.onButton(this.getJMEButtonIndex(mouseEvent), mouseEvent.getID() == 501, mouseEvent.getX(), mouseEvent.getY());
                        }
                        continue block5;
                    }
                    case 507: {
                        MouseInputListener mouseInputListener;
                        int n3;
                        for (n3 = 0; n3 < this.listeners.size(); ++n3) {
                            mouseInputListener = (MouseInputListener)this.listeners.get(n3);
                            mouseInputListener.onWheel(((MouseWheelEvent)mouseEvent).getUnitsToScroll() * WHEEL_AMP, mouseEvent.getX(), mouseEvent.getY());
                        }
                        continue block5;
                    }
                }
            }
        } else {
            this.swingEvents.clear();
        }
        this.lastEventX = n;
        this.lastEventY = n2;
        this.wheelDelta = this.currentWheelDelta;
        this.currentWheelDelta = 0;
        this.deltaPoint.setLocation(this.currentDeltaPoint);
        this.currentDeltaPoint.setLocation(0, 0);
    }

    public void setCursorVisible(boolean bl) {
    }

    public boolean isCursorVisible() {
        return true;
    }

    public void setHardwareCursor(URL uRL) {
    }

    public void setHardwareCursor(URL uRL, int n, int n2) {
    }

    public void setHardwareCursor(URL uRL, Image[] imageArray, int[] nArray, int n, int n2) {
    }

    public int getWheelRotation() {
        return this.wheelRotation;
    }

    public int getButtonCount() {
        return 3;
    }

    public void setRelativeDelta(Component component) {
        this.deltaRelative = component;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isDragOnly() {
        return this.dragOnly;
    }

    public void setDragOnly(boolean bl) {
        this.dragOnly = bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return;
        }
        this.lastPoint.setLocation(mouseEvent.getPoint());
        this.buttons.set(this.getJMEButtonIndex(mouseEvent), true);
        this.swingEvents.add(mouseEvent);
    }

    private int getJMEButtonIndex(MouseEvent mouseEvent) {
        int n;
        switch (mouseEvent.getButton()) {
            default: {
                n = 0;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
            }
        }
        return n;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return;
        }
        this.currentDeltaPoint.setLocation(0, 0);
        if (this.deltaRelative != null) {
            this.absPoint.setLocation(this.deltaRelative.getWidth() >> 1, this.deltaRelative.getHeight() >> 1);
        }
        this.buttons.set(this.getJMEButtonIndex(mouseEvent), false);
        this.swingEvents.add(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!this.enabled) {
            return;
        }
        int n = mouseWheelEvent.getUnitsToScroll() * WHEEL_AMP;
        this.currentWheelDelta -= n;
        this.wheelRotation -= n;
        this.swingEvents.add(mouseWheelEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return;
        }
        this.absPoint.setLocation(mouseEvent.getPoint());
        if (this.lastPoint.x == Integer.MIN_VALUE) {
            this.lastPoint.setLocation(this.absPoint.x, this.absPoint.y);
        }
        this.currentDeltaPoint.x = this.absPoint.x - this.lastPoint.x;
        this.currentDeltaPoint.y = -(this.absPoint.y - this.lastPoint.y);
        this.lastPoint.setLocation(mouseEvent.getPoint());
        this.swingEvents.add(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.enabled && !this.dragOnly) {
            this.mouseDragged(mouseEvent);
        }
    }

    public void setCursorPosition(int n, int n2) {
        this.absPoint.setLocation(n, n2);
    }

    public static void setup(Canvas canvas, boolean bl) {
        AWTMouseInput.setProvider("AWT");
        AWTMouseInput aWTMouseInput = (AWTMouseInput)AWTMouseInput.get();
        aWTMouseInput.setEnabled(!bl);
        aWTMouseInput.setDragOnly(bl);
        aWTMouseInput.setRelativeDelta(canvas);
        canvas.addMouseListener(aWTMouseInput);
        canvas.addMouseWheelListener(aWTMouseInput);
        canvas.addMouseMotionListener(aWTMouseInput);
    }
}

