/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.util;

import com.jme.util.geom.BufferUtils;
import com.jmex.audio.AudioBuffer;
import com.jmex.audio.AudioTrack;
import com.jmex.audio.stream.AudioInputStream;
import com.jmex.audio.stream.OggInputStream;
import com.jmex.audio.stream.WavInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.logging.Logger;

public class AudioLoader {
    private static final Logger logger = Logger.getLogger(AudioLoader.class.getName());

    public static void fillBuffer(AudioBuffer audioBuffer, URL uRL) throws IOException {
        if (uRL == null) {
            return;
        }
        AudioTrack.Format format = AudioInputStream.sniffFormat(uRL.openStream());
        if (AudioTrack.Format.WAV.equals((Object)format)) {
            AudioLoader.loadWAV(audioBuffer, uRL);
        } else if (AudioTrack.Format.OGG.equals((Object)format)) {
            AudioLoader.loadOGG(audioBuffer, uRL);
        } else {
            throw new IllegalArgumentException("Given url is not a recognized audio type. Must be OGG or RIFF/WAV: " + uRL);
        }
    }

    private static void loadOGG(AudioBuffer audioBuffer, URL uRL) throws IOException {
        OggInputStream oggInputStream = new OggInputStream(uRL, -1.0f);
        ByteBuffer byteBuffer = AudioLoader.read(oggInputStream);
        int n = oggInputStream.getChannelCount();
        int n2 = oggInputStream.getBitRate();
        int n3 = oggInputStream.getDepth();
        int n4 = byteBuffer.limit();
        float f = (float)n4 / ((float)(n2 * n * n3) * 0.125f);
        audioBuffer.setup(byteBuffer, n, n2, f, n3);
        logger.info("ogg loaded - time: " + f + "  channels: " + n + "  rate: " + n2 + " depth: " + n3 + " bytes: " + n4);
        byteBuffer.clear();
        oggInputStream.close();
    }

    private static void loadWAV(AudioBuffer audioBuffer, URL uRL) throws IOException {
        WavInputStream wavInputStream = new WavInputStream(uRL);
        ByteBuffer byteBuffer = AudioLoader.read(wavInputStream);
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            ShortBuffer shortBuffer = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
            while (shortBuffer.hasRemaining()) {
                byteBuffer.putShort(shortBuffer.get());
            }
            byteBuffer.rewind();
        }
        int n = wavInputStream.getChannelCount();
        int n2 = wavInputStream.getBitRate();
        int n3 = wavInputStream.getDepth();
        int n4 = byteBuffer.limit();
        float f = (float)n4 / ((float)(n2 * n * n3) * 0.125f);
        audioBuffer.setup(byteBuffer, n, n2, f, n3);
        logger.info("wav loaded - time: " + f + "  channels: " + n + "  rate: " + n2 + " depth: " + n3 + " bytes: " + n4);
        byteBuffer.clear();
        wavInputStream.close();
    }

    private static ByteBuffer read(AudioInputStream audioInputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(262144);
        byte[] byArray = new byte[4096];
        do {
            if ((n = audioInputStream.read(byArray, 0, byArray.length)) <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, n);
        } while (n > 0);
        int n2 = byteArrayOutputStream.size();
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n2);
        byteBuffer.put(byteArrayOutputStream.toByteArray());
        byteBuffer.flip();
        return byteBuffer;
    }
}

