/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.stream;

import com.jmex.audio.filter.Filter;
import com.jmex.audio.stream.AudioInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class WavInputStream
extends AudioInputStream {
    private static final int RIFFid = 1380533830;
    private static final int WAVEid = 1463899717;
    private static final int fmtid = 1718449184;
    private static final int dataid = 1684108385;
    private int numChannels;
    private int sampleDepth;
    private int sampleRate;
    private long fileSize;
    private long headerSize;
    private DataInputStream dataIn;

    public WavInputStream(URL uRL) throws IOException {
        super(uRL, -1.0f);
        this.dataIn = new DataInputStream(this.in);
        if (this.dataIn.readInt() != 1380533830) {
            throw new IOException("Not a valid RIFF file");
        }
        int n = 0xFF & this.dataIn.readByte();
        int n2 = 0xFF & this.dataIn.readByte();
        int n3 = 0xFF & this.dataIn.readByte();
        int n4 = 0xFF & this.dataIn.readByte();
        this.fileSize = 8L + (long)(n << 0 | n2 << 8 | n3 << 16 | n4 << 24) & 0xFFFFFFFFL;
        if (this.dataIn.readInt() != 1463899717) {
            throw new IOException("Not a valid WAVE file");
        }
        this.headerSize += 12L;
        this.seekAudio();
        this.setLength((float)(this.fileSize - this.headerSize) * 8.0f / (float)(this.getChannelCount() * this.getBitRate() * this.getDepth()));
    }

    public int read(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        byte[] byArray = new byte[byteBuffer.capacity()];
        int n3 = this.read(byArray, n, n2);
        if (n3 > 0 && this.filters.size() > 0) {
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                byArray = ((Filter)iterator.next()).filter(byArray);
            }
        }
        byteBuffer.put(byArray);
        byteBuffer.position(n);
        return n3;
    }

    public int getChannelCount() {
        return this.numChannels;
    }

    public int getDepth() {
        return this.sampleDepth;
    }

    public int getBitRate() {
        return this.sampleRate;
    }

    public boolean marksupported() {
        return false;
    }

    public void readSample(byte[] byArray, int n, int n2) throws IOException {
        this.in.read(byArray, n * this.numChannels, n2 * this.numChannels);
    }

    public void readSample(short[] sArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this.numChannels; ++j) {
                sArray[j + (n + i) * this.numChannels] = this.readShort();
            }
        }
    }

    public void readSample(int[] nArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this.numChannels; ++j) {
                nArray[nArray[j + (n + i) * this.numChannels]] = this.readInt();
            }
        }
    }

    private short readShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return (short)(n | n2 << 8);
    }

    private int readInt() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n4 == -1) {
            throw new EOFException();
        }
        return n | n2 << 8 | n3 << 16 | n4 << 24;
    }

    private void readfmt(int n) throws IOException {
        if (this.readShort() != 1) {
            throw new IOException("Can only read PCM files");
        }
        this.numChannels = this.readShort();
        this.sampleRate = this.readInt();
        this.dataIn.readInt();
        this.dataIn.readShort();
        this.sampleDepth = this.readShort();
        this.headerSize += 16L;
        if (this.sampleDepth != 8 && this.sampleDepth != 16 && this.sampleDepth != 32) {
            throw new IOException("Only 8, 16, or 32 bit samples are handled");
        }
        int n2 = 16;
        while (n > n2) {
            this.read();
            ++n2;
            ++this.headerSize;
        }
    }

    private void seekAudio() throws IOException {
        block4: while (true) {
            int n = this.dataIn.readInt();
            int n2 = this.readInt();
            this.headerSize += 8L;
            switch (n) {
                case 1718449184: {
                    this.readfmt(n2);
                    continue block4;
                }
                case 1684108385: {
                    return;
                }
            }
            if (this.in.skip(n2) != (long)n2) {
                throw new IOException("Input didn't fully skip chunk");
            }
            this.headerSize += (long)n2;
        }
    }

    public WavInputStream makeNew() throws IOException {
        WavInputStream wavInputStream = new WavInputStream(this.getResource());
        wavInputStream.filters.addAll(this.filters);
        return wavInputStream;
    }
}

