/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.stream;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.jmex.audio.filter.Filter;
import com.jmex.audio.stream.AudioInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OggInputStream
extends AudioInputStream {
    private static final Logger logger = Logger.getLogger(OggInputStream.class.getName());
    private float[][][] _pcm = new float[1][][];
    private int[] _index;
    private boolean eos = false;
    private SyncState syncState = new SyncState();
    private StreamState streamState = new StreamState();
    private Page page = new Page();
    private Packet packet = new Packet();
    private Info info = new Info();
    private Comment comment = new Comment();
    private DspState dspState = new DspState();
    private Block block = new Block(this.dspState);
    private int convsize = 24576;
    private byte[] convbuffer = new byte[this.convsize];
    private int convbufferOff = 0;
    private int convbufferSize = 0;
    private byte[] readDummy = new byte[1];

    public OggInputStream(URL uRL, float f) throws IOException {
        super(uRL, f);
        try {
            this.initVorbis();
            this._index = new int[this.info.channels];
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "OggInputStream(URL resource, float lengt)", "Exception", exception);
            this.eos = true;
        }
    }

    public int getBitRate() {
        return this.info.rate;
    }

    public int getDepth() {
        return 16;
    }

    public int read() throws IOException {
        int n = this.read(this.readDummy, 0, 1);
        return n == -1 ? -1 : this.readDummy[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eos) {
            return -1;
        }
        int n3 = 0;
        while (!this.eos && n2 > 0) {
            this.fillConvbuffer();
            if (this.eos) continue;
            int n4 = Math.min(n2, this.convbufferSize - this.convbufferOff);
            System.arraycopy(this.convbuffer, this.convbufferOff, byArray, n, n4);
            this.convbufferOff += n4;
            n3 += n4;
            n2 -= n4;
            n += n4;
        }
        return n3;
    }

    public int read(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        byte[] byArray = new byte[byteBuffer.capacity()];
        int n3 = this.read(byArray, n, n2);
        if (n3 > 0 && this.filters.size() > 0) {
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                byArray = ((Filter)iterator.next()).filter(byArray);
            }
        }
        byteBuffer.put(byArray);
        byteBuffer.position(n);
        return n3;
    }

    private void fillConvbuffer() throws IOException {
        if (this.convbufferOff >= this.convbufferSize) {
            this.convbufferSize = this.lazyDecodePacket();
            this.convbufferOff = 0;
            if (this.convbufferSize == -1) {
                this.eos = true;
            }
        }
    }

    public int available() throws IOException {
        return this.eos ? 0 : 1;
    }

    public void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public long skip(long l) throws IOException {
        int n;
        int n2 = 0;
        while ((long)n2 < l && (n = this.read()) != -1) {
            ++n2;
        }
        return n2;
    }

    private void initVorbis() throws Exception {
        this.syncState.init();
        int n = this.syncState.buffer(4096);
        byte[] byArray = this.syncState.data;
        int n2 = this.in.read(byArray, n, 4096);
        this.syncState.wrote(n2);
        if (this.syncState.pageout(this.page) != 1) {
            if (n2 < 4096) {
                return;
            }
            throw new Exception("Input does not appear to be an Ogg bitstream.");
        }
        this.streamState.init(this.page.serialno());
        this.info.init();
        this.comment.init();
        if (this.streamState.pagein(this.page) < 0) {
            throw new Exception("Error reading first page of Ogg bitstream data.");
        }
        if (this.streamState.packetout(this.packet) != 1) {
            throw new Exception("Error reading initial header packet.");
        }
        if (this.info.synthesis_headerin(this.comment, this.packet) < 0) {
            throw new Exception("This Ogg bitstream does not contain Vorbis audio data.");
        }
        int n3 = 0;
        while (n3 < 2) {
            int n4;
            while (n3 < 2 && (n4 = this.syncState.pageout(this.page)) != 0) {
                if (n4 != 1) continue;
                this.streamState.pagein(this.page);
                while (n3 < 2 && (n4 = this.streamState.packetout(this.packet)) != 0) {
                    if (n4 == -1) {
                        throw new Exception("Corrupt secondary header. Exiting.");
                    }
                    this.info.synthesis_headerin(this.comment, this.packet);
                    ++n3;
                }
            }
            byArray = this.syncState.data;
            n = this.syncState.buffer(4096);
            n2 = this.in.read(byArray, n, 4096);
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 == 0 && n3 < 2) {
                throw new Exception("End of file before finding all Vorbis headers!");
            }
            this.syncState.wrote(n2);
        }
        this.convsize = 4096 / this.info.channels;
        this.dspState.synthesis_init(this.info);
        this.block.init(this.dspState);
    }

    private int decodePacket(Packet packet) {
        int n;
        boolean bl;
        boolean bl2 = bl = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        if (this.block.synthesis(packet) == 0) {
            this.dspState.synthesis_blockin(this.block);
        }
        int n2 = 0;
        while ((n = this.dspState.synthesis_pcmout(this._pcm, this._index)) > 0) {
            float[][] fArray = this._pcm[0];
            int n3 = n < this.convsize ? n : this.convsize;
            for (int i = 0; i < this.info.channels; ++i) {
                int n4 = (i << 1) + n2;
                int n5 = this._index[i];
                for (int j = 0; j < n3; ++j) {
                    int n6 = (int)((double)fArray[i][n5 + j] * 32767.0);
                    this.convbuffer[n4 + 0] = (byte)(bl ? n6 >>> 8 : (n6 |= (n6 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n6))) < 0 ? 32768 : 0));
                    this.convbuffer[n4 + 1] = (byte)(bl ? n6 : n6 >>> 8);
                    n4 += this.info.channels << 1;
                }
            }
            n2 += 2 * this.info.channels * n3;
            this.dspState.synthesis_read(n3);
        }
        return n2;
    }

    private int lazyDecodePacket() throws IOException {
        int n = this.getNextPacket(this.packet);
        if (n == -1) {
            return -1;
        }
        return this.decodePacket(this.packet);
    }

    private int getNextPacket(Packet packet) throws IOException {
        boolean bl = false;
        while (!this.eos && !bl) {
            int n = this.streamState.packetout(packet);
            if (n == 0) {
                int n2 = 0;
                while (!this.eos && n2 == 0) {
                    n2 = this.syncState.pageout(this.page);
                    if (n2 != 0) continue;
                    this.fetchData();
                }
                if (n2 == 0 && this.page.eos() != 0) {
                    return -1;
                }
                if (n2 == 0) {
                    this.fetchData();
                    continue;
                }
                if (n2 == -1) {
                    logger.info("syncState.pageout(page) result == -1");
                    return -1;
                }
                this.streamState.pagein(this.page);
                continue;
            }
            if (n == -1) {
                logger.info("streamState.packetout(packet) result == -1");
                return -1;
            }
            bl = true;
        }
        return 0;
    }

    private void fetchData() throws IOException {
        if (!this.eos) {
            int n = this.syncState.buffer(4096);
            if (n < 0) {
                this.eos = true;
                return;
            }
            int n2 = this.in.read(this.syncState.data, n, 4096);
            this.syncState.wrote(n2);
            if (n2 == 0) {
                this.eos = true;
            }
        }
    }

    public String toString() {
        String string = "";
        string = string + "version         " + this.info.version + "\n";
        string = string + "channels        " + this.info.channels + "\n";
        string = string + "rate (hz)       " + this.info.rate;
        return string;
    }

    public int getChannelCount() {
        return this.info.channels;
    }

    public OggInputStream makeNew() throws IOException {
        return new OggInputStream(this.getResource(), this.getLength());
    }
}

