/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.openal;

import com.jme.math.Vector3f;
import com.jme.util.geom.BufferUtils;
import com.jmex.audio.AudioSystem;
import com.jmex.audio.AudioTrack;
import com.jmex.audio.openal.OpenALPropertyTool;
import com.jmex.audio.openal.OpenALSource;
import com.jmex.audio.openal.OpenALSystem;
import com.jmex.audio.player.StreamedAudioPlayer;
import com.jmex.audio.stream.AudioInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.openal.AL10;

public class OpenALStreamedAudioPlayer
extends StreamedAudioPlayer {
    private static final Logger logger = Logger.getLogger(OpenALStreamedAudioPlayer.class.getName());
    private static int BUFFER_SIZE = 262144;
    private int BUFFER_COUNT = 4;
    private ByteBuffer dataBuffer = ByteBuffer.allocateDirect(BUFFER_SIZE);
    private IntBuffer buffers = BufferUtils.createIntBuffer(this.BUFFER_COUNT);
    private IntBuffer idBuffer = BufferUtils.createIntBuffer(1);
    private ArrayList<Integer> openBuffers = new ArrayList(this.BUFFER_COUNT);
    private PlayerThread playerThread = null;
    private boolean initalized = false;
    private OpenALSource source;
    private boolean isPaused = false;
    private boolean isStopped = false;

    public OpenALStreamedAudioPlayer(AudioInputStream audioInputStream, AudioTrack audioTrack) {
        super(audioInputStream, audioTrack);
    }

    public void init() {
        this.buffers.clear();
        for (int i = 0; i < this.BUFFER_COUNT; ++i) {
            this.idBuffer.clear();
            try {
                AL10.alGenBuffers(this.idBuffer);
            }
            catch (Exception exception) {
                this.BUFFER_COUNT = i + 1;
                break;
            }
            int n = this.idBuffer.get(0);
            this.openBuffers.add(n);
            this.buffers.put(i, n);
        }
        this.initalized = true;
    }

    public void cleanup() {
        if (this.initalized) {
            this.stop();
            for (int i = 0; i < this.BUFFER_COUNT; ++i) {
                this.idBuffer.clear();
                this.idBuffer.put(this.buffers.get(i));
                try {
                    AL10.alDeleteBuffers(this.idBuffer);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        OpenALStreamedAudioPlayer openALStreamedAudioPlayer = this;
        synchronized (openALStreamedAudioPlayer) {
            if (this.source == null) {
                return;
            }
            this.isStopped = true;
            AL10.alSourceStop(this.source.getId());
            this.empty();
            for (int i = 0; i < this.BUFFER_COUNT; ++i) {
                if (this.openBuffers.contains(this.buffers.get(i))) continue;
                this.openBuffers.add(this.buffers.get(i));
            }
            this.source = null;
            this.getTrack().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        OpenALStreamedAudioPlayer openALStreamedAudioPlayer = this;
        synchronized (openALStreamedAudioPlayer) {
            if (this.isPaused) {
                this.isPaused = false;
                AL10.alSourcePlay(this.source.getId());
                this.setStartTime(this.getStartTime() + System.currentTimeMillis() - this.getPauseTime());
                return;
            }
            this.source = ((OpenALSystem)AudioSystem.getSystem()).getNextFreeSource();
            if (this.source == null) {
                return;
            }
            this.source.setTrack(this.getTrack());
            this.applyTrackProperties();
            try {
                this.setStream(this.getStream().makeNew());
            }
            catch (IOException iOException) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "play()", "Exception", iOException);
                return;
            }
            AL10.alSource3f(this.source.getId(), 4100, 0.0f, 0.0f, 0.0f);
            AL10.alSource3f(this.source.getId(), 4102, 0.0f, 0.0f, 0.0f);
            AL10.alSource3f(this.source.getId(), 4101, 0.0f, 0.0f, 0.0f);
            AL10.alSourcei(this.source.getId(), 514, this.getTrack().isRelative() ? 1 : 0);
            this.playInNewThread(200L);
        }
    }

    public void pause() {
        this.isPaused = true;
        AL10.alSourcePause(this.source.getId());
        this.setPauseTime(System.currentTimeMillis());
    }

    public boolean playStream() {
        this.isStopped = false;
        if (this.isPlaying()) {
            return true;
        }
        if (this.openBuffers.size() > 0) {
            for (int i = 0; i < this.BUFFER_COUNT; ++i) {
                int n = this.openBuffers.remove(this.openBuffers.size() - 1);
                if (!this.stream(n)) {
                    this.openBuffers.add(n);
                    break;
                }
                this.idBuffer.put(0, n);
                this.idBuffer.rewind();
                AL10.alSourceQueueBuffers(this.source.getId(), this.idBuffer);
            }
        }
        AL10.alSourcePlay(this.source.getId());
        this.setStartTime(System.currentTimeMillis());
        return true;
    }

    public boolean playInNewThread(long l) {
        try {
            if (this.playStream()) {
                this.playerThread = new PlayerThread(l);
                this.playerThread.start();
                return true;
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Audio Error!", exception);
        }
        return false;
    }

    public boolean isPlaying() {
        return this.source != null && this.source.getState() == 4114;
    }

    public boolean isActive() {
        return this.source != null && (this.source.getState() == 4114 || this.source.getState() == 4115);
    }

    public boolean isStopped() {
        return this.source != null && this.source.getState() == 4116;
    }

    public synchronized boolean update() throws IOException {
        if (this.isPaused) {
            return true;
        }
        if (this.isStopped) {
            return false;
        }
        boolean bl = true;
        int n = AL10.alGetSourcei(this.source.getId(), 4118);
        while (n-- > 0) {
            AL10.alSourceUnqueueBuffers(this.source.getId(), this.idBuffer);
            this.openBuffers.add(this.idBuffer.get(0));
            this.idBuffer.rewind();
        }
        boolean bl2 = false;
        if (this.openBuffers.size() > 1) {
            bl2 = true;
        }
        while (this.openBuffers.size() > 0) {
            int n2 = this.openBuffers.remove(0);
            bl = this.stream(n2);
            if (!bl) {
                this.isStopped = true;
                break;
            }
            this.idBuffer.put(0, n2);
            this.idBuffer.rewind();
            AL10.alSourceQueueBuffers(this.source.getId(), this.idBuffer);
        }
        if (bl && bl2 && !this.isPlaying()) {
            AL10.alSourcePlay(this.source.getId());
        }
        return bl;
    }

    protected boolean stream(int n) {
        if (this.isStopped) {
            return false;
        }
        try {
            this.dataBuffer.clear();
            int n2 = this.getStream().read(this.dataBuffer, 0, this.dataBuffer.capacity());
            if (n2 >= 0) {
                boolean bl;
                this.dataBuffer.rewind();
                this.dataBuffer.limit(n2);
                int n3 = 4354;
                boolean bl2 = bl = this.getStream().getChannelCount() == 1;
                if (this.getStream().getDepth() == 8) {
                    n3 = bl ? 4352 : 4354;
                } else if (this.getStream().getDepth() == 16) {
                    n3 = bl ? 4353 : 4355;
                } else {
                    return false;
                }
                AL10.alBufferData(n, n3, this.dataBuffer, this.getStream().getBitRate());
                return true;
            }
            if (this.isLoop() && this.getTrack().isEnabled()) {
                this.setStream(this.getStream().makeNew());
                return this.stream(n);
            }
        }
        catch (IOException iOException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "stream(int buffer)", "Exception", iOException);
        }
        return false;
    }

    protected void empty() {
        int n = AL10.alGetSourcei(this.source.getId(), 4117);
        while (n-- > 0) {
            AL10.alSourceUnqueueBuffers(this.source.getId(), this.idBuffer);
        }
    }

    public void applyTrackProperties() {
        OpenALPropertyTool.applyProperties(this, this.source);
    }

    public void updateTrackPlacement() {
        Vector3f vector3f = this.getTrack().getWorldPosition();
        Vector3f vector3f2 = this.getTrack().getCurrVelocity();
        AL10.alSource3f(this.source.getId(), 4100, vector3f.x, vector3f.y, vector3f.z);
        AL10.alSource3f(this.source.getId(), 4102, vector3f2.x, vector3f2.y, vector3f2.z);
    }

    public void setVolume(float f) {
        super.setVolume(f);
        OpenALPropertyTool.applyChannelVolume(this.source, f);
    }

    public void setPitch(float f) {
        if (f > 0.0f && f <= 2.0f) {
            super.setPitch(f);
            OpenALPropertyTool.applyChannelPitch(this.source, this.getPitch());
        } else {
            logger.warning("Pitch must be > 0 and <= 2.0f");
        }
    }

    public void setMaxAudibleDistance(float f) {
        super.setMaxAudibleDistance(f);
        OpenALPropertyTool.applyChannelMaxAudibleDistance(this.source, f);
    }

    public void setMaxVolume(float f) {
        super.setMaxVolume(f);
        OpenALPropertyTool.applyChannelMaxVolume(this.source, f);
    }

    public void setMinVolume(float f) {
        super.setMinVolume(f);
        OpenALPropertyTool.applyChannelMinVolume(this.source, f);
    }

    public void setReferenceDistance(float f) {
        super.setReferenceDistance(f);
        OpenALPropertyTool.applyChannelReferenceDistance(this.source, f);
    }

    public void setRolloff(float f) {
        super.setRolloff(f);
        OpenALPropertyTool.applyChannelRolloff(this.source, f);
    }

    public int getBitRate() {
        return this.getStream().getBitRate();
    }

    public int getChannels() {
        return this.getStream().getChannelCount();
    }

    public int getDepth() {
        return this.getStream().getDepth();
    }

    class PlayerThread
    extends Thread {
        long interval;

        PlayerThread(long l) {
            this.interval = l;
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (!OpenALStreamedAudioPlayer.this.isStopped && OpenALStreamedAudioPlayer.this.update()) {
                    PlayerThread.sleep(this.interval);
                }
                while (OpenALStreamedAudioPlayer.this.isActive()) {
                    PlayerThread.sleep(this.interval);
                }
                OpenALStreamedAudioPlayer.this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

