/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.openal;

import com.jme.util.geom.BufferUtils;
import com.jmex.audio.AudioBuffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openal.AL10;

public class OpenALAudioBuffer
extends AudioBuffer {
    private int id;
    private ByteBuffer data;

    protected OpenALAudioBuffer(int n) {
        this.id = n;
    }

    public void setup(ByteBuffer byteBuffer, int n, int n2, float f, int n3) {
        super.setup(byteBuffer, n, n2, f, n3);
        this.data = byteBuffer;
        boolean bl = n == 1;
        int n4 = 0;
        if (n3 == 8) {
            n4 = bl ? 4352 : 4354;
        } else if (n3 == 16) {
            n4 = bl ? 4353 : 4355;
        }
        byteBuffer.rewind();
        AL10.alBufferData(this.id, n4, byteBuffer, n2);
    }

    public void delete() {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        intBuffer.put(this.id);
        intBuffer.rewind();
        AL10.alDeleteBuffers(intBuffer);
    }

    public int getBitDepth() {
        return AL10.alGetBufferi(this.id, 8194);
    }

    public int getNumChannels() {
        return AL10.alGetBufferi(this.id, 8195);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getFrequency() {
        return AL10.alGetBufferi(this.id, 8193);
    }

    public int getSize() {
        return AL10.alGetBufferi(this.id, 8196);
    }

    public int getId() {
        return this.id;
    }

    public static OpenALAudioBuffer generateBuffer() {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        AL10.alGenBuffers(intBuffer);
        return new OpenALAudioBuffer(intBuffer.get(0));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.delete();
    }
}

