/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio;

import com.jme.math.FastMath;
import com.jmex.audio.AudioTrack;
import com.jmex.audio.event.TrackStateAdapter;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MusicTrackQueue {
    private RepeatType repeat = RepeatType.ONE;
    private ArrayList<AudioTrack> tracks = new ArrayList();
    private int currentTrack = -1;
    private boolean isPlaying = false;
    private ArrayList<ChangeListener> listListeners = new ArrayList();
    private ArrayList<ChangeListener> songListeners = new ArrayList();
    private float crossfadeoutTime = 3.5f;
    private float crossfadeinTime = 3.5f;

    public void setRepeatType(RepeatType repeatType) {
        this.repeat = repeatType;
    }

    public RepeatType getRepeatType() {
        return this.repeat;
    }

    public void addTrack(AudioTrack audioTrack) {
        if (audioTrack == null) {
            return;
        }
        audioTrack.setType(AudioTrack.TrackType.MUSIC);
        if (!this.tracks.contains(audioTrack)) {
            this.tracks.add(audioTrack);
            this.fireListChanged();
        }
    }

    public void removeTrack(AudioTrack audioTrack) {
        if (audioTrack == null) {
            return;
        }
        audioTrack.stop();
        audioTrack.getPlayer().cleanup();
        this.tracks.remove(audioTrack);
        if (this.isPlaying && this.getCurrentTrack() == audioTrack) {
            this.nextTrack();
        }
        this.fireListChanged();
    }

    private void fireListChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.listListeners.size(); ++i) {
            this.listListeners.get(i).stateChanged(changeEvent);
        }
    }

    private void fireCurrentSongChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.songListeners.size(); ++i) {
            this.songListeners.get(i).stateChanged(changeEvent);
        }
    }

    public ArrayList<AudioTrack> getTrackList() {
        return this.tracks;
    }

    public void clearTracks() {
        this.stop();
        this.tracks.clear();
        this.fireListChanged();
    }

    public void play() {
        this.isPlaying = true;
        if (this.currentTrack < 0 || this.currentTrack >= this.tracks.size()) {
            this.currentTrack = 0;
        }
        if (this.tracks.size() < 1) {
            this.isPlaying = false;
            return;
        }
        AudioTrack audioTrack = this.tracks.get(this.currentTrack);
        if (this.crossfadeinTime > 0.0f) {
            audioTrack.fadeIn(this.crossfadeinTime, audioTrack.getTargetVolume() > 0.0f ? audioTrack.getTargetVolume() : 1.0f);
        } else {
            audioTrack.setVolume(audioTrack.getTargetVolume() > 0.0f ? audioTrack.getTargetVolume() : 1.0f);
        }
        if (!audioTrack.isPlaying()) {
            audioTrack.play();
        }
    }

    public void pause() {
        if (this.currentTrack < 0 || this.currentTrack >= this.tracks.size()) {
            this.currentTrack = 0;
        }
        if (this.tracks.size() < 1) {
            return;
        }
        AudioTrack audioTrack = this.tracks.get(this.currentTrack);
        audioTrack.pause();
    }

    public void stop() {
        if (this.currentTrack < 0 || this.currentTrack >= this.tracks.size()) {
            return;
        }
        if (this.tracks.size() < 1) {
            return;
        }
        AudioTrack audioTrack = this.tracks.get(this.currentTrack);
        audioTrack.stop();
        this.currentTrack = -1;
        this.isPlaying = false;
    }

    public void setCurrentTrack(int n) {
        this.setCurrentTrack(n, true);
    }

    public void setCurrentTrack(AudioTrack audioTrack) {
        int n = this.tracks.indexOf(audioTrack);
        if (n >= 0) {
            this.setCurrentTrack(n);
        }
    }

    public void setCurrentTrack(int n, boolean bl) {
        AudioTrack audioTrack = null;
        if (this.currentTrack >= 0 && this.currentTrack < this.tracks.size()) {
            audioTrack = this.tracks.get(this.currentTrack);
        }
        this.currentTrack = n;
        this.fireCurrentSongChanged();
        if (this.isPlaying && audioTrack != null) {
            if (bl && this.crossfadeoutTime > 0.0f) {
                audioTrack.fadeOut(this.crossfadeoutTime);
                audioTrack.addTrackStateListener(new TrackStateAdapter(){

                    public void trackFinishedFade(AudioTrack audioTrack) {
                        audioTrack.removeTrackStateListener(this);
                        audioTrack.stop();
                        audioTrack.setVolume(1.0f);
                        audioTrack.setTargetVolume(1.0f);
                        MusicTrackQueue.this.fireCurrentSongChanged();
                    }

                    public void trackStopped(AudioTrack audioTrack) {
                        audioTrack.removeTrackStateListener(this);
                        audioTrack.setVolume(1.0f);
                        audioTrack.setTargetVolume(1.0f);
                        MusicTrackQueue.this.fireCurrentSongChanged();
                    }
                });
            } else {
                audioTrack.stop();
            }
            if (n >= 0) {
                this.play();
            }
        }
    }

    public void update(float f) {
        AudioTrack audioTrack = null;
        if (this.currentTrack >= 0 && this.currentTrack < this.tracks.size()) {
            audioTrack = this.getTrack(this.currentTrack);
        }
        if (this.isPlaying) {
            int n = this.getNextTrack();
            if (audioTrack != null && audioTrack.getTotalTime() > 0.0f) {
                if (!audioTrack.isLooping() && n == this.currentTrack) {
                    audioTrack.setLooping(true);
                } else if (audioTrack.isLooping() && n != this.currentTrack) {
                    audioTrack.setLooping(false);
                }
                if (!audioTrack.isLooping() && audioTrack.getTargetVolume() != 0.0f && audioTrack.getTotalTime() - audioTrack.getCurrentTime() <= this.getCrossfadeoutTime()) {
                    this.setCurrentTrack(n, true);
                    this.update(f);
                    return;
                }
            }
            if (audioTrack != null && audioTrack.isStopped()) {
                int n2 = this.currentTrack;
                this.currentTrack = n;
                audioTrack.stop();
                if (n2 == this.currentTrack) {
                    return;
                }
                this.fireCurrentSongChanged();
                if (this.currentTrack != -1) {
                    this.play();
                } else {
                    this.isPlaying = false;
                    this.fireCurrentSongChanged();
                }
            } else if (audioTrack != null && !audioTrack.isPlaying()) {
                this.play();
            } else if (audioTrack == null) {
                this.nextTrack();
            }
        }
    }

    public int getNextTrack() {
        if (RepeatType.ONE.equals((Object)this.repeat) && this.currentTrack < this.tracks.size()) {
            return this.currentTrack;
        }
        int n = this.currentTrack + 1;
        if (n >= this.tracks.size()) {
            switch (this.repeat) {
                case NONE: {
                    return -1;
                }
            }
            return 0;
        }
        return n;
    }

    public int getPrevTrack() {
        if (RepeatType.ONE.equals((Object)this.repeat)) {
            return this.currentTrack;
        }
        int n = this.currentTrack - 1;
        if (n < 0) {
            switch (this.repeat) {
                case NONE: {
                    return -1;
                }
            }
            return this.tracks.size() - 1;
        }
        return n;
    }

    public void addSongListChangeListener(ChangeListener changeListener) {
        this.listListeners.add(changeListener);
    }

    public void addCurrentSongChangeListener(ChangeListener changeListener) {
        this.songListeners.add(changeListener);
    }

    public void removeSongListChangeListener(ChangeListener changeListener) {
        this.listListeners.remove(changeListener);
    }

    public void removeCurrentSongChangeListener(ChangeListener changeListener) {
        this.songListeners.remove(changeListener);
    }

    public void clearSongListChangeListeners() {
        this.listListeners.clear();
    }

    public void clearCurrentSongChangeListeners() {
        this.songListeners.clear();
    }

    public void nextTrack() {
        this.setCurrentTrack(this.getNextTrack());
    }

    public void prevTrack() {
        this.setCurrentTrack(this.getPrevTrack());
    }

    public void randomize() {
        this.stop();
        ArrayList<AudioTrack> arrayList = new ArrayList<AudioTrack>();
        while (!this.tracks.isEmpty()) {
            int n = (int)(FastMath.nextRandomFloat() * (float)this.tracks.size());
            arrayList.add(this.tracks.remove(n));
        }
        this.tracks.addAll(arrayList);
        this.fireListChanged();
    }

    public int getCurrentTrackIndex() {
        return this.currentTrack;
    }

    public AudioTrack getTrack(int n) {
        return this.tracks.get(n);
    }

    public AudioTrack getCurrentTrack() {
        if (this.currentTrack < this.tracks.size() && this.currentTrack >= 0) {
            return this.tracks.get(this.currentTrack);
        }
        return null;
    }

    public float getCrossfadeinTime() {
        return this.crossfadeinTime;
    }

    public void setCrossfadeinTime(float f) {
        this.crossfadeinTime = f;
    }

    public float getCrossfadeoutTime() {
        return this.crossfadeoutTime;
    }

    public void setCrossfadeoutTime(float f) {
        this.crossfadeoutTime = f;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void fadeOutAndClear(float f) {
        AudioTrack audioTrack = this.getCurrentTrack();
        if (audioTrack != null) {
            audioTrack.fadeOut(f);
        }
        this.tracks.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepeatType {
        NONE,
        ONE,
        ALL;

    }
}

