/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio;

import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jmex.audio.AudioSystem;
import com.jmex.audio.event.TrackStateListener;
import com.jmex.audio.player.AudioPlayer;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AudioTrack {
    private static final Logger logger = Logger.getLogger(AudioTrack.class.getName());
    private float volume = 1.0f;
    private float targetVolume = 1.0f;
    private float volumeChangeRate = 0.286f;
    private AudioPlayer player = null;
    private boolean relative = false;
    private Vector3f position = new Vector3f();
    private Vector3f lastPosition = new Vector3f();
    private Vector3f currVelocity = new Vector3f();
    private Spatial trackedSpatial;
    private float maxAudibleDistance = 0.0f;
    private float referenceDistance = 0.0f;
    private float rolloff = 0.0f;
    private float pitch = 1.0f;
    private float targetPitch = 1.0f;
    private float pitchChangeRate = 0.286f;
    private float maxVolume = 1.0f;
    private float minVolume = 0.0f;
    private URL resource = null;
    private boolean streaming;
    private boolean enabled = true;
    private TrackType type;
    private ArrayList<TrackStateListener> trackListeners = new ArrayList();

    public AudioTrack(URL uRL, boolean bl) {
        this.resource = uRL;
        this.streaming = bl;
        this.type = TrackType.MUSIC;
    }

    public void pause() {
        if (this.enabled) {
            this.player.pause();
            this.fireTrackPaused();
        }
    }

    public void play() {
        if (this.enabled) {
            try {
                this.player.play();
                this.fireTrackPlayed();
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "play()", "Exception", exception);
            }
        }
    }

    public void stop() {
        this.player.stop();
        this.fireTrackStopped();
    }

    public void setLooping(boolean bl) {
        this.player.loop(bl);
    }

    private void fireTrackPlayed() {
        for (int i = 0; i < this.trackListeners.size(); ++i) {
            this.trackListeners.get(i).trackPlayed(this);
        }
    }

    private void fireTrackPaused() {
        for (int i = 0; i < this.trackListeners.size(); ++i) {
            this.trackListeners.get(i).trackPaused(this);
        }
    }

    private void fireTrackStopped() {
        for (int i = 0; i < this.trackListeners.size(); ++i) {
            this.trackListeners.get(i).trackStopped(this);
        }
    }

    private void fireFinishedFade() {
        for (int i = 0; i < this.trackListeners.size(); ++i) {
            this.trackListeners.get(i).trackFinishedFade(this);
        }
    }

    public void addTrackStateListener(TrackStateListener trackStateListener) {
        this.trackListeners.add(trackStateListener);
    }

    public void removeTrackStateListener(TrackStateListener trackStateListener) {
        this.trackListeners.remove(trackStateListener);
    }

    public void clearTrackStateListeners() {
        this.trackListeners.clear();
    }

    public boolean isLooping() {
        return this.player.isLoop();
    }

    public void unmute() {
        this.setVolume(this.volume);
    }

    public void mute() {
        if (this.enabled) {
            this.setVolume(0.0f);
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.volume = f;
        this.player.setVolume(f);
    }

    public void fadeOut(float f) {
        this.targetVolume = 0.0f;
        this.volumeChangeRate = (this.volume - this.targetVolume) / f;
    }

    public void fadeIn(float f, float f2) {
        this.setVolume(0.0f);
        this.targetVolume = f2;
        this.volumeChangeRate = f2 / f;
    }

    public void fadePitch(float f, float f2, float f3) {
        this.setPitch(f2);
        this.targetPitch = f3;
        this.pitchChangeRate = (f3 - f2) / f;
        if (f3 < this.pitch) {
            this.pitchChangeRate = -this.pitchChangeRate;
        }
    }

    public void fadePitch(float f, float f2) {
        this.fadePitch(f, this.getPitch(), f2);
    }

    public AudioPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(AudioPlayer audioPlayer) {
        this.player = audioPlayer;
    }

    public boolean isPlaying() {
        return this.player.isPlaying();
    }

    public boolean isActive() {
        return this.player.isActive();
    }

    public boolean isStopped() {
        return this.player.isStopped();
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }

    public Vector3f getWorldPosition() {
        return this.position;
    }

    public float getCurrentTime() {
        return this.player.getCurrentTime();
    }

    public void setWorldPosition(Vector3f vector3f) {
        this.setWorldPosition(vector3f.x, vector3f.y, vector3f.z);
    }

    public void setWorldPosition(float f, float f2, float f3) {
        this.lastPosition.set(this.position);
        this.position.set(f, f2, f3);
    }

    public Vector3f getCurrVelocity() {
        return this.currVelocity;
    }

    public void setCurrVelocity(Vector3f vector3f) {
        this.currVelocity.set(vector3f);
    }

    public void track(Spatial spatial) {
        this.trackedSpatial = spatial;
        spatial.updateWorldVectors();
        this.update(1.0f);
    }

    public void update(float f) {
        if (f < 1.1920929E-7f) {
            f = 1.1920929E-7f;
        }
        if (this.volume != this.targetVolume) {
            if (this.volume < this.targetVolume) {
                this.volume += this.volumeChangeRate * f;
                if (this.volume > this.targetVolume) {
                    this.volume = this.targetVolume;
                }
            } else {
                this.volume -= this.volumeChangeRate * f;
                if (this.volume < this.targetVolume) {
                    this.volume = this.targetVolume;
                }
            }
            if (this.volume < 0.0f || this.volume > 1.0f) {
                this.volume = this.targetVolume;
            }
            this.setVolume(this.volume);
            if (this.volume == this.targetVolume) {
                this.fireFinishedFade();
            }
        }
        if (this.pitch != this.targetPitch) {
            if (this.pitch < this.targetPitch) {
                this.pitch += this.pitchChangeRate * f;
                if (this.pitch > this.targetPitch) {
                    this.pitch = this.targetPitch;
                }
            } else {
                this.pitch -= this.pitchChangeRate * f;
                if (this.pitch < this.targetPitch) {
                    this.pitch = this.targetPitch;
                }
            }
            this.setPitch(this.pitch);
        }
        if (!this.isPlaying()) {
            return;
        }
        if (this.trackedSpatial != null) {
            this.setWorldPosition(this.trackedSpatial.getWorldTranslation());
            this.currVelocity.set(this.getWorldPosition()).subtractLocal(this.lastPosition).divideLocal(f * AudioSystem.getSystem().getUnitsPerMeter());
        }
        this.player.updateTrackPlacement();
    }

    public float getMaxAudibleDistance() {
        return this.maxAudibleDistance;
    }

    public void setMaxAudibleDistance(float f) {
        this.maxAudibleDistance = f;
        this.player.setMaxAudibleDistance(f);
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float f) {
        this.pitch = f;
        this.player.setPitch(f);
    }

    public float getMaxVolume() {
        return this.maxVolume;
    }

    public void setMaxVolume(float f) {
        this.maxVolume = f;
        this.player.setMaxVolume(f);
    }

    public float getMinVolume() {
        return this.minVolume;
    }

    public void setMinVolume(float f) {
        this.minVolume = f;
        this.player.setMinVolume(f);
    }

    public float getReferenceDistance() {
        return this.referenceDistance;
    }

    public void setReferenceDistance(float f) {
        this.referenceDistance = f;
        this.player.setReferenceDistance(f);
    }

    public float getRolloff() {
        return this.rolloff;
    }

    public void setRolloff(float f) {
        this.rolloff = f;
        this.player.setRolloff(f);
    }

    public void autosetRolloff() {
        float f = (float)(Math.pow(10.0, 0.95f) * (double)this.getReferenceDistance());
        this.setRolloff(f /= this.getMaxAudibleDistance() - this.getReferenceDistance());
    }

    public URL getResource() {
        return this.resource;
    }

    public void setResource(URL uRL) {
        this.resource = uRL;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public float getTargetVolume() {
        return this.targetVolume;
    }

    public void setTargetVolume(float f) {
        this.targetVolume = f;
    }

    public float getVolumeChangeRate() {
        return this.volumeChangeRate;
    }

    public void setVolumeChangeRate(float f) {
        this.volumeChangeRate = f;
    }

    public float getTargetPitch() {
        return this.targetPitch;
    }

    public void setTargetPitch(float f) {
        this.targetPitch = f;
    }

    public float getPitchChangeRate() {
        return this.pitchChangeRate;
    }

    public void setPitchChangeRate(float f) {
        this.pitchChangeRate = f;
    }

    public float getTotalTime() {
        return this.player.getLength();
    }

    public TrackType getType() {
        return this.type;
    }

    public void setType(TrackType trackType) {
        this.type = trackType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TrackType {
        MUSIC,
        ENVIRONMENT,
        POSITIONAL,
        HEADSPACE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        WAV,
        OGG;

    }
}

