/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio;

import com.jmex.audio.AudioTrack;
import com.jmex.audio.Ear;
import com.jmex.audio.EnvironmentalPool;
import com.jmex.audio.MusicTrackQueue;
import com.jmex.audio.openal.OpenALSystem;
import java.net.URL;

public abstract class AudioSystem {
    private static AudioSystem system;
    private MusicTrackQueue musicQueue = new MusicTrackQueue();
    private EnvironmentalPool envPool = new EnvironmentalPool();
    private float unitsPerMeter = 10.0f;

    public static synchronized AudioSystem getSystem() {
        try {
            if (system == null) {
                system = new OpenALSystem();
            }
        }
        catch (RuntimeException runtimeException) {
            system = null;
        }
        return system;
    }

    public abstract Ear getEar();

    public abstract void update();

    public abstract AudioTrack createAudioTrack(URL var1, boolean var2);

    public abstract AudioTrack createAudioTrack(String var1, boolean var2);

    public abstract void setMasterGain(float var1);

    public abstract void setDopplerFactor(float var1);

    public abstract void setSpeedOfSound(float var1);

    public static boolean isCreated() {
        return system != null;
    }

    public MusicTrackQueue getMusicQueue() {
        return this.musicQueue;
    }

    public EnvironmentalPool getEnvironmentalPool() {
        return this.envPool;
    }

    public float getUnitsPerMeter() {
        return this.unitsPerMeter;
    }

    public void setUnitsPerMeter(float f) {
        this.unitsPerMeter = f;
    }

    public void cleanup() {
        system = null;
    }

    public void fadeOutAndClear(float f) {
        if (this.musicQueue != null) {
            this.musicQueue.fadeOutAndClear(f);
        }
        if (this.envPool != null) {
            this.envPool.fadeOutAndClear(f);
        }
    }
}

